/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.BinaryBuilderValue;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.JsonEncodeContext;
import com.caucho.quercus.env.LargeStringBuilderValue;
import com.caucho.quercus.env.LongCacheValue;
import com.caucho.quercus.env.NumberValue;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.ValueType;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.IdentityHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongValue
extends NumberValue {
    public static final LongValue MINUS_ONE;
    public static final LongValue ZERO;
    public static final LongValue ONE;
    public static final int STATIC_MIN = -1024;
    public static final int STATIC_MAX = 16384;
    public static final LongCacheValue[] STATIC_VALUES;
    private final long _value;

    public LongValue(long value) {
        this._value = value;
    }

    public static LongValue create(long value) {
        if (-1024L <= value && value <= 16384L) {
            return STATIC_VALUES[(int)(value - -1024L)];
        }
        return new LongValue(value);
    }

    public static LongValue create(Number value) {
        if (value == null) {
            return ZERO;
        }
        return LongValue.create(value.longValue());
    }

    @Override
    public String getType() {
        return "integer";
    }

    @Override
    public ValueType getValueType() {
        return ValueType.LONG;
    }

    @Override
    public boolean isLongConvertible() {
        return true;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public boolean isLong() {
        return true;
    }

    @Override
    public boolean isDouble() {
        return false;
    }

    public boolean isScalar() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this._value == 0L;
    }

    @Override
    public int toDoubleMarshalCost() {
        return 200;
    }

    @Override
    public int toLongMarshalCost() {
        return 100;
    }

    @Override
    public int toIntegerMarshalCost() {
        return 101;
    }

    @Override
    public int toShortMarshalCost() {
        return 300;
    }

    @Override
    public int toByteMarshalCost() {
        return 300;
    }

    @Override
    public boolean toBoolean() {
        return this._value != 0L;
    }

    @Override
    public long toLong() {
        return this._value;
    }

    @Override
    public double toDouble() {
        return this._value;
    }

    public String toString() {
        return String.valueOf(this._value);
    }

    @Override
    public StringValue toStringBuilder(Env env) {
        return env.createUnicodeBuilder().append(this._value);
    }

    @Override
    public LongValue toLongValue() {
        return this;
    }

    @Override
    public Value toKey() {
        return this;
    }

    public Object toObject() {
        return String.valueOf(this._value);
    }

    @Override
    public Object toJavaObject() {
        return new Long(this._value);
    }

    @Override
    public Value neg() {
        return LongValue.create(-this._value);
    }

    @Override
    public Value pos() {
        return this;
    }

    @Override
    public Value addOne() {
        long newValue = this._value + 1L;
        return LongValue.create(newValue);
    }

    @Override
    public Value subOne() {
        long newValue = this._value - 1L;
        return LongValue.create(newValue);
    }

    @Override
    public Value preincr() {
        long newValue = this._value + 1L;
        return LongValue.create(newValue);
    }

    @Override
    public Value predecr() {
        long newValue = this._value - 1L;
        return LongValue.create(newValue);
    }

    @Override
    public Value postincr() {
        long newValue = this._value + 1L;
        return LongValue.create(newValue);
    }

    @Override
    public Value postdecr() {
        long newValue = this._value - 1L;
        return LongValue.create(newValue);
    }

    @Override
    public Value increment(int incr) {
        long newValue = this._value + (long)incr;
        return LongValue.create(newValue);
    }

    @Override
    public Value add(Value value) {
        return value.add(this._value);
    }

    @Override
    public Value add(long lLong) {
        return LongValue.create(lLong + this._value);
    }

    @Override
    public Value sub(Value rValue) {
        if (rValue.isLongConvertible()) {
            return LongValue.create(this._value - rValue.toLong());
        }
        return DoubleValue.create((double)this._value - rValue.toDouble());
    }

    @Override
    public Value sub(long rLong) {
        return LongValue.create(this._value - rLong);
    }

    @Override
    public Value abs() {
        if (this._value >= 0L) {
            return this;
        }
        return LongValue.create(-this._value);
    }

    @Override
    public boolean eql(Value rValue) {
        if (!((rValue = rValue.toValue()) instanceof LongValue)) {
            return false;
        }
        long rLong = ((LongValue)rValue)._value;
        return this._value == rLong;
    }

    @Override
    public int cmp(Value rValue) {
        if (rValue.isBoolean()) {
            boolean lBool = this.toBoolean();
            boolean rBool = rValue.toBoolean();
            if (!lBool && rBool) {
                return -1;
            }
            if (lBool && !rBool) {
                return 1;
            }
            return 0;
        }
        long l = this._value;
        double r = rValue.toDouble();
        if ((double)l == r) {
            return 0;
        }
        if ((double)l < r) {
            return -1;
        }
        return 1;
    }

    @Override
    public long nextIndex(long oldIndex) {
        if (oldIndex <= this._value) {
            return this._value + 1L;
        }
        return oldIndex;
    }

    @Override
    public void jsonEncode(Env env, JsonEncodeContext context, StringValue sb) {
        if (this._value > Integer.MAX_VALUE && context.isBigIntAsString()) {
            this.toStringValue(env).jsonEncode(env, context, sb);
        } else {
            sb.append(this.toStringValue(env));
        }
    }

    @Override
    public void print(Env env) {
        env.print(this._value);
    }

    @Override
    public StringValue appendTo(UnicodeBuilderValue sb) {
        return sb.append(this._value);
    }

    @Override
    public StringValue appendTo(BinaryBuilderValue sb) {
        return sb.append(this._value);
    }

    @Override
    public StringValue appendTo(StringBuilderValue sb) {
        return sb.append(this._value);
    }

    @Override
    public StringValue appendTo(LargeStringBuilderValue sb) {
        return sb.append(this._value);
    }

    @Override
    public void serialize(Env env, StringBuilder sb) {
        sb.append("i:");
        sb.append(this._value);
        sb.append(";");
    }

    @Override
    protected void varExportImpl(StringValue sb, int level) {
        sb.append(this._value);
    }

    @Override
    public void generate(PrintWriter out) throws IOException {
        if (this._value == 0L) {
            out.print("LongValue.ZERO");
        } else if (this._value == 1L) {
            out.print("LongValue.ONE");
        } else if (this._value == -1L) {
            out.print("LongValue.MINUS_ONE");
        } else if (-1024L <= this._value && this._value <= 16384L) {
            out.print("LongValue.STATIC_VALUES[" + (this._value - -1024L) + "]");
        } else {
            out.print("new LongValue(" + this._value + "L)");
        }
    }

    @Override
    public final int hashCode() {
        long v = this._value;
        return (int)(17L * v + 65537L * (v >> 32));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LongValue)) {
            return false;
        }
        LongValue value = (LongValue)o;
        return this._value == value._value;
    }

    @Override
    public void varDumpImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        out.print("int(" + this.toLong() + ")");
    }

    private Object readResolve() {
        if (-1024L <= this._value && this._value <= 16384L) {
            return STATIC_VALUES[(int)(this._value - -1024L)];
        }
        return this;
    }

    static {
        STATIC_VALUES = new LongCacheValue[17409];
        try {
            for (int i = 16384; i >= -1024; --i) {
                LongCacheValue value;
                LongValue.STATIC_VALUES[i - -1024] = value = new LongCacheValue(i, LongValue.create(i + 1));
                if (i >= 16384) continue;
                STATIC_VALUES[i - -1024 + 1].setPrev(value);
            }
            STATIC_VALUES[0].setPrev(LongValue.create(-1025L));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ZERO = LongValue.create(0L);
        ONE = LongValue.create(1L);
        MINUS_ONE = LongValue.create(-1L);
    }
}

