/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.QuercusException;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.JavaValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.ObjectExtValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.program.JavaClassDef;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.IdentityHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectExtJavaValue
extends ObjectExtValue
implements Serializable {
    private Object _object;
    private final JavaClassDef _javaClassDef;

    public ObjectExtJavaValue(Env env, QuercusClass cl, Object object, JavaClassDef javaClassDef) {
        super(env, cl);
        this._object = object;
        this._javaClassDef = javaClassDef;
    }

    @Override
    protected Value getFieldExt(Env env, StringValue name) {
        Value parentValue;
        if (this._object == null) {
            this._object = this.createJavaObject(env);
        }
        if ((parentValue = super.getFieldExt(env, name)) != NullValue.NULL && parentValue != UnsetValue.UNSET) {
            return parentValue;
        }
        Value value = this._javaClassDef.getField(env, this, name);
        Value quercusValue = this._quercusClass.getField(env, this, name);
        if (quercusValue != null && quercusValue != UnsetValue.UNSET && quercusValue != NullValue.NULL) {
            return quercusValue;
        }
        if (value != null) {
            return value;
        }
        return super.getFieldExt(env, name);
    }

    @Override
    protected Value putFieldExt(Env env, StringValue name, Value value) {
        if (this._object == null) {
            this.createJavaObject(env);
        }
        return this._javaClassDef.putField(env, this, name, value);
    }

    @Override
    public Object toJavaObject() {
        if (this._object == null) {
            this._object = this.createJavaObject(Env.getInstance());
        }
        return this._object;
    }

    @Override
    public void setJavaObject(Object obj) {
        this._object = obj;
    }

    private Object createJavaObject(Env env) {
        Value javaWrapper = this._javaClassDef.callNew(env, Value.NULL_ARGS);
        return javaWrapper.toJavaObject();
    }

    @Override
    public void varDumpImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        if (this._object == null) {
            this._object = this.createJavaObject(Env.getInstance());
        }
        if (!this._javaClassDef.varDumpImpl(env, this, this._object, out, depth, valueSet)) {
            super.varDumpImpl(env, out, depth, valueSet);
        }
    }

    @Override
    protected void printRImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        if (this._object == null) {
            this._object = this.createJavaObject(Env.getInstance());
        }
        this._javaClassDef.printRImpl(env, this._object, out, depth, valueSet);
    }

    @Override
    public StringValue toString(Env env) {
        AbstractFunction toString = this._quercusClass.getToString();
        if (toString != null) {
            return toString.callMethod(env, this._quercusClass, (Value)this).toStringValue();
        }
        if (this._javaClassDef.getToString() != null) {
            JavaValue value = new JavaValue(env, this._object, this._javaClassDef);
            return this._javaClassDef.toString(env, value);
        }
        return env.createString(this._className + "[]");
    }

    @Override
    public Value clone(Env env) {
        Object obj = null;
        if (this._object != null) {
            if (!(this._object instanceof Cloneable)) {
                return env.error(L.l("Java class {0} does not implement Cloneable", (Object)this._object.getClass().getName()));
            }
            Class<?> cls = this._javaClassDef.getType();
            try {
                Method method = cls.getMethod("clone", new Class[0]);
                method.setAccessible(true);
                obj = method.invoke(this._object, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                throw new QuercusException(e);
            }
            catch (InvocationTargetException e) {
                throw new QuercusException(e.getCause());
            }
            catch (IllegalAccessException e) {
                throw new QuercusException(e);
            }
        }
        ObjectExtJavaValue newObject = new ObjectExtJavaValue(env, this._quercusClass, obj, this._javaClassDef);
        this.clone(env, newObject);
        return newObject;
    }
}

