/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.CopyRoot;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.util.FreeList;
import java.lang.ref.SoftReference;

public class UnserializeCacheEntry {
    private FreeList<SoftReference<CopyRoot>> _freeList;
    private SoftReference<Value> _valueRef;

    public UnserializeCacheEntry(Value value) {
        this._valueRef = new SoftReference<Value>(value);
    }

    public UnserializeCacheEntry(Env env, Value value) {
        CopyRoot root = new CopyRoot(this);
        value = value.copyTree(env, root);
        this._valueRef = new SoftReference<Value>(value);
    }

    public Value getValue(Env env) {
        CopyRoot copy;
        SoftReference<CopyRoot> copyRef = null;
        if (this._freeList != null) {
            copyRef = this._freeList.allocate();
        }
        if (copyRef != null && (copy = (CopyRoot)copyRef.get()) != null) {
            copy.allocate(env);
            return copy.getRoot();
        }
        Value value = null;
        if (this._valueRef != null) {
            value = this._valueRef.get();
        }
        if (value != null) {
            CopyRoot root = new CopyRoot(this);
            root.allocate(env);
            Value copy2 = value.copyTree(env, root);
            root.setRoot(copy2);
            return copy2;
        }
        return null;
    }

    public void clear() {
        this._valueRef = null;
        this._freeList = null;
    }

    void free(CopyRoot root) {
        if (this._freeList == null) {
            this._freeList = new FreeList(2);
        }
        this._freeList.free(new SoftReference<CopyRoot>(root));
    }
}

