/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.AbstractVarExpr;
import com.caucho.quercus.expr.Expr;
import com.caucho.util.L10N;

public class BinaryCharAtExpr
extends AbstractVarExpr {
    private static final L10N L = new L10N(BinaryCharAtExpr.class);
    protected final Expr _objExpr;
    protected final Expr _indexExpr;

    public BinaryCharAtExpr(Location location, Expr objExpr, Expr indexExpr) {
        super(location);
        this._objExpr = objExpr;
        this._indexExpr = indexExpr;
    }

    public BinaryCharAtExpr(Expr objExpr, Expr indexExpr) {
        this._objExpr = objExpr;
        this._indexExpr = indexExpr;
    }

    public Value eval(Env env) {
        Value obj = this._objExpr.eval(env);
        return obj.charValueAt(this._indexExpr.evalLong(env));
    }

    public Var evalVar(Env env) {
        return this.eval(env).toVar();
    }

    public Value evalArg(Env env, boolean isTop) {
        return this.eval(env);
    }

    public Value evalAssignRef(Env env, Value value) {
        Value obj = this._objExpr.eval(env);
        Value result = obj.setCharValueAt(this._indexExpr.evalLong(env), value);
        this._objExpr.evalAssignValue(env, result);
        return value;
    }

    public void evalUnset(Env env) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this._objExpr + "{" + this._indexExpr + "}";
    }
}

