/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.parser.QuercusParser;
import com.caucho.util.L10N;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassVirtualMethodVarExpr
extends Expr {
    private static final L10N L = new L10N(ClassVirtualMethodVarExpr.class);
    protected final Expr _methodName;
    protected final Expr[] _args;
    protected Expr[] _fullArgs;
    protected AbstractFunction _fun;
    protected boolean _isMethod;

    public ClassVirtualMethodVarExpr(Location location, Expr methodName, ArrayList<Expr> args) {
        super(location);
        this._methodName = methodName;
        this._args = new Expr[args.size()];
        args.toArray(this._args);
    }

    public ClassVirtualMethodVarExpr(Location location, Expr methodName, Expr[] args) {
        super(location);
        this._methodName = methodName;
        this._args = args;
    }

    public ClassVirtualMethodVarExpr(Expr nameExpr, ArrayList<Expr> args) {
        this(Location.UNKNOWN, nameExpr, args);
    }

    public ClassVirtualMethodVarExpr(Expr nameExpr, Expr[] args) {
        this(Location.UNKNOWN, nameExpr, args);
    }

    @Override
    public Expr createRef(QuercusParser parser) {
        return parser.getFactory().createRef(this);
    }

    @Override
    public Expr createCopy(ExprFactory factory) {
        return factory.createCopy(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value eval(Env env) {
        Value qThis = env.getThis();
        QuercusClass cls = qThis.getQuercusClass();
        if (cls == null) {
            env.error(L.l("no calling class found"), this.getLocation());
            return NullValue.NULL;
        }
        StringValue methodName = this._methodName.evalStringValue(env);
        int hash = methodName.hashCodeCaseInsensitive();
        Value[] values = ClassVirtualMethodVarExpr.evalArgs(env, this._args);
        env.pushCall(this, cls, values);
        try {
            env.checkTimeout();
            Value value = cls.callMethod(env, qThis, methodName, hash, values);
            return value;
        }
        finally {
            env.popCall();
        }
    }

    @Override
    public String toString() {
        return this._methodName + "()";
    }
}

