/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.AbstractUnaryExpr;
import com.caucho.quercus.expr.Expr;
import com.caucho.util.L10N;
import java.io.IOException;

public class FunEachExpr
extends AbstractUnaryExpr {
    private final L10N L = new L10N(FunEachExpr.class);
    private boolean _isVar;

    public FunEachExpr(Location location, Expr expr) throws IOException {
        super(location, expr);
        this._isVar = expr.isVar();
    }

    public FunEachExpr(Expr expr) {
        super(expr);
        this._isVar = expr.isVar();
    }

    public Value eval(Env env) {
        if (!this._isVar) {
            env.error(this.L.l("each() argument must be a variable at '{0}'", (Object)this.getExpr()));
            return NullValue.NULL;
        }
        Value var = this.getExpr().evalRef(env);
        Value value = var.toValue();
        if (value instanceof ArrayValue) {
            ArrayValue array = (ArrayValue)value;
            return array.each();
        }
        env.warning(this.L.l("each() argument must be an array at '{0}'", (Object)value.getClass().getSimpleName()));
        return BooleanValue.FALSE;
    }
}

