/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.AbstractUnaryExpr;
import com.caucho.quercus.expr.Expr;
import com.caucho.vfs.Path;

public class FunIncludeOnceExpr
extends AbstractUnaryExpr {
    protected Path _dir;
    protected boolean _isRequire;

    public FunIncludeOnceExpr(Location location, Path sourceFile, Expr expr) {
        super(location, expr);
        if (!sourceFile.getScheme().equals("string")) {
            this._dir = sourceFile.getParent();
        }
    }

    public FunIncludeOnceExpr(Location location, Path sourceFile, Expr expr, boolean isRequire) {
        this(location, sourceFile, expr);
        this._isRequire = isRequire;
    }

    public FunIncludeOnceExpr(Path sourceFile, Expr expr) {
        this(Location.UNKNOWN, sourceFile, expr);
    }

    public FunIncludeOnceExpr(Path sourceFile, Expr expr, boolean isRequire) {
        this(Location.UNKNOWN, sourceFile, expr, isRequire);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value eval(Env env) {
        StringValue name = this._expr.eval(env).toStringValue();
        env.pushCall(this, NullValue.NULL, new Value[]{name});
        try {
            if (this._dir != null) {
                Value value = env.includeOnce(this._dir, name, this._isRequire);
                return value;
            }
            if (this._isRequire) {
                Value value = env.requireOnce(name);
                return value;
            }
            Value value = env.includeOnce(name);
            return value;
        }
        finally {
            env.popCall();
        }
    }

    public boolean isRequire() {
        return this._isRequire;
    }

    public String toString() {
        return this._expr.toString();
    }
}

