/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.function;

import com.caucho.quercus.Location;
import com.caucho.quercus.UnimplementedException;
import com.caucho.quercus.env.Callback;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.program.Arg;
import com.caucho.quercus.program.ClassDef;
import com.caucho.quercus.program.Visibility;
import com.caucho.util.L10N;

public abstract class AbstractFunction
extends Callback {
    private static final L10N L = new L10N(AbstractFunction.class);
    public static final Arg[] NULL_ARGS = new Arg[0];
    private static final Value[] NULL_ARG_VALUES = new Value[0];
    private final Location _location;
    private boolean _isGlobal = true;
    protected boolean _isStatic = false;
    protected boolean _isFinal = false;
    protected boolean _isConstructor = false;
    protected boolean _isClosure = false;
    protected boolean _isTraitMethod = false;
    protected Visibility _visibility = Visibility.PUBLIC;
    protected String _declaringClassName;
    protected QuercusClass _bindingClass;
    protected int _parseIndex;

    public AbstractFunction() {
        this._location = Location.UNKNOWN;
    }

    public AbstractFunction(Location location) {
        this._location = location;
    }

    public String getName() {
        return "unknown";
    }

    public String getCallbackName() {
        return this.getName();
    }

    public boolean isInternal(Env env) {
        return false;
    }

    public boolean isValid(Env env) {
        return true;
    }

    public String getDeclFileName(Env env) {
        return this._location.getFileName();
    }

    public int getDeclStartLine(Env env) {
        return this._location.getLineNumber();
    }

    public int getDeclEndLine(Env env) {
        return this._location.getLineNumber();
    }

    public String getDeclComment(Env env) {
        return this.getComment();
    }

    public boolean isReturnsReference(Env env) {
        return true;
    }

    public Arg[] getArgs(Env env) {
        return NULL_ARGS;
    }

    public boolean isJavaMethod() {
        return false;
    }

    public final String getCompilationName() {
        String compName = this.getName() + "_" + this._parseIndex;
        compName = compName.replace("__", "___");
        compName = compName.replace("\\", "__");
        return compName;
    }

    public String getDeclaringClassName() {
        return this._declaringClassName;
    }

    public void setDeclaringClassName(String name) {
        this._declaringClassName = name;
    }

    public String getBindingClassName() {
        if (this._bindingClass != null) {
            return this._bindingClass.getName();
        }
        return "<none>";
    }

    public void setBindingClass(QuercusClass qcl) {
        this._bindingClass = qcl;
    }

    public QuercusClass getBindingClass() {
        return this._bindingClass;
    }

    public ClassDef getDeclaringClass() {
        return null;
    }

    public final boolean isGlobal() {
        return this._isGlobal;
    }

    public boolean isAbstract() {
        return false;
    }

    public void setStatic(boolean isStatic) {
        this._isStatic = isStatic;
    }

    public boolean isStatic() {
        return this._isStatic;
    }

    public boolean isFinal() {
        return this._isFinal;
    }

    public final void setFinal(boolean isFinal) {
        this._isFinal = isFinal;
    }

    public void setClosure(boolean isClosure) {
        this._isClosure = isClosure;
    }

    public boolean isClosure() {
        return this._isClosure;
    }

    public boolean isConstructor() {
        return this._isConstructor;
    }

    public final void setConstructor(boolean isConstructor) {
        this._isConstructor = isConstructor;
    }

    public boolean isTraitMethod() {
        return this._isTraitMethod;
    }

    public void setTraitMethod(boolean isTraitMethod) {
        this._isTraitMethod = isTraitMethod;
    }

    public boolean isPublic() {
        return this._visibility == Visibility.PUBLIC;
    }

    public boolean isProtected() {
        return this._visibility == Visibility.PROTECTED;
    }

    public boolean isPrivate() {
        return this._visibility == Visibility.PRIVATE;
    }

    public final void setVisibility(Visibility v) {
        this._visibility = v;
    }

    public final void setParseIndex(int index) {
        this._parseIndex = index;
    }

    public final Location getLocation() {
        return this._location;
    }

    public final void setGlobal(boolean isGlobal) {
        this._isGlobal = isGlobal;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isLong() {
        return false;
    }

    public boolean isDouble() {
        return false;
    }

    public boolean isCallUsesVariableArgs() {
        return false;
    }

    public boolean isCallUsesSymbolTable() {
        return false;
    }

    public Arg[] getClosureUseArgs() {
        throw new UnsupportedOperationException();
    }

    public void setClosureUseArgs(Arg[] useArgs) {
        throw new UnsupportedOperationException();
    }

    public AbstractFunction toFun() {
        return this;
    }

    public AbstractFunction getActualFunction(Expr[] args) {
        return this;
    }

    public String getComment() {
        return null;
    }

    public Value[] evalArguments(Env env, Expr fun, Expr[] args) {
        Value[] values = new Value[args.length];
        for (int i = 0; i < args.length; ++i) {
            values[i] = args[i].evalArg(env, true);
        }
        return values;
    }

    public boolean isObject() {
        return true;
    }

    public String getType() {
        return "object";
    }

    public boolean isCallable(Env env, boolean isCheckSyntaxOnly, Value nameRef) {
        throw new UnimplementedException();
    }

    public abstract Value call(Env var1, Value[] var2);

    public Value callRef(Env env, Value[] args) {
        return this.call(env, args);
    }

    public Value callCopy(Env env, Value[] args) {
        return this.call(env, args).copyReturn();
    }

    public Value callClosure(Env env, Value[] args, Value[] useArgs) {
        throw new UnsupportedOperationException();
    }

    public Value call(Env env) {
        return this.call(env, NULL_ARG_VALUES);
    }

    public Value call(Env env, Value a1) {
        return this.call(env, new Value[]{a1});
    }

    public Value call(Env env, Value a1, Value a2) {
        return this.call(env, new Value[]{a1, a2});
    }

    public Value call(Env env, Value a1, Value a2, Value a3) {
        return this.call(env, new Value[]{a1, a2, a3});
    }

    public Value call(Env env, Value a1, Value a2, Value a3, Value a4) {
        return this.call(env, new Value[]{a1, a2, a3, a4});
    }

    public Value call(Env env, Value a1, Value a2, Value a3, Value a4, Value a5) {
        return this.call(env, new Value[]{a1, a2, a3, a4, a5});
    }

    public Value callRef(Env env) {
        return this.callRef(env, NULL_ARG_VALUES);
    }

    public Value callRef(Env env, Value a1) {
        return this.callRef(env, new Value[]{a1});
    }

    public Value callRef(Env env, Value a1, Value a2) {
        return this.callRef(env, new Value[]{a1, a2});
    }

    public Value callRef(Env env, Value a1, Value a2, Value a3) {
        return this.callRef(env, new Value[]{a1, a2, a3});
    }

    public Value callRef(Env env, Value a1, Value a2, Value a3, Value a4) {
        return this.callRef(env, new Value[]{a1, a2, a3, a4});
    }

    public Value callRef(Env env, Value a1, Value a2, Value a3, Value a4, Value a5) {
        return this.callRef(env, new Value[]{a1, a2, a3, a4, a5});
    }

    public Value callMethod(Env env, QuercusClass qClass, Value qThis, Value[] args) {
        throw new IllegalStateException(this.getClass().getName());
    }

    public Value callNew(Env env, QuercusClass qClass, Value qThis, Value[] args) {
        return this.callMethod(env, qClass, qThis, args);
    }

    public Value callMethodRef(Env env, QuercusClass qClass, Value qThis, Value[] args) {
        throw new IllegalStateException(this.getClass().getName());
    }

    public Value callMethod(Env env, QuercusClass qClass, Value qThis) {
        return this.callMethod(env, qClass, qThis, NULL_ARG_VALUES);
    }

    public Value callMethodRef(Env env, QuercusClass qClass, Value qThis) {
        return this.callMethodRef(env, qClass, qThis, NULL_ARG_VALUES);
    }

    public Value callMethod(Env env, QuercusClass qClass, Value qThis, Value a1) {
        return this.callMethod(env, qClass, qThis, new Value[]{a1});
    }

    public Value callMethodRef(Env env, QuercusClass qClass, Value qThis, Value a1) {
        return this.callMethodRef(env, qClass, qThis, new Value[]{a1});
    }

    public Value callMethod(Env env, QuercusClass qClass, Value qThis, Value a1, Value a2) {
        return this.callMethod(env, qClass, qThis, new Value[]{a1, a2});
    }

    public Value callMethodRef(Env env, QuercusClass qClass, Value qThis, Value a1, Value a2) {
        return this.callMethodRef(env, qClass, qThis, new Value[]{a1, a2});
    }

    public Value callMethod(Env env, QuercusClass qClass, Value qThis, Value a1, Value a2, Value a3) {
        return this.callMethod(env, qClass, qThis, new Value[]{a1, a2, a3});
    }

    public Value callMethodRef(Env env, QuercusClass qClass, Value qThis, Value a1, Value a2, Value a3) {
        return this.callMethodRef(env, qClass, qThis, new Value[]{a1, a2, a3});
    }

    public Value callMethod(Env env, QuercusClass qClass, Value qThis, Value a1, Value a2, Value a3, Value a4) {
        return this.callMethod(env, qClass, qThis, new Value[]{a1, a2, a3, a4});
    }

    public Value callMethodRef(Env env, QuercusClass qClass, Value qThis, Value a1, Value a2, Value a3, Value a4) {
        return this.callMethodRef(env, qClass, qThis, new Value[]{a1, a2, a3, a4});
    }

    public Value callMethod(Env env, QuercusClass qClass, Value qThis, Value a1, Value a2, Value a3, Value a4, Value a5) {
        return this.callMethod(env, qClass, qThis, new Value[]{a1, a2, a3, a4, a5});
    }

    public Value callMethodRef(Env env, QuercusClass qClass, Value qThis, Value a1, Value a2, Value a3, Value a4, Value a5) {
        return this.callMethodRef(env, qClass, qThis, new Value[]{a1, a2, a3, a4, a5});
    }

    public Value callMethod(Env env, QuercusClass qClass, Value qThis, Expr[] exprs) {
        Value[] argValues = new Value[exprs.length];
        Arg[] args = this.getArgs(env);
        for (int i = 0; i < exprs.length; ++i) {
            argValues[i] = i < args.length && args[i].isReference() ? exprs[i].evalArg(env, true) : exprs[i].eval(env);
        }
        return this.callMethod(env, qClass, qThis, argValues);
    }

    public Value callMethodRef(Env env, QuercusClass qClass, Value qThis, Expr[] exprs) {
        Value[] argValues = new Value[exprs.length];
        Arg[] args = this.getArgs(env);
        for (int i = 0; i < exprs.length; ++i) {
            argValues[i] = i < args.length && args[i].isReference() ? exprs[i].evalArg(env, true) : exprs[i].eval(env);
        }
        return this.callMethodRef(env, qClass, qThis, argValues);
    }

    protected Value errorProtectedAccess(Env env, Value oldThis) {
        return env.error(L.l("Cannot call protected method {0}::{1}() from '{2}' context", (Object)this.getDeclaringClassName(), (Object)this.getName(), (Object)(oldThis != null ? oldThis.getClassName() : null)));
    }

    protected Value errorPrivateAccess(Env env, Value oldThis) {
        return env.error(L.l("Cannot call private method {0}::{1}() from '{2}' context", (Object)this.getDeclaringClassName(), (Object)this.getName(), (Object)(oldThis != null ? oldThis.getClassName() : null)));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }
}

