/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.ReadOnly;
import com.caucho.quercus.annotation.ReturnNullAsFalse;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Closure;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.JavaValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.function.AbstractFunction;
import com.caucho.quercus.lib.ArrayModule;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.quercus.program.ClassField;
import com.caucho.util.L10N;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class ClassesModule
extends AbstractQuercusModule {
    private static final L10N L = new L10N(ClassesModule.class);

    public static Value call_user_method(Env env, StringValue name, Value obj, Value[] args) {
        if (obj.isObject()) {
            return obj.callMethod(env, name, args);
        }
        QuercusClass cls = env.getClass(obj.toString());
        Value result = cls.callMethod(env, env.getThis(), name, name.hashCode(), args);
        return result.copyReturn();
    }

    public static Value call_user_method_array(Env env, StringValue methodName, Value obj, ArrayValue params) {
        Value[] args = params.valuesToArray();
        return ClassesModule.call_user_method(env, methodName, obj, args);
    }

    public boolean class_alias(Env env, String original, String alias, @Optional(value="true") boolean isAutoLoad) {
        QuercusClass aliasCls = env.findClass(alias, -1, false, true, true);
        if (aliasCls != null) {
            env.warning(L.l("cannot redeclare class {0}", (Object)alias));
            return false;
        }
        QuercusClass cls = env.findClass(original, -1, isAutoLoad, true, true);
        if (cls == null) {
            env.warning(L.l("original class not found {0}", (Object)original));
            return false;
        }
        env.addClassAlias(alias, cls);
        return true;
    }

    public static boolean class_exists(Env env, String className, @Optional(value="true") boolean useAutoload) {
        if (className == null) {
            return false;
        }
        QuercusClass cl = env.findClass(className, -1, useAutoload, true, true);
        return cl != null && !cl.isInterface();
    }

    public static Value get_class(Env env, Value value) {
        if (value instanceof ObjectValue) {
            ObjectValue obj = (ObjectValue)value;
            return env.createString(obj.getName());
        }
        if (value instanceof JavaValue) {
            JavaValue obj = (JavaValue)value;
            return env.createString(obj.getClassName());
        }
        env.warning(L.l("expected an object, but saw {0}", (Object)value.getType()));
        return BooleanValue.FALSE;
    }

    @ReturnNullAsFalse
    public static String get_called_class(Env env) {
        Value qThis = env.getThis();
        if (qThis == null || qThis.getQuercusClass() == null) {
            env.warning("get_called_class was not called from a class method");
            return null;
        }
        return qThis.getQuercusClass().getName();
    }

    public static Value get_class_methods(Env env, Value cls) {
        QuercusClass cl = cls.isObject() ? ((ObjectValue)cls).getQuercusClass() : env.findClass(cls.toString());
        if (cl == null) {
            return NullValue.NULL;
        }
        ArrayValueImpl array = new ArrayValueImpl();
        HashSet<String> set = new HashSet<String>();
        for (AbstractFunction fun : cl.getClassMethods()) {
            if (!fun.isPublic()) continue;
            set.add(fun.getName());
        }
        for (String name : set) {
            array.put(name);
        }
        return array;
    }

    public static Value get_class_vars(Env env, Value obj) {
        QuercusClass cl = obj instanceof ObjectValue ? ((ObjectValue)obj).getQuercusClass() : env.findClass(obj.toString());
        if (cl == null) {
            return BooleanValue.FALSE;
        }
        ArrayValueImpl varArray = new ArrayValueImpl();
        for (ClassField field : cl.getClassFields().values()) {
            if (!field.isPublic()) continue;
            StringValue name = field.getName();
            Expr initValue = field.getInitExpr();
            Value value = initValue.eval(env);
            ((ArrayValue)varArray).append(name, value);
        }
        ArrayModule.ksort(env, varArray, 2L);
        return varArray;
    }

    public static Value get_declared_classes(Env env) {
        return env.getDeclaredClasses();
    }

    public static Value get_object_vars(Env env, Value obj) {
        ArrayValueImpl result = new ArrayValueImpl();
        if (obj instanceof ObjectValue) {
            for (Map.Entry<Value, Value> entry : ((ObjectValue)obj).entrySet()) {
                result.put(entry.getKey(), entry.getValue());
            }
        } else {
            Iterator<Map.Entry<Value, Value>> iter = obj.getIterator(env);
            while (iter.hasNext()) {
                Map.Entry<Value, Value> entry = iter.next();
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    public Value get_parent_class(Env env, @ReadOnly Value value) {
        String parent;
        String className;
        QuercusClass cl;
        if (value instanceof ObjectValue) {
            ObjectValue obj = (ObjectValue)value;
            String parent2 = obj.getParentClassName();
            if (parent2 != null) {
                return env.createString(parent2);
            }
        } else if (value.isString() && (cl = env.findClass(className = value.toString())) != null && (parent = cl.getParentName()) != null) {
            return env.createString(parent);
        }
        return BooleanValue.FALSE;
    }

    public boolean interface_exists(Env env, String interfaceName, @Optional(value="true") boolean useAutoload) {
        QuercusClass cl = env.findClass(interfaceName, -1, useAutoload, true, true);
        return cl != null && cl.isInterface();
    }

    public static boolean is_a(Env env, @ReadOnly Value value, String name) {
        return value.isA(env, name);
    }

    public static boolean is_object(@ReadOnly Value value) {
        return value.isObject();
    }

    public static boolean is_subclass_of(Env env, @ReadOnly Value value, String name) {
        if (value.isString()) {
            QuercusClass cl = env.findClass(value.toString());
            return cl.isA(env, name) && !cl.getName().equalsIgnoreCase(name);
        }
        return value.isA(env, name) && !value.getClassName().equalsIgnoreCase(name);
    }

    public static boolean method_exists(Env env, Value obj, StringValue methodName) {
        if (obj instanceof Closure && methodName.equalsString("__invoke")) {
            return true;
        }
        QuercusClass qClass = obj.getQuercusClass();
        if (qClass == null) {
            qClass = env.findClass(obj.toString());
        }
        if (qClass != null) {
            return qClass.findFunction(methodName) != null;
        }
        return false;
    }

    public static Value property_exists(Env env, Value obj, StringValue name) {
        if (obj.isString()) {
            QuercusClass cls = env.findClass(obj.toString());
            if (cls != null && cls.getClassField(name) != null) {
                return BooleanValue.TRUE;
            }
            return BooleanValue.FALSE;
        }
        if (obj.isObject()) {
            boolean result = obj.isFieldExists(env, name);
            return BooleanValue.create(result);
        }
        env.warning("must pass in object or name of class");
        return NullValue.NULL;
    }
}

