/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.QuercusException;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;

public class ExifModule
extends AbstractQuercusModule {
    private static final L10N L = new L10N(ExifModule.class);

    public static Value exif_read_data(Env env, Path file, @Optional String sections, @Optional boolean arrays, @Optional boolean thumbs) {
        return BooleanValue.FALSE;
    }

    public static Value read_exif_data(Env env, Path file, @Optional String sections, @Optional boolean arrays, @Optional boolean thumbs) {
        return ExifModule.exif_read_data(env, file, sections, arrays, thumbs);
    }

    public static Value exif_thumbnail(Env env, Path file, @Optional int width, @Optional int height, @Optional int imageType) {
        return BooleanValue.FALSE;
    }

    public static String exif_tagname(String index) {
        return null;
    }

    public static Value exif_imagetype(Env env, Path file) {
        try {
            Iterator<ImageReader> it = ImageIO.getImageReaders(file.openRead());
            if (!it.hasNext()) {
                return BooleanValue.FALSE;
            }
            ImageReader imageReader = it.next();
            if (it.hasNext()) {
                throw new QuercusException("ImageIO returned two ImageReaders:\n  " + imageReader + "\n  " + it.next());
            }
            String formatName = imageReader.getFormatName();
            if (formatName.equals("jpeg") || formatName.equals("jpg")) {
                return LongValue.create(2L);
            }
            if (formatName.equals("gif")) {
                return LongValue.create(1L);
            }
            if (formatName.equals("png")) {
                return LongValue.create(3L);
            }
            if (formatName.equals("swf")) {
                return LongValue.create(4L);
            }
            if (formatName.equals("psd")) {
                return LongValue.create(5L);
            }
            if (formatName.equals("bmp")) {
                return LongValue.create(6L);
            }
            if (formatName.equals("tiff")) {
                return LongValue.create(7L);
            }
            if (formatName.equals("jpc")) {
                return LongValue.create(9L);
            }
            if (formatName.equals("jp2")) {
                return LongValue.create(10L);
            }
            if (formatName.equals("jpf")) {
                return LongValue.create(11L);
            }
            if (formatName.equals("jb2")) {
                return LongValue.create(12L);
            }
            if (formatName.equals("swc")) {
                return LongValue.create(13L);
            }
            if (formatName.equals("iff")) {
                return LongValue.create(14L);
            }
            if (formatName.equals("wbmp")) {
                return LongValue.create(15L);
            }
            if (formatName.equals("xbm")) {
                return LongValue.create(16L);
            }
            env.warning(L.l("ImageIO returned unknown image type: " + formatName));
            return BooleanValue.FALSE;
        }
        catch (IOException e) {
            throw new QuercusException(e);
        }
    }
}

