/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.L10N;
import com.caucho.util.RandomUtil;
import java.math.BigInteger;
import java.util.Iterator;

public class MathModule
extends AbstractQuercusModule {
    private static final L10N L = new L10N(MathModule.class);
    public static final double M_PI = Math.PI;
    public static final double M_E = Math.E;
    public static final long RAND_MAX = Integer.MAX_VALUE;
    public static final double M_LOG2E = MathModule.log2(Math.E);
    public static final double M_LOG10E = Math.log10(Math.E);
    public static final double M_LN2 = Math.log(2.0);
    public static final double M_LN10 = Math.log(10.0);
    public static final double M_PI_2 = 1.5707963267948966;
    public static final double M_PI_4 = 0.7853981633974483;
    public static final double M_1_PI = 0.3183098861837907;
    public static final double M_2_PI = 0.6366197723675814;
    public static final double M_SQRTPI = Math.sqrt(Math.PI);
    public static final double M_2_SQRTPI = 2.0 / Math.sqrt(Math.PI);
    public static final double M_SQRT2 = Math.sqrt(2.0);
    public static final double M_SQRT3 = Math.sqrt(3.0);
    public static final double M_SQRT1_2 = 1.0 / Math.sqrt(2.0);
    public static final double M_LNPI = Math.log(Math.PI);
    public static final double M_EULER = 0.5772156649015329;

    private static double log2(double v) {
        return Math.log(v) / Math.log(2.0);
    }

    public static Value abs(Value value) {
        return value.abs();
    }

    public static double acos(double value) {
        return Math.acos(value);
    }

    public static double acosh(Env env, double value) {
        return Math.log(value + Math.sqrt(value * value - 1.0));
    }

    public static Value asin(Value value) {
        return new DoubleValue(Math.asin(value.toDouble()));
    }

    public static double asinh(double value) {
        return Math.log(value + Math.sqrt(value * value + 1.0));
    }

    public static double atan2(double yV, double xV) {
        return Math.atan2(yV, xV);
    }

    public static double atan(double value) {
        return Math.atan(value);
    }

    public static double atanh(double value) {
        return 0.5 * Math.log((1.0 + value) / (1.0 - value));
    }

    public static Value base_convert(Env env, StringValue str, int fromBase, int toBase) {
        if (fromBase < 2 || fromBase > 36) {
            env.warning(L.l("invalid `{0}' ({1})", (Object)"from base", fromBase));
            return BooleanValue.FALSE;
        }
        if (toBase < 2 || toBase > 36) {
            env.warning(L.l("invalid `{0}' ({1})", (Object)"to base", toBase));
            return BooleanValue.FALSE;
        }
        Number num = MathModule.baseToInt(env, str, fromBase);
        if (num instanceof BigInteger) {
            return MathModule.intToBase(env, (BigInteger)num, toBase);
        }
        return MathModule.intToBase(env, num.longValue(), toBase);
    }

    /*
     * WARNING - void declaration
     */
    private static Number baseToInt(Env env, StringValue str, int base) {
        long result = 0L;
        boolean isLong = true;
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            void var9_8;
            int d;
            char ch = str.charAt(i);
            if ('0' <= ch && ch <= '9') {
                d = ch - 48;
            } else if ('a' <= ch && ch <= 'z') {
                d = ch - 97 + 10;
            } else {
                if ('A' > ch || ch > 'Z') continue;
                d = ch - 65 + 10;
            }
            if (base <= var9_8) continue;
            if (result * (long)base + (long)var9_8 < result) {
                isLong = false;
                break;
            }
            result = result * (long)base + (long)var9_8;
        }
        if (isLong) {
            return result;
        }
        return new BigInteger(str.toString(), base);
    }

    private static StringValue intToBase(Env env, long num, int base) {
        if (num == 0L) {
            return env.createString('0');
        }
        if (num < 0L) {
            num ^= Long.MIN_VALUE;
        }
        int bufLen = 64;
        byte[] buffer = new byte[bufLen];
        int i = bufLen;
        while (num != 0L && i > 0) {
            int d = (int)(num % (long)base);
            buffer[--i] = d < 10 ? (byte)(d + 48) : (byte)(d + 97 - 10);
            num /= (long)base;
        }
        for (int j = i; j < bufLen; ++j) {
            buffer[j - i] = buffer[j];
        }
        return env.createString(buffer, 0, bufLen - i);
    }

    private static StringValue intToBase(Env env, BigInteger num, int base) {
        BigInteger toBaseBig = BigInteger.valueOf(base);
        BigInteger zero = BigInteger.valueOf(0L);
        StringValue sb = env.createStringBuilder();
        do {
            BigInteger[] resultArray = num.divideAndRemainder(toBaseBig);
            num = resultArray[0];
            int d = resultArray[1].intValue();
            if (d < 10) {
                sb.append((char)(d + 48));
                continue;
            }
            sb.append((char)(d + 97 - 10));
        } while (num.compareTo(zero) != 0);
        StringValue toReturn = env.createStringBuilder();
        int len = sb.length();
        for (int i = len - 1; i >= 0; --i) {
            toReturn.append(sb.charAt(i));
        }
        return toReturn;
    }

    public static Value bindec(Env env, StringValue bin) {
        Number num = MathModule.baseToInt(env, bin, 2);
        if (num instanceof Long) {
            return LongValue.create(num.longValue());
        }
        return env.wrapJava(num);
    }

    public static double ceil(double value) {
        return Math.ceil(value);
    }

    public static double cos(double value) {
        return Math.cos(value);
    }

    public static double cosh(double value) {
        return Math.cosh(value);
    }

    public static StringValue decbin(Env env, long value) {
        return MathModule.intToBase(env, value, 2);
    }

    public static StringValue dechex(Env env, long value) {
        return MathModule.intToBase(env, value, 16);
    }

    public static StringValue decoct(Env env, long value) {
        return MathModule.intToBase(env, value, 8);
    }

    public static double deg2rad(double value) {
        return value * Math.PI / 180.0;
    }

    public static Value exp(Value value) {
        return new DoubleValue(Math.exp(value.toDouble()));
    }

    public static Value expm1(Value value) {
        return new DoubleValue(Math.expm1(value.toDouble()));
    }

    public static Value floor(Value value) {
        return new DoubleValue(Math.floor(value.toDouble()));
    }

    public static double fmod(double xV, double yV) {
        return Math.IEEEremainder(xV, yV);
    }

    public static Value hexdec(Env env, StringValue s) {
        Number num = MathModule.baseToInt(env, s, 16);
        if (num instanceof Long) {
            return LongValue.create(num.longValue());
        }
        return env.wrapJava(num);
    }

    public static double hypot(double a, double b) {
        return Math.hypot(a, b);
    }

    public static boolean is_finite(Value value) {
        if (value instanceof LongValue) {
            return true;
        }
        if (value instanceof DoubleValue) {
            double v = value.toDouble();
            return !Double.isInfinite(v);
        }
        return false;
    }

    public static Value is_infinite(Value value) {
        if (value instanceof LongValue) {
            return BooleanValue.FALSE;
        }
        if (value instanceof DoubleValue) {
            double v = value.toDouble();
            return Double.isInfinite(v) ? BooleanValue.TRUE : BooleanValue.FALSE;
        }
        return BooleanValue.FALSE;
    }

    public static Value is_nan(Value value) {
        if (value instanceof LongValue) {
            return BooleanValue.FALSE;
        }
        if (value instanceof DoubleValue) {
            double v = value.toDouble();
            return Double.isNaN(v) ? BooleanValue.TRUE : BooleanValue.FALSE;
        }
        return BooleanValue.FALSE;
    }

    public static double log(double value) {
        return Math.log(value);
    }

    public static double log10(double value) {
        return Math.log10(value);
    }

    public static double log1p(double value) {
        return Math.log1p(value);
    }

    public static Value getrandmax() {
        return MathModule.mt_getrandmax();
    }

    public static Value max(Env env, Value[] args) {
        if (args.length == 1 && args[0].isArray()) {
            ArrayValue array = args[0].toArrayValue(env);
            Iterator<Value> iter = array.getValueIterator(env);
            Value max = NullValue.NULL;
            while (iter.hasNext()) {
                Value value = iter.next();
                if (((Value)max).isNull()) {
                    max = value;
                    continue;
                }
                if (((Value)max).cmp(value) >= 0) continue;
                max = value;
            }
            return max;
        }
        Value max = NullValue.NULL;
        for (int i = 0; i < args.length; ++i) {
            Value value = args[i];
            if (((Value)max).isNull()) {
                max = value;
                continue;
            }
            if (((Value)max).cmp(value) >= 0) continue;
            max = value;
        }
        return max;
    }

    public static Value min(Env env, Value[] args) {
        if (args.length == 1 && args[0].isArray()) {
            ArrayValue array = args[0].toArrayValue(env);
            Iterator<Value> iter = array.getValueIterator(env);
            Value min = NullValue.NULL;
            while (iter.hasNext()) {
                Value value = iter.next();
                if (((Value)min).isNull()) {
                    min = value;
                    continue;
                }
                if (((Value)min).cmp(value) <= 0) continue;
                min = value;
            }
            return min;
        }
        Value min = NullValue.NULL;
        for (int i = 0; i < args.length; ++i) {
            Value value = args[i];
            if (((Value)min).isNull()) {
                min = value;
                continue;
            }
            if (((Value)min).cmp(value) <= 0) continue;
            min = value;
        }
        return min;
    }

    public static Value mt_getrandmax() {
        return new LongValue(Integer.MAX_VALUE);
    }

    public static long mt_rand(@Optional(value="0") long min, @Optional(value="RAND_MAX") long max) {
        long range = max - min + 1L;
        if (range <= 0L) {
            return min;
        }
        long value = RandomUtil.getRandomLong();
        if (value < 0L) {
            value = -value;
        }
        return min + value % range;
    }

    public static Value mt_srand(@Optional long seed) {
        return NullValue.NULL;
    }

    public static double lcg_value() {
        return RandomUtil.nextDouble();
    }

    public static Value octdec(Env env, StringValue oct) {
        Number num = MathModule.baseToInt(env, oct, 8);
        if (num instanceof Long) {
            return LongValue.create(num.longValue());
        }
        return env.wrapJava(num);
    }

    public static double pi() {
        return Math.PI;
    }

    public static double pow(double base, double exp) {
        return Math.pow(base, exp);
    }

    public static double rad2deg(double value) {
        return 180.0 * value / Math.PI;
    }

    public static long rand(@Optional int min, @Optional(value="RAND_MAX") int max) {
        return MathModule.mt_rand(min, max);
    }

    public static double round(double value, @Optional int precision) {
        if (precision > 0) {
            double exp = Math.pow(10.0, precision);
            return (double)Math.round(value * exp) / exp;
        }
        return Math.round(value);
    }

    public static double sin(double value) {
        return Math.sin(value);
    }

    public static Value sinh(Value value) {
        return new DoubleValue(Math.sinh(value.toDouble()));
    }

    public static double sqrt(double value) {
        return Math.sqrt(value);
    }

    public static Value srand(@Optional long seed) {
        return NullValue.NULL;
    }

    public static double tan(double value) {
        return Math.tan(value);
    }

    public static double tanh(double value) {
        return Math.tanh(value);
    }
}

