/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.curl;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.annotation.ResourceType;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Callable;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.ResourceValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.curl.CurlHttpRequest;
import com.caucho.quercus.lib.file.BinaryInput;
import com.caucho.quercus.lib.file.BinaryOutput;
import com.caucho.quercus.lib.file.FileModule;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceType(value="curl")
public class CurlResource
extends ResourceValue {
    private static final Logger log = Logger.getLogger(CurlResource.class.getName());
    private static final L10N L = new L10N(CurlResource.class);
    private String _requestMethod = "GET";
    private int _responseCode;
    private String _URL;
    private int _port = -1;
    private String _username;
    private String _password;
    private boolean _isProxying = false;
    private String _proxyUsername;
    private String _proxyPassword;
    private String _proxyURL;
    private String _proxyType = "HTTP";
    private int _proxyPort = -1;
    private boolean _isFollowingRedirects = true;
    private boolean _isReturningBody = true;
    private boolean _isReturningData = false;
    private boolean _isReturningHeader = false;
    private boolean _isVerifySSLPeer = true;
    private boolean _isVerifySSLCommonName = true;
    private boolean _isVerifySSLHostname = true;
    private boolean _ifModifiedSince = true;
    private String _modifiedTime;
    private int _errorCode = 0;
    private String _error = "";
    private boolean _failOnError = false;
    private boolean _isVerbose = false;
    private int _readTimeoutMs = -1;
    private int _connectTimeoutMs = -1;
    private HashMap<String, String> _requestProperties = new HashMap();
    private StringValue _header;
    private StringValue _body;
    private Value _postBody;
    private StringValue _returnTransfer;
    private String _contentType;
    private int _contentLength;
    private String _cookie;
    private String _cookieFilename;
    private BinaryOutput _outputFile;
    private BinaryOutput _outputHeaderFile;
    private BinaryInput _uploadFile;
    private long _uploadFileSize = -1L;
    private Callable _headerCallback;
    private Callable _passwordCallback;
    private Callable _readCallback;
    private Callable _writeCallback;

    public Value getBody() {
        return this._body;
    }

    public void setBody(StringValue body) {
        this._body = body;
    }

    public int getConnectTimeout() {
        return this._connectTimeoutMs;
    }

    public void setConnectTimeout(int timeoutMs) {
        this._connectTimeoutMs = timeoutMs;
    }

    public int getContentLength() {
        return this._contentLength;
    }

    public void setContentLength(int length) {
        this._contentLength = length;
    }

    public String getContentType() {
        return this._contentType;
    }

    public void setContentType(String type) {
        this._contentType = type;
    }

    public void setCookie(String cookie) {
        this._cookie = cookie;
    }

    public void setCookieFilename(String filename) {
        this._cookieFilename = filename;
    }

    public String getError() {
        return this._error;
    }

    public void setError(String error) {
        this._error = error;
    }

    public int getErrorCode() {
        return this._errorCode;
    }

    public void setErrorCode(int code) {
        this._errorCode = code;
    }

    public void setFailOnError(boolean failOnError) {
        this._failOnError = failOnError;
    }

    public Value getHeader() {
        return this._header;
    }

    public void setHeader(StringValue header) {
        this._header = header;
    }

    public Callable getHeaderCallback() {
        return this._headerCallback;
    }

    public void setHeaderCallback(Callable callback) {
        this._headerCallback = callback;
    }

    public void setIfModifiedSince(boolean option) {
        this._ifModifiedSince = option;
    }

    public boolean getIsFollowingRedirects() {
        return this._isFollowingRedirects;
    }

    public void setIsFollowingRedirects(boolean followRedirects) {
        this._isFollowingRedirects = followRedirects;
    }

    public boolean getIsProxying() {
        return this._isProxying;
    }

    public void setIsProxying(boolean proxy) {
        this._isProxying = proxy;
    }

    public void setIsReturningBody(boolean returnBody) {
        this._isReturningBody = returnBody;
    }

    public boolean isReturningData() {
        return this._isReturningData;
    }

    public void setIsReturningData(boolean returnData) {
        this._isReturningData = returnData;
    }

    public void setIsReturningHeader(boolean returnHeader) {
        this._isReturningHeader = returnHeader;
    }

    public boolean getIsVerbose() {
        return this._isVerbose;
    }

    public void setIsVerbose(boolean verbose) {
        this._isVerbose = verbose;
    }

    public boolean getIsVerifySSLPeer() {
        return this._isVerifySSLPeer;
    }

    public void setIsVerifySSLPeer(boolean isVerify) {
        this._isVerifySSLPeer = isVerify;
    }

    public boolean getIsVerifySSLCommonName() {
        return this._isVerifySSLCommonName;
    }

    public void setIsVerifySSLCommonName(boolean isVerify) {
        this._isVerifySSLCommonName = isVerify;
    }

    public boolean getIsVerifySSLHostname() {
        return this._isVerifySSLHostname;
    }

    public void setIsVerifySSLHostname(boolean isVerify) {
        this._isVerifySSLHostname = isVerify;
    }

    public void setModifiedTime(String time) {
        this._modifiedTime = time;
    }

    public void setOutputFile(BinaryOutput file) {
        this._outputFile = file;
    }

    public void setOutputHeaderFile(BinaryOutput file) {
        this._outputHeaderFile = file;
    }

    public String getPassword() {
        return this._password;
    }

    public void setPassword(String pwd) {
        this._password = pwd;
    }

    public void setPasswordCallback(Callable callback) {
        this._passwordCallback = callback;
    }

    public int getPort() {
        return this._port;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public Value getPostBody() {
        return this._postBody;
    }

    public void setPostBody(Value body) {
        this._postBody = body;
    }

    public String getProxyPassword() {
        return this._proxyPassword;
    }

    public void setProxyPassword(String pass) {
        this._proxyPassword = pass;
    }

    public int getProxyPort() {
        return this._proxyPort;
    }

    public void setProxyPort(int port) {
        this._proxyPort = port;
    }

    public String getProxyType() {
        return this._proxyType;
    }

    public void setProxyType(String type) {
        this._proxyType = type;
    }

    public String getProxyURL() {
        return this._proxyURL;
    }

    public void setProxyURL(String proxy) {
        this._proxyURL = proxy;
    }

    public String getProxyUsername() {
        return this._proxyUsername;
    }

    public void setProxyUsername(String user) {
        this._proxyUsername = user;
    }

    public Callable getReadCallback() {
        return this._readCallback;
    }

    public void setReadCallback(Callable callback) {
        this._readCallback = callback;
    }

    public int getReadTimeout() {
        return this._readTimeoutMs;
    }

    public void setReadTimeout(int timeoutMs) {
        this._readTimeoutMs = timeoutMs;
    }

    public String getRequestMethod() {
        return this._requestMethod;
    }

    public void setRequestMethod(String method) {
        this._requestMethod = method;
    }

    public HashMap<String, String> getRequestPropertiesMap() {
        return this._requestProperties;
    }

    public Value getRequestProperties(Env env) {
        StringValue bb = env.createBinaryBuilder();
        for (Map.Entry<String, String> entry : this._requestProperties.entrySet()) {
            bb.append(entry.getKey());
            bb.append(": ");
            bb.append(entry.getValue());
            bb.append("\r\n");
        }
        bb.append("\r\n");
        return bb;
    }

    public void setRequestProperty(String key, String value) {
        if (value.length() > 0) {
            this._requestProperties.put(key, value);
        }
    }

    public int getResponseCode() {
        return this._responseCode;
    }

    public void setResponseCode(int code) {
        this._responseCode = code;
    }

    public BinaryInput getUploadFile() {
        return this._uploadFile;
    }

    public void setUploadFile(BinaryInput file) {
        this._uploadFile = file;
    }

    public long getUploadFileSize() {
        return this._uploadFileSize;
    }

    public void setUploadFileSize(long size) {
        this._uploadFileSize = size;
    }

    public String getURL() {
        return this._URL;
    }

    public void setURL(String url) {
        this._URL = url;
    }

    public String getUsername() {
        return this._username;
    }

    public void setUsername(String user) {
        this._username = user;
    }

    public Callable getWriteCallback() {
        return this._writeCallback;
    }

    public void setWriteCallback(Callable callback) {
        this._writeCallback = callback;
    }

    public void removeRequestProperty(String key) {
        this._requestProperties.remove(key);
    }

    private void init() {
        this._error = null;
        this._errorCode = 0;
        if (this._modifiedTime != null) {
            if (this._ifModifiedSince) {
                this.removeRequestProperty("If-Unmodified-Since");
                this.setRequestProperty("If-Modified-Since", this._modifiedTime);
            } else {
                this.removeRequestProperty("If-Modified-Since");
                this.setRequestProperty("If-Unmodified-Since", this._modifiedTime);
            }
        }
        if (this._cookie != null) {
            this.setRequestProperty("Cookie", this._cookie);
        } else {
            this.removeRequestProperty("Cookie");
        }
    }

    public Value execute(Env env, boolean isPrintData) {
        this.init();
        CurlHttpRequest httpRequest = CurlHttpRequest.getRequest(this);
        env.addCleanup(httpRequest);
        if (!httpRequest.execute(env)) {
            return BooleanValue.FALSE;
        }
        if (this._cookie != null && this._cookieFilename != null) {
            this.saveCookie(env);
        }
        return this.getReturnValue(env, isPrintData);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Value getReturnValue(Env env, boolean isPrintData) {
        StringValue data;
        if (this._responseCode == 304 || this._responseCode == 412 || this._failOnError && this._responseCode >= 400) {
            if (!this._isReturningHeader) return BooleanValue.TRUE;
            data = this._header;
        } else {
            StringValue bb = env.createBinaryBuilder();
            if (this._isReturningHeader) {
                bb.append(this._header);
            }
            if (this._isReturningBody) {
                bb.append(this._body);
            }
            data = bb;
        }
        if (this._outputHeaderFile != null) {
            FileModule.fwrite(env, this._outputHeaderFile, this._header.toInputStream(), Integer.MAX_VALUE);
        }
        if (this._outputFile != null) {
            FileModule.fwrite(env, this._outputFile, data.toInputStream(), Integer.MAX_VALUE);
        }
        if (this._isReturningData) {
            this._returnTransfer = data;
            return data;
        }
        if (!isPrintData) return BooleanValue.TRUE;
        env.print(data);
        return BooleanValue.TRUE;
    }

    public StringValue getReturnTransfer() {
        return this._returnTransfer;
    }

    private void saveCookie(Env env) {
        WriteStream out = null;
        try {
            Path path = env.getPwd().lookup(this._cookieFilename);
            out = path.openWrite();
            int len = this._cookie.length();
            for (int i = 0; i < len; ++i) {
                out.write((byte)this._cookie.charAt(i));
            }
        }
        catch (IOException e) {
            throw new QuercusModuleException(e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void close() {
    }

    protected boolean hasError() {
        return this._errorCode != 0;
    }

    public CurlResource clone() {
        CurlResource curl = new CurlResource();
        curl.setBody(this._body);
        curl.setConnectTimeout(this._connectTimeoutMs);
        curl.setContentLength(this._contentLength);
        curl.setContentType(this._contentType);
        curl.setCookie(this._cookie);
        curl.setCookieFilename(this._cookieFilename);
        curl.setError(this._error);
        curl.setErrorCode(this._errorCode);
        curl.setFailOnError(this._failOnError);
        curl.setHeaderCallback(this._headerCallback);
        curl.setHeader(this._header);
        curl.setIsFollowingRedirects(this._isFollowingRedirects);
        curl.setIfModifiedSince(this._ifModifiedSince);
        curl.setIsProxying(this._isProxying);
        curl.setIsReturningBody(this._isReturningBody);
        curl.setIsReturningData(this._isReturningData);
        curl.setIsReturningHeader(this._isReturningHeader);
        curl.setIsVerbose(this._isVerbose);
        curl.setModifiedTime(this._modifiedTime);
        curl.setOutputFile(this._outputFile);
        curl.setOutputHeaderFile(this._outputHeaderFile);
        curl.setPassword(this._password);
        curl.setPasswordCallback(this._passwordCallback);
        curl.setPort(this._port);
        curl.setPostBody(this._postBody);
        curl.setProxyPassword(this._proxyPassword);
        curl.setProxyPort(this._proxyPort);
        curl.setProxyType(this._proxyType);
        curl.setProxyURL(this._proxyURL);
        curl.setProxyUsername(this._proxyUsername);
        curl.setReadCallback(this._readCallback);
        curl.setReadTimeout(this._readTimeoutMs);
        curl.setRequestMethod(this._requestMethod);
        for (Map.Entry<String, String> entry : this._requestProperties.entrySet()) {
            curl.setRequestProperty(entry.getKey(), entry.getValue());
        }
        curl.setResponseCode(this._responseCode);
        curl.setUploadFile(this._uploadFile);
        curl.setUploadFileSize(this._uploadFileSize);
        curl.setURL(this._URL);
        curl.setUsername(this._username);
        curl.setWriteCallback(this._writeCallback);
        return curl;
    }

    @Override
    public String toString() {
        return "CurlResource[" + this._requestMethod + " " + this._URL + "]";
    }

    @Override
    public boolean isResource() {
        return true;
    }
}

