/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.curl;

import com.caucho.quercus.env.Callable;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.curl.CurlHttpConnection;
import com.caucho.quercus.lib.curl.CurlHttpRequest;
import com.caucho.quercus.lib.curl.CurlResource;
import com.caucho.quercus.lib.file.BinaryInput;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ProtocolException;

public class HttpPutRequest
extends CurlHttpRequest {
    public HttpPutRequest(CurlResource curlResource) {
        super(curlResource);
    }

    protected boolean init(Env env) throws ProtocolException {
        if (!super.init(env)) {
            return false;
        }
        this.getHttpConnection().setDoOutput(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transfer(Env env) throws IOException {
        block8: {
            super.transfer(env);
            CurlHttpConnection conn = this.getHttpConnection();
            OutputStream out = conn.getOutputStream();
            CurlResource curl = this.getCurlResource();
            try {
                long totalWritten;
                BinaryInput in = curl.getUploadFile();
                long length = curl.getUploadFileSize();
                if (curl.getReadCallback() != null) {
                    int count;
                    Callable callback = curl.getReadCallback();
                    Value fileV = env.wrapJava(in);
                    LongValue lengthV = LongValue.create(length);
                    for (totalWritten = 0L; totalWritten < length; totalWritten += (long)count) {
                        StringValue str = callback.call(env, fileV, lengthV).toStringValue(env);
                        count = str.length();
                        if (count == 0) {
                            break block8;
                        }
                        str.writeTo(out);
                    }
                    break block8;
                }
                byte[] buffer = new byte[4096];
                while (totalWritten < length) {
                    int count = in.read(buffer, 0, buffer.length);
                    if (count < 0) {
                        break;
                    }
                    out.write(buffer, 0, count);
                    totalWritten += (long)count;
                }
            }
            finally {
                out.close();
            }
        }
    }
}

