/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

import com.caucho.quercus.annotation.ReturnNullAsFalse;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.Value;
import com.caucho.util.L10N;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleOciCollection {
    private static final Logger log = Logger.getLogger(OracleOciCollection.class.getName());
    private static final L10N L = new L10N(OracleOciCollection.class);
    private Object _arrayDescriptor;
    private Array _collection;
    private ArrayList<Object> _javaCollection;
    private Connection _jdbcConn;
    private static Class<?> classOracleARRAY;

    OracleOciCollection(Connection jdbcConn, Object arrayDescriptor) {
        this._jdbcConn = jdbcConn;
        this._arrayDescriptor = arrayDescriptor;
        this._collection = null;
        this._javaCollection = new ArrayList();
    }

    public boolean append(Env env, Value value) {
        try {
            this._javaCollection.add(value.toJavaObject());
            return true;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return false;
        }
    }

    public boolean assign(Env env, OracleOciCollection fromCollection) {
        try {
            this._javaCollection.addAll(fromCollection.getJavaCollection());
            return true;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return false;
        }
    }

    public boolean assignElem(Env env, int index, Value value) {
        try {
            if (index < 1 || index > this._javaCollection.size()) {
                return false;
            }
            this._javaCollection.set(index - 1, value.toJavaObject());
            return true;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return false;
        }
    }

    public boolean free(Env env) {
        try {
            this._collection = null;
            this._javaCollection = null;
            return true;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return false;
        }
    }

    protected Array getCollection() {
        try {
            Class<?> clArrayDescriptor = Class.forName("oracle.sql.ArrayDescriptor");
            Constructor<?> constructor = classOracleARRAY.getDeclaredConstructor(clArrayDescriptor, Connection.class, Object.class);
            Object[] elements = this._javaCollection.toArray();
            this._collection = (Array)constructor.newInstance(this._arrayDescriptor, this._jdbcConn, elements);
            if (this._collection != null) {
                Method setAutoBuffering = classOracleARRAY.getDeclaredMethod("setAutoBuffering", Boolean.TYPE);
                setAutoBuffering.invoke((Object)this._collection, true);
            }
            return this._collection;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return null;
        }
    }

    public Value getElem(Env env, int index) {
        try {
            if (index < 1 || index > this._javaCollection.size()) {
                return BooleanValue.FALSE;
            }
            return env.wrapJava(this._javaCollection.get(index - 1));
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return BooleanValue.FALSE;
        }
    }

    protected ArrayList<Object> getJavaCollection() {
        return this._javaCollection;
    }

    @ReturnNullAsFalse
    public LongValue max(Env env) {
        try {
            return LongValue.create(0L);
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return null;
        }
    }

    @ReturnNullAsFalse
    public LongValue size(Env env) {
        try {
            return LongValue.create(this._javaCollection.size());
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return null;
        }
    }

    public boolean trim(Env env, int num) {
        try {
            if (num < 0) {
                return false;
            }
            if (num == 0) {
                return true;
            }
            int length = this._javaCollection.size();
            if (num > length) {
                num = length;
            }
            int i = length - num;
            this._javaCollection.subList(i, length).clear();
            return true;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return false;
        }
    }

    public String toString() {
        return "OracleOciCollection()";
    }

    static {
        try {
            classOracleARRAY = Class.forName("oracle.sql.ARRAY");
        }
        catch (Exception e) {
            L.l("Unable to load ARRAY class oracle.sql.ARRAY.");
        }
    }
}

