/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

import com.caucho.quercus.annotation.Name;
import com.caucho.quercus.annotation.NotNull;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.ReturnNullAsFalse;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.lib.db.Oracle;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OracleOciLob {
    private static final Logger log = Logger.getLogger(OracleOciLob.class.getName());
    private static final L10N L = new L10N(OracleOciLob.class);
    private Object _lob;
    private Oracle _conn;
    private long _currentPointer;
    private int _type;
    private OutputStream _outputStream;
    private Writer _writer;
    private static Class<?> classOracleBLOB;
    private static Class<?> classOracleCLOB;
    private static Method createTemporaryBLOB;
    private static Method createTemporaryCLOB;
    private static int BLOB_DURATION_CALL;
    private static int BLOB_DURATION_SESSION;
    private static int CLOB_DURATION_CALL;
    private static int CLOB_DURATION_SESSION;

    OracleOciLob(Oracle conn, int type) {
        this._conn = conn;
        this._lob = null;
        this._currentPointer = 0L;
        this._type = type;
        this._outputStream = null;
        this._writer = null;
    }

    public boolean append(Env env, OracleOciLob lobFrom) {
        try {
            switch (this._type) {
                case 12: {
                    break;
                }
                case 13: {
                    if (this._lob instanceof Blob) {
                        Blob blob = (Blob)this._lob;
                        return this.appendInternalBlob(env, lobFrom);
                    }
                    if (!(this._lob instanceof Clob)) break;
                    Clob clob = (Clob)this._lob;
                    return this.appendInternalClob(env, lobFrom);
                }
            }
            return true;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return false;
        }
    }

    public boolean close(Env env) {
        try {
            this._currentPointer = 0L;
            if (this._outputStream != null) {
                this._outputStream.close();
                this._outputStream = null;
            }
            if (this._writer != null) {
                this._writer.close();
                this._writer = null;
            }
            return true;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return false;
        }
    }

    public boolean eof(Env env) {
        try {
            long length = -1L;
            switch (this._type) {
                case 12: {
                    break;
                }
                case 13: {
                    if (this._lob instanceof Blob) {
                        Blob blob = (Blob)this._lob;
                        length = blob.length();
                        break;
                    }
                    if (!(this._lob instanceof Clob)) break;
                    Clob clob = (Clob)this._lob;
                    length = clob.length();
                    break;
                }
            }
            if (this._currentPointer == length) {
                return true;
            }
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
        }
        return false;
    }

    @ReturnNullAsFalse
    public LongValue erase(Env env, @Optional(value="0") long offset, @Optional(value="-1") long length) {
        try {
            if (offset < 0L) {
                offset = 0L;
            }
            switch (this._type) {
                case 12: {
                    break;
                }
                case 13: {
                    if (this._lob instanceof Blob) {
                        long remaining;
                        Blob blob = (Blob)this._lob;
                        if (this._outputStream != null) {
                            this._outputStream.close();
                        }
                        this._outputStream = blob.setBinaryStream(offset);
                        long blobLength = blob.length();
                        if (length < 0L || offset + length > blobLength) {
                            length = blobLength - offset;
                        }
                        byte[] zeroBuffer = new byte[128];
                        for (remaining = length; remaining >= 128L; remaining -= 128L) {
                            this._outputStream.write(zeroBuffer, 0, 128);
                        }
                        if (remaining > 0L) {
                            this._outputStream.write(zeroBuffer, 0, (int)remaining);
                        }
                        this._outputStream.close();
                        this._outputStream = null;
                    } else if (this._lob instanceof Clob) {
                        long remaining;
                        Clob clob = (Clob)this._lob;
                        if (this._writer != null) {
                            this._writer.close();
                        }
                        this._writer = clob.setCharacterStream(offset);
                        long clobLength = clob.length();
                        if (length < 0L || offset + length > clobLength) {
                            length = clobLength - offset;
                        }
                        char[] spaceBuffer = new char[128];
                        for (remaining = length; remaining >= 128L; remaining -= 128L) {
                            this._writer.write(spaceBuffer, 0, 128);
                        }
                        if (remaining > 0L) {
                            this._writer.write(spaceBuffer, 0, (int)remaining);
                        }
                        this._writer.close();
                        this._writer = null;
                    }
                    this._currentPointer = offset + length;
                    break;
                }
            }
            if (length > 0L) {
                return LongValue.create(length);
            }
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
        }
        return null;
    }

    public boolean export(Env env, Path file, @Optional(value="0") long start, @Optional(value="-1") long length) {
        try {
            WriteStream writeStream = file.openWrite();
            if (this._lob instanceof Blob) {
                Blob blob = (Blob)this._lob;
                InputStream is = blob.getBinaryStream();
                is.skip(start);
                writeStream.writeStream(is);
                is.close();
            } else if (this._lob instanceof Clob) {
                Clob clob = (Clob)this._lob;
                Reader reader = clob.getCharacterStream();
                reader.skip(start);
                writeStream.writeStream(reader);
                reader.close();
            } else {
                writeStream.close();
                return false;
            }
            writeStream.close();
            return true;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return false;
        }
    }

    public boolean flush(Env env, @Optional(value="-1") int flag) {
        try {
            if (this._outputStream != null) {
                this._outputStream.flush();
            }
            if (this._writer != null) {
                this._writer.flush();
            }
            if (flag == 93) {
                this.close(env);
            }
            return true;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return false;
        }
    }

    public boolean free(Env env) {
        try {
            this._lob = null;
            return true;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return false;
        }
    }

    public boolean getBuffering(Env env) {
        return true;
    }

    @Name(value="import")
    public boolean q_import(Env env, Path file) {
        try {
            ReadStream readStream = file.openRead();
            if (this._lob instanceof Blob) {
                long nbytes;
                Blob blob = (Blob)this._lob;
                blob.truncate(0L);
                if (this._outputStream != null) {
                    this._outputStream.close();
                }
                this._outputStream = blob.setBinaryStream(0L);
                byte[] buffer = new byte[128];
                while ((nbytes = (long)readStream.read(buffer, 0, 128)) > 0L) {
                    this._outputStream.write(buffer, 0, (int)nbytes);
                    this._currentPointer += nbytes;
                }
                this._outputStream.close();
                this._outputStream = null;
            } else if (this._lob instanceof Clob) {
                long nchars;
                Clob clob = (Clob)this._lob;
                clob.truncate(0L);
                if (this._writer != null) {
                    this._writer.close();
                }
                this._writer = clob.setCharacterStream(0L);
                char[] buffer = new char[128];
                while ((nchars = (long)readStream.read(buffer, 0, 128)) > 0L) {
                    this._writer.write(buffer, 0, (int)nchars);
                    this._currentPointer += nchars;
                }
                this._writer.close();
                this._writer = null;
            } else {
                readStream.close();
                return false;
            }
            readStream.close();
            return true;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return false;
        }
    }

    @ReturnNullAsFalse
    public Object load(Env env) {
        try {
            switch (this._type) {
                case 12: {
                    break;
                }
                case 13: {
                    if (this._lob instanceof Blob) {
                        return this.readInternalBlob(env, -1L);
                    }
                    if (!(this._lob instanceof Clob)) break;
                    return this.readInternalClob(env, -1L);
                }
            }
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
        }
        return null;
    }

    @ReturnNullAsFalse
    public Object read(Env env, long length) {
        try {
            switch (this._type) {
                case 12: {
                    break;
                }
                case 13: {
                    if (this._lob instanceof Blob) {
                        return this.readInternalBlob(env, length);
                    }
                    if (!(this._lob instanceof Clob)) break;
                    return this.readInternalClob(env, length);
                }
            }
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
        }
        return null;
    }

    public boolean rewind(Env env) {
        return this.seek(env, 0L, 94);
    }

    public boolean save(Env env, @NotNull String data, @Optional(value="0") long offset) {
        try {
            switch (this._type) {
                case 12: {
                    break;
                }
                case 13: {
                    if (this._lob instanceof Blob) {
                        Blob blob = (Blob)this._lob;
                        if (this._outputStream != null) {
                            this._outputStream.close();
                        }
                        this._outputStream = blob.setBinaryStream(offset);
                        this._outputStream.write(data.getBytes());
                        this._outputStream.close();
                        this._outputStream = null;
                    } else if (this._lob instanceof Clob) {
                        Clob clob = (Clob)this._lob;
                        if (this._writer != null) {
                            this._writer.close();
                        }
                        this._writer = clob.setCharacterStream(offset);
                        this._writer.write(data);
                        this._writer.close();
                        this._writer = null;
                    }
                    this._currentPointer = offset + (long)data.length();
                    break;
                }
            }
            return true;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return false;
        }
    }

    public boolean saveFile(Env env, Path file) {
        return this.q_import(env, file);
    }

    public boolean seek(Env env, long offset, @Optional(value="-1") int whence) {
        try {
            switch (whence) {
                case 94: {
                    this._currentPointer = offset;
                    break;
                }
                case 106: {
                    long length = 0L;
                    if (this._lob instanceof Blob) {
                        length = ((Blob)this._lob).length();
                    } else if (this._lob instanceof Clob) {
                        length = ((Clob)this._lob).length();
                    } else {
                        L.l("Unable to determine large object's length trying to seek with OCI_SEEK_END");
                        return false;
                    }
                    this._currentPointer = length + offset;
                    break;
                }
                default: {
                    this._currentPointer += offset;
                }
            }
            return true;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return false;
        }
    }

    public boolean setBuffering(Env env, boolean onOff) {
        return true;
    }

    protected void setLob(Object lob) {
        this._lob = lob;
    }

    @ReturnNullAsFalse
    public LongValue size(Env env) {
        try {
            switch (this._type) {
                case 12: {
                    break;
                }
                case 13: {
                    if (this._lob instanceof Blob) {
                        Blob blob = (Blob)this._lob;
                        return LongValue.create(blob.length());
                    }
                    if (!(this._lob instanceof Clob)) break;
                    Clob clob = (Clob)this._lob;
                    return LongValue.create(clob.length());
                }
            }
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
        }
        return null;
    }

    @ReturnNullAsFalse
    public LongValue tell(Env env) {
        try {
            return LongValue.create(this._currentPointer);
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return null;
        }
    }

    public String toString() {
        String typeName = "UNKNOWN";
        switch (this._type) {
            case 12: {
                typeName = "OCI_D_FILE";
                break;
            }
            case 13: {
                typeName = "OCI_D_LOB";
                break;
            }
            case 14: {
                typeName = "OCI_D_ROWID";
            }
        }
        return "OracleOciLob(" + typeName + ")";
    }

    public boolean truncate(Env env, @Optional(value="0") long length) {
        try {
            switch (this._type) {
                case 12: {
                    break;
                }
                case 13: {
                    if (this._lob instanceof Blob) {
                        Blob blob = (Blob)this._lob;
                        blob.truncate(length);
                        break;
                    }
                    if (!(this._lob instanceof Clob)) break;
                    Clob clob = (Clob)this._lob;
                    clob.truncate(length);
                    break;
                }
            }
            return true;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return false;
        }
    }

    @ReturnNullAsFalse
    public LongValue write(Env env, String data, @Optional(value="-1") long length) {
        try {
            long dataLength = data.length();
            if (length < 0L || length > dataLength) {
                length = dataLength;
            }
            switch (this._type) {
                case 12: {
                    break;
                }
                case 13: {
                    long written = 0L;
                    if (this._lob instanceof Blob) {
                        Blob blob = (Blob)this._lob;
                        if (this._outputStream == null) {
                            this._outputStream = blob.setBinaryStream(0L);
                        }
                        this._outputStream.write(data.getBytes());
                    } else if (this._lob instanceof Clob) {
                        Clob clob = (Clob)this._lob;
                        if (this._writer == null) {
                            this._writer = clob.setCharacterStream(0L);
                        }
                        this._writer.write(data);
                    }
                    this._currentPointer += length;
                    break;
                }
            }
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
        }
        return null;
    }

    public boolean writeTemporary(Env env, String data, @Optional(value="-1") int lobType) {
        try {
            if (this._type != 13) {
                L.l("Unable to write a temporary LOB into a non-lob object");
                return false;
            }
            this._lob = lobType == 17 ? createTemporaryBLOB.invoke(classOracleBLOB, this._conn, true, BLOB_DURATION_SESSION) : createTemporaryCLOB.invoke(classOracleCLOB, this._conn, true, CLOB_DURATION_SESSION);
            return true;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return false;
        }
    }

    public boolean writeToFile(Env env, Path file, @Optional(value="0") long start, @Optional(value="-1") long length) {
        return this.export(env, file, start, length);
    }

    private boolean appendInternalBlob(Env env, OracleOciLob lobFrom) {
        try {
            long nbytes;
            Blob blob = (Blob)this._lob;
            long blobLength = blob.length();
            if (this._currentPointer != blobLength) {
                if (this._outputStream != null) {
                    this._outputStream.close();
                }
                this._outputStream = blob.setBinaryStream(blobLength);
                this._currentPointer = blobLength;
            }
            Blob blobFrom = (Blob)((Object)lobFrom);
            InputStream is = blobFrom.getBinaryStream();
            byte[] buffer = new byte[128];
            while ((nbytes = (long)is.read(buffer)) > 0L) {
                this._outputStream.write(buffer, 0, (int)nbytes);
                this._currentPointer += nbytes;
            }
            is.close();
            return true;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return false;
        }
    }

    private boolean appendInternalClob(Env env, OracleOciLob lobFrom) {
        try {
            long nchars;
            Clob clob = (Clob)this._lob;
            long clobLength = clob.length();
            if (this._currentPointer != clobLength) {
                if (this._writer != null) {
                    this._writer.close();
                }
                this._writer = clob.setCharacterStream(clobLength);
                this._currentPointer = clobLength;
            }
            Clob clobFrom = (Clob)((Object)lobFrom);
            Reader reader = clobFrom.getCharacterStream();
            char[] buffer = new char[128];
            while ((nchars = (long)reader.read(buffer)) > 0L) {
                this._writer.write(buffer, 0, (int)nchars);
                this._currentPointer += nchars;
            }
            reader.close();
            return true;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return false;
        }
    }

    private StringValue readInternalBlob(Env env, long length) {
        try {
            StringValue bb = env.createBinaryBuilder();
            Blob blob = (Blob)this._lob;
            InputStream is = blob.getBinaryStream();
            is.skip(this._currentPointer);
            if (length < 0L) {
                length = Integer.MAX_VALUE;
            }
            bb.appendReadAll(is, length);
            is.close();
            return bb;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return null;
        }
    }

    private StringValue readInternalClob(Env env, long length) {
        try {
            StringValue sb = env.createUnicodeBuilder();
            Clob clob = (Clob)this._lob;
            Reader reader = clob.getCharacterStream();
            reader.skip(this._currentPointer);
            if (length < 0L) {
                length = Integer.MAX_VALUE;
            }
            sb.append(reader, length);
            reader.close();
            return sb;
        }
        catch (Exception ex) {
            log.log(Level.FINE, ex.toString(), ex);
            return null;
        }
    }

    static {
        try {
            classOracleBLOB = Class.forName("oracle.sql.BLOB");
            classOracleCLOB = Class.forName("oracle.sql.CLOB");
            createTemporaryBLOB = classOracleBLOB.getDeclaredMethod("createTemporary", Connection.class, Boolean.TYPE, Integer.TYPE);
            createTemporaryCLOB = classOracleCLOB.getDeclaredMethod("createTemporary", Connection.class, Boolean.TYPE, Integer.TYPE);
            BLOB_DURATION_CALL = classOracleBLOB.getDeclaredField("DURATION_CALL").getInt(null);
            BLOB_DURATION_SESSION = classOracleBLOB.getDeclaredField("DURATION_SESSION").getInt(null);
            CLOB_DURATION_CALL = classOracleCLOB.getDeclaredField("DURATION_CALL").getInt(null);
            CLOB_DURATION_SESSION = classOracleCLOB.getDeclaredField("DURATION_SESSION").getInt(null);
        }
        catch (Exception e) {
            log.log(Level.FINER, L.l("Unable to load LOB classes or methods for oracle.sql.BLOB and oracle.sql.CLOB."));
        }
    }
}

