/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.filter;

import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.UnsetValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.filter.AbstractFilter;
import com.caucho.quercus.lib.filter.ValidateFilter;

public class IntValidateFilter
extends AbstractFilter
implements ValidateFilter {
    protected Value filterImpl(Env env, Value value, int flags, ArrayValue options) {
        long min = Long.MIN_VALUE;
        long max = Long.MAX_VALUE;
        if (options != null) {
            Value minV = options.get(env.createString("min_range"));
            Value maxV = options.get(env.createString("max_range"));
            if (minV != UnsetValue.UNSET) {
                min = minV.toLong();
            }
            if (maxV != UnsetValue.UNSET) {
                max = maxV.toLong();
            }
        }
        if (!value.isLongConvertible() && value != BooleanValue.TRUE) {
            return BooleanValue.FALSE;
        }
        LongValue val = value.toLongValue();
        long v = val.toLong();
        if (min <= v && v <= max) {
            return val;
        }
        return BooleanValue.FALSE;
    }
}

