/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.gettext;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.lib.gettext.GettextParser;
import com.caucho.quercus.lib.gettext.expr.PluralExpr;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class POFileParser
extends GettextParser {
    private static final Logger log = Logger.getLogger(POFileParser.class.getName());
    private static final L10N L = new L10N(POFileParser.class);
    private static final int MSGID = 256;
    private static final int MSGID_PLURAL = 257;
    private static final int MSGSTR = 258;
    private static final int UNKNOWN = 260;
    private Env _env;
    private ReadStream _in;
    private int _peekChar;
    private StringValue _string;

    POFileParser(Env env, Path path) throws IOException {
        this._env = env;
        this.init(path);
    }

    void init(Path path) throws IOException {
        this._in = path.openRead();
        this._peekChar = -1;
        StringValue metadata = this.getMetadata();
        this._pluralExpr = PluralExpr.getPluralExpr(metadata);
        this._charset = POFileParser.getCharset(metadata);
        this._in.setEncoding(this._charset);
    }

    private StringValue getMetadata() throws IOException {
        StringValue metadata = null;
        int token = this.readToken();
        while (token >= 0 && token != 260) {
            if (token != 256 || this._string.length() != 0) continue;
            if (this.readToken() != 258) break;
            metadata = this._string;
            break;
        }
        this._peekChar = -1;
        this._in.setPosition(0L);
        return metadata;
    }

    @Override
    HashMap<StringValue, ArrayList<StringValue>> readTranslations() throws IOException {
        HashMap<StringValue, ArrayList<StringValue>> translations = new HashMap<StringValue, ArrayList<StringValue>>();
        int token = this.readToken();
        while (token >= 0) {
            if (token != 256) {
                return null;
            }
            StringValue msgid = this._string;
            token = this.readToken();
            if (token == 257) {
                token = this.readToken();
            }
            ArrayList<StringValue> msgstrs = new ArrayList<StringValue>();
            while (token == 258) {
                msgstrs.add(this._string);
                token = this.readToken();
            }
            translations.put(msgid, msgstrs);
        }
        return translations;
    }

    private int readToken() throws IOException {
        int ch = this.skipWhitespace();
        switch (ch) {
            case 35: {
                this.skipLine();
                return this.readToken();
            }
            case 109: {
                if (this.read() == 115 && this.read() == 103) {
                    return this.readMsgToken();
                }
                return 260;
            }
            case -1: {
                return -1;
            }
        }
        return 260;
    }

    private int readMsgToken() throws IOException {
        int ch = this.read();
        switch (ch) {
            case 105: {
                if (this.read() == 100) {
                    return this.readMsgidToken();
                }
                return 260;
            }
            case 115: {
                if (this.read() == 116 && this.read() == 114) {
                    return this.readMsgstrToken();
                }
                return 260;
            }
        }
        return 260;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int readMsgidToken() throws IOException {
        int token;
        int ch = this.skipWhitespace();
        if (ch == 95) {
            if (this.read() != 112 || this.read() != 108 || this.read() != 117 || this.read() != 114 || this.read() != 97 || this.read() != 108) return 260;
            token = 257;
            ch = this.skipWhitespace();
        } else {
            token = 256;
        }
        if (ch == 34) return this.readOriginalString(token);
        return 260;
    }

    private int readMsgstrToken() throws IOException {
        int ch = this.skipWhitespace();
        if (ch == 91) {
            ch = this.read();
            while (ch >= 0 && ch != 93) {
                ch = this.read();
            }
            ch = this.skipWhitespace();
        }
        if (ch != 34) {
            return 260;
        }
        return this.readString(258);
    }

    private int readOriginalString(int token) throws IOException {
        return this.readString(this._env.createUnicodeBuilder(), token);
    }

    private int readString(int token) throws IOException {
        return this.readString(new UnicodeBuilderValue(), token);
    }

    private int readString(StringValue sb, int token) throws IOException {
        int ch = this.read();
        while (ch != 34) {
            block0 : switch (ch) {
                case 92: {
                    ch = this.read();
                    switch (ch) {
                        case 110: {
                            sb.append('\n');
                            break;
                        }
                        case 114: {
                            sb.append('\r');
                            break;
                        }
                        case 116: {
                            sb.append('\t');
                            break;
                        }
                        case 13: {
                            ch = this.read();
                            if (ch == 10) break block0;
                            this._peekChar = ch;
                            break;
                        }
                        case 10: {
                            break;
                        }
                        default: {
                            this._peekChar = ch;
                            sb.append('\\');
                            break;
                        }
                    }
                    break;
                }
                case -1: {
                    return 260;
                }
                default: {
                    sb.append((char)ch);
                }
            }
            ch = this.read();
        }
        ch = this.skipWhitespace();
        if (ch == 34) {
            return this.readString(sb, token);
        }
        this._peekChar = ch;
        this._string = sb;
        return token;
    }

    private int read() throws IOException {
        if (this._peekChar >= 0) {
            int swap = this._peekChar;
            this._peekChar = -1;
            return swap;
        }
        return this._in.readChar();
    }

    private void skipLine() throws IOException {
        int ch = this.read();
        while (ch >= 0) {
            switch (ch) {
                case 13: {
                    ch = this.read();
                    if (ch != 10) {
                        this._peekChar = ch;
                    }
                    return;
                }
                case 10: {
                    return;
                }
            }
            ch = this.read();
        }
    }

    private int skipWhitespace() throws IOException {
        int ch;
        block3: while (true) {
            ch = this.read();
            switch (ch) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    continue block3;
                }
            }
            break;
        }
        return ch;
    }

    @Override
    void close() {
        if (this._in != null) {
            this._in.close();
        }
    }
}

