/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.gettext.expr;

import com.caucho.quercus.lib.gettext.expr.AddExpr;
import com.caucho.quercus.lib.gettext.expr.AndExpr;
import com.caucho.quercus.lib.gettext.expr.DivExpr;
import com.caucho.quercus.lib.gettext.expr.EQExpr;
import com.caucho.quercus.lib.gettext.expr.Expr;
import com.caucho.quercus.lib.gettext.expr.GEExpr;
import com.caucho.quercus.lib.gettext.expr.GTExpr;
import com.caucho.quercus.lib.gettext.expr.IfExpr;
import com.caucho.quercus.lib.gettext.expr.LEExpr;
import com.caucho.quercus.lib.gettext.expr.LTExpr;
import com.caucho.quercus.lib.gettext.expr.LiteralExpr;
import com.caucho.quercus.lib.gettext.expr.ModExpr;
import com.caucho.quercus.lib.gettext.expr.MulExpr;
import com.caucho.quercus.lib.gettext.expr.NEQExpr;
import com.caucho.quercus.lib.gettext.expr.NExpr;
import com.caucho.quercus.lib.gettext.expr.OrExpr;
import com.caucho.quercus.lib.gettext.expr.SubExpr;

class PluralExprParser {
    static final int INTEGER = 256;
    static final int EQ = 270;
    static final int NEQ = 271;
    static final int LE = 272;
    static final int GE = 273;
    static final int AND = 280;
    static final int OR = 281;
    static final int VARIABLE_N = 290;
    static final int UNKNOWN = 291;
    static final int UNSET = 292;
    private CharSequence _expr;
    private int _exprLength;
    private int _parseIndex;
    private Expr _npluralsExpr;
    private Expr _pluralExpr;
    private int _peekToken;
    private int _integer;
    private boolean _isError;
    private boolean _isInitialized;

    protected PluralExprParser(CharSequence expr) {
        this._expr = expr;
        this._exprLength = expr.length();
        this._isInitialized = false;
    }

    public Expr getNpluralsExpr() {
        if (!this._isInitialized) {
            this.init();
        }
        if (this._isError) {
            return null;
        }
        return this._npluralsExpr;
    }

    public Expr getPluralExpr() {
        if (!this._isInitialized) {
            this.init();
        }
        if (this._isError) {
            return null;
        }
        return this._pluralExpr;
    }

    private void init() {
        this._parseIndex = 0;
        this._peekToken = 292;
        this._isError = false;
        this.parseAssignExpr();
        this.parseAssignExpr();
        this._isInitialized = true;
    }

    private void parseAssignExpr() {
        boolean isNplurals;
        int ch = this.consumeWhiteSpace();
        if (ch == 110 && this.read() == 112 && this.read() == 108 && this.read() == 117 && this.read() == 114 && this.read() == 97 && this.read() == 108 && this.read() == 115) {
            isNplurals = true;
        } else if (ch == 112 && this.read() == 108 && this.read() == 117 && this.read() == 114 && this.read() == 97 && this.read() == 108) {
            isNplurals = false;
        } else {
            return;
        }
        ch = this.consumeWhiteSpace();
        if (ch != 61) {
            return;
        }
        if (isNplurals) {
            this._npluralsExpr = this.parseIfExpr();
        } else {
            this._pluralExpr = this.parseIfExpr();
        }
        this.parseToken();
    }

    private Expr parseLiteralExpr() {
        int token = this.parseToken();
        if (token == 256) {
            return new LiteralExpr(this._integer);
        }
        if (token == 290) {
            return NExpr.N_EXPR;
        }
        return this.error("Expected INTEGER");
    }

    private Expr parseParenExpr() {
        int token = this.parseToken();
        if (token != 40) {
            this._peekToken = token;
            return this.parseLiteralExpr();
        }
        Expr expr = this.parseIfExpr();
        if (this.parseToken() != 41) {
            return this.error("Expected ')'");
        }
        return expr;
    }

    private Expr parseMulExpr() {
        int token;
        Expr expr = this.parseParenExpr();
        block5: while (true) {
            token = this.parseToken();
            switch (token) {
                case 37: {
                    expr = new ModExpr(expr, this.parseParenExpr());
                    continue block5;
                }
                case 42: {
                    expr = new MulExpr(expr, this.parseParenExpr());
                    continue block5;
                }
                case 47: {
                    expr = new DivExpr(expr, this.parseParenExpr());
                    continue block5;
                }
            }
            break;
        }
        this._peekToken = token;
        return expr;
    }

    private Expr parseAddExpr() {
        int token;
        Expr expr = this.parseMulExpr();
        block4: while (true) {
            token = this.parseToken();
            switch (token) {
                case 43: {
                    expr = new AddExpr(expr, this.parseMulExpr());
                    continue block4;
                }
                case 45: {
                    expr = new SubExpr(expr, this.parseMulExpr());
                    continue block4;
                }
            }
            break;
        }
        this._peekToken = token;
        return expr;
    }

    private Expr parseCmpExpr() {
        int token;
        Expr expr = this.parseAddExpr();
        block8: while (true) {
            token = this.parseToken();
            switch (token) {
                case 62: {
                    expr = new GTExpr(expr, this.parseAddExpr());
                    continue block8;
                }
                case 60: {
                    expr = new LTExpr(expr, this.parseAddExpr());
                    continue block8;
                }
                case 273: {
                    expr = new GEExpr(expr, this.parseAddExpr());
                    continue block8;
                }
                case 272: {
                    expr = new LEExpr(expr, this.parseAddExpr());
                    continue block8;
                }
                case 270: {
                    expr = new EQExpr(expr, this.parseAddExpr());
                    continue block8;
                }
                case 271: {
                    expr = new NEQExpr(expr, this.parseAddExpr());
                    continue block8;
                }
            }
            break;
        }
        this._peekToken = token;
        return expr;
    }

    private Expr parseAndExpr() {
        Expr expr = this.parseCmpExpr();
        while (true) {
            int token;
            if ((token = this.parseToken()) != 280) {
                this._peekToken = token;
                return expr;
            }
            expr = new AndExpr(expr, this.parseCmpExpr());
        }
    }

    private Expr parseOrExpr() {
        Expr expr = this.parseAndExpr();
        while (true) {
            int token;
            if ((token = this.parseToken()) != 281) {
                this._peekToken = token;
                return expr;
            }
            expr = new OrExpr(expr, this.parseAndExpr());
        }
    }

    private Expr parseIfExpr() {
        Expr expr = this.parseOrExpr();
        int token = this.parseToken();
        if (token != 63) {
            this._peekToken = token;
            return expr;
        }
        Expr trueExpr = this.parseIfExpr();
        token = this.parseToken();
        if (token != 58) {
            return this.error("Expected ':'");
        }
        Expr falseExpr = this.parseIfExpr();
        return new IfExpr(expr, trueExpr, falseExpr);
    }

    private int parseToken() {
        if (this._peekToken != 292) {
            int toReturn = this._peekToken;
            this._peekToken = 292;
            return toReturn;
        }
        int ch = this.consumeWhiteSpace();
        switch (ch) {
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 58: 
            case 59: 
            case 63: {
                return ch;
            }
            case 62: {
                if (this.read() == 61) {
                    return 273;
                }
                this.unread();
                return 62;
            }
            case 60: {
                if (this.read() == 61) {
                    return 272;
                }
                this.unread();
                return 60;
            }
            case 61: {
                if (this.read() == 61) {
                    return 270;
                }
                return 291;
            }
            case 33: {
                if (this.read() == 61) {
                    return 271;
                }
                return 291;
            }
            case 38: {
                if (this.read() == 38) {
                    return 280;
                }
                return 291;
            }
            case 124: {
                if (this.read() == 124) {
                    return 281;
                }
                return 291;
            }
        }
        return this.parseIntegerToken(ch);
    }

    private int parseIntegerToken(int ch) {
        if (48 <= ch && ch <= 57) {
            this._integer = ch - 48;
            ch = this.read();
            while (48 <= ch && ch <= 57) {
                this._integer = this._integer * 10 + ch - 48;
                ch = this.read();
            }
            this.unread();
            return 256;
        }
        if (ch == 110) {
            if (Character.isLetter(this.read())) {
                return 291;
            }
            this.unread();
            return 290;
        }
        return 291;
    }

    private int consumeWhiteSpace() {
        int ch;
        block3: while (true) {
            ch = this.read();
            switch (ch) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    continue block3;
                }
            }
            break;
        }
        return ch;
    }

    private int read() {
        if (this._parseIndex < this._exprLength) {
            return this._expr.charAt(this._parseIndex++);
        }
        return -1;
    }

    private void unread() {
        if (this._parseIndex > 0 && this._parseIndex < this._exprLength) {
            --this._parseIndex;
        }
    }

    private Expr error(String message) {
        this._isError = true;
        return NExpr.N_EXPR;
    }
}

