/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.simplexml;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.simplexml.AttributeListView;
import com.caucho.quercus.lib.simplexml.AttributeView;
import com.caucho.quercus.lib.simplexml.ChildrenView;
import com.caucho.quercus.lib.simplexml.DocumentView;
import com.caucho.quercus.lib.simplexml.ElementView;
import com.caucho.quercus.lib.simplexml.IteratorIndex;
import com.caucho.quercus.lib.simplexml.SimpleNamespaceContext;
import com.caucho.quercus.lib.simplexml.TextView;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleView {
    private final Document _doc;

    public SimpleView(Document doc) {
        this._doc = doc;
    }

    public final Document getOwnerDocument() {
        return this._doc;
    }

    public String getNodeName() {
        throw new UnsupportedOperationException();
    }

    public String getNodeValue() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName());
    }

    public final String getEncoding() {
        Document doc = this._doc;
        String encoding = doc.getInputEncoding();
        if (encoding == null) {
            encoding = doc.getXmlEncoding();
        }
        if (encoding == null) {
            encoding = "utf-8";
        }
        return encoding;
    }

    public ChildrenView getChildren(String namespace, String prefix) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName());
    }

    public AttributeListView getAttributes(String namespace) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName());
    }

    public SimpleView addChild(Env env, String name, String value, String namespace) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName());
    }

    public void addAttribute(Env env, String name, String value, String namespace) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName());
    }

    public List<SimpleView> xpath(Env env, SimpleNamespaceContext context, String expression) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName());
    }

    protected Node getNode() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName());
    }

    public HashMap<String, String> getNamespaces(boolean isRecursive, boolean isFromRoot, boolean isCheckUsage) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName());
    }

    public abstract SimpleView getIndex(Env var1, Value var2);

    public abstract SimpleView setIndex(Env var1, Value var2, Value var3);

    public abstract SimpleView getField(Env var1, Value var2);

    public abstract SimpleView setField(Env var1, Value var2, Value var3);

    public Iterator<Map.Entry<IteratorIndex, SimpleView>> getIterator() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName());
    }

    public Set<Map.Entry<Value, Value>> getEntrySet(Env env, QuercusClass cls) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName());
    }

    public abstract String toString(Env var1);

    public abstract boolean toXml(Env var1, StringBuilder var2);

    public Value toDumpValue(Env env, QuercusClass cls, boolean isChildren) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName());
    }

    public void varDump(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet, QuercusClass cls) throws IOException {
        Value value = this.toDumpValue(env, cls, false);
        value.varDump(env, out, depth, valueSet);
    }

    public void printR(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet, QuercusClass cls) throws IOException {
        Value value = this.toDumpValue(env, cls, false);
        value.printR(env, out, depth, valueSet);
    }

    public int getCount() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName());
    }

    protected static SimpleView create(Node node) {
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 1: {
                return new ElementView(node);
            }
            case 2: {
                return new AttributeView((Attr)node);
            }
            case 3: {
                return new TextView((Text)node);
            }
            case 9: {
                return new DocumentView((Document)node);
            }
        }
        throw new IllegalStateException(node.getClass().getSimpleName());
    }

    protected static List<SimpleView> xpath(Node node, SimpleNamespaceContext context, String expression) throws XPathExpressionException {
        XPath xpath = context.getXPath();
        NodeList nodes = null;
        try {
            XPathExpression expr = xpath.compile(expression);
            nodes = (NodeList)expr.evaluate(node, XPathConstants.NODESET);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        int nodeLength = nodes.getLength();
        if (nodeLength == 0) {
            return null;
        }
        ArrayList<SimpleView> result = new ArrayList<SimpleView>();
        for (int i = 0; i < nodeLength; ++i) {
            Node nodeResult = nodes.item(i);
            SimpleView view = SimpleView.create(nodeResult);
            result.add(view);
        }
        return result;
    }
}

