/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.string;

public class Crypt {
    private static final boolean[] KEY_SHIFTS = new boolean[]{false, false, true, true, true, true, true, true, false, true, true, true, true, true, true, false};
    private static final int[] REVERSE_BITS = new int[]{0, 32, 16, 48, 8, 40, 24, 56, 4, 36, 20, 52, 12, 44, 28, 60, 2, 34, 18, 50, 10, 42, 26, 58, 6, 38, 22, 54, 14, 46, 30, 62, 1, 33, 17, 49, 9, 41, 25, 57, 5, 37, 21, 53, 13, 45, 29, 61, 3, 35, 19, 51, 11, 43, 27, 59, 7, 39, 23, 55, 15, 47, 31, 63};
    private static final int[] des_0 = new int[]{0x2080800, 524288, 0x2000002, 0x2080802, 0x2000000, 526338, 524290, 0x2000002, 526338, 0x2080800, 0x2080000, 2050, 0x2000802, 0x2000000, 0, 524290, 524288, 2, 0x2000800, 526336, 0x2080802, 0x2080000, 2050, 0x2000800, 2, 2048, 526336, 0x2080002, 2048, 0x2000802, 0x2080002, 0, 0, 0x2080802, 0x2000800, 524290, 0x2080800, 524288, 2050, 0x2000800, 0x2080002, 2048, 526336, 0x2000002, 526338, 2, 0x2000002, 0x2080000, 0x2080802, 526336, 0x2080000, 0x2000802, 0x2000000, 2050, 524290, 0, 524288, 0x2000000, 0x2000802, 0x2080800, 2, 0x2080002, 2048, 526338};
    private static final int[] des_1 = new int[]{1074823184, 0, 0x108000, 0x40100000, 0x40000010, 32784, 0x40008000, 0x108000, 32768, 0x40100010, 16, 0x40008000, 0x100010, 1074823168, 0x40100000, 16, 0x100000, 1073774608, 0x40100010, 32768, 0x108010, 0x40000000, 0, 0x100010, 1073774608, 0x108010, 1074823168, 0x40000010, 0x40000000, 0x100000, 32784, 1074823184, 0x100010, 1074823168, 0x40008000, 0x108010, 1074823184, 0x100010, 0x40000010, 0, 0x40000000, 32784, 0x100000, 0x40100010, 32768, 0x40000000, 0x108010, 1073774608, 1074823168, 32768, 0, 0x40000010, 16, 1074823184, 0x108000, 0x40100000, 0x40100010, 0x100000, 32784, 0x40008000, 1073774608, 16, 0x40100000, 0x108000};
    private static final int[] des_2 = new int[]{0x4000001, 0x4040100, 256, 0x4000101, 262145, 0x4000000, 0x4000101, 262400, 0x4000100, 262144, 0x4040000, 1, 0x4040101, 257, 1, 0x4040001, 0, 262145, 0x4040100, 256, 257, 0x4040101, 262144, 0x4000001, 0x4040001, 0x4000100, 262401, 0x4040000, 262400, 0, 0x4000000, 262401, 0x4040100, 256, 1, 262144, 257, 262145, 0x4040000, 0x4000101, 0, 0x4040100, 262400, 0x4040001, 262145, 0x4000000, 0x4040101, 1, 262401, 0x4000001, 0x4000000, 0x4040101, 262144, 0x4000100, 0x4000101, 262400, 0x4000100, 0, 0x4040001, 257, 0x4000001, 262401, 256, 0x4040000};
    private static final int[] des_3 = new int[]{4198408, 0x10001000, 8, 272633864, 0, 0x10400000, 0x10001008, 0x400008, 0x10401000, 0x10000008, 0x10000000, 4104, 0x10000008, 4198408, 0x400000, 0x10000000, 272629768, 0x401000, 4096, 8, 0x401000, 0x10001008, 0x10400000, 4096, 4104, 0, 0x400008, 0x10401000, 0x10001000, 272629768, 272633864, 0x400000, 272629768, 4104, 0x400000, 0x10000008, 0x401000, 0x10001000, 8, 0x10400000, 0x10001008, 0, 4096, 0x400008, 0, 272629768, 0x10401000, 4096, 0x10000000, 272633864, 4198408, 0x400000, 272633864, 8, 0x10001000, 4198408, 0x400008, 0x401000, 0x10400000, 0x10001008, 4104, 0x10000000, 0x10000008, 0x10401000};
    private static final int[] des_4 = new int[]{0x8000000, 65536, 1024, 134284320, 134283296, 0x8000400, 66592, 0x8010000, 65536, 32, 0x8000020, 66560, 134218784, 134283296, 134284288, 0, 66560, 0x8000000, 65568, 1056, 0x8000400, 66592, 0, 0x8000020, 32, 134218784, 134284320, 65568, 0x8010000, 1024, 1056, 134284288, 134284288, 134218784, 65568, 0x8010000, 65536, 32, 0x8000020, 0x8000400, 0x8000000, 66560, 134284320, 0, 66592, 0x8000000, 1024, 65568, 134218784, 1024, 0, 134284320, 134283296, 134284288, 1056, 65536, 66560, 134283296, 0x8000400, 1056, 32, 66592, 0x8010000, 0x8000020};
    private static final int[] des_5 = new int[]{-2147483584, 0x200040, 0, -2145378304, 0x200040, 8192, -2147475392, 0x200000, 8256, -2145378240, 0x202000, Integer.MIN_VALUE, -2147475456, -2147483584, -2145386496, 0x202040, 0x200000, -2147475392, -2145386432, 0, 8192, 64, -2145378304, -2145386432, -2145378240, -2145386496, Integer.MIN_VALUE, 8256, 64, 0x202000, 0x202040, -2147475456, 8256, Integer.MIN_VALUE, -2147475456, 0x202040, -2145378304, 0x200040, 0, -2147475456, Integer.MIN_VALUE, 8192, -2145386432, 0x200000, 0x200040, -2145378240, 0x202000, 64, -2145378240, 0x202000, 0x200000, -2147475392, -2147483584, -2145386496, 0x202040, 0, 8192, -2147483584, -2147475392, -2145378304, -2145386496, 8256, 64, -2145386432};
    private static final int[] des_6 = new int[]{16384, 512, 0x1000200, 0x1000004, 16794116, 16388, 16896, 0, 0x1000000, 16777732, 516, 0x1004000, 4, 16794112, 0x1004000, 516, 16777732, 16384, 16388, 16794116, 0, 0x1000200, 0x1000004, 16896, 0x1004004, 16900, 16794112, 4, 16900, 0x1004004, 512, 0x1000000, 16900, 0x1004000, 0x1004004, 516, 16384, 512, 0x1000000, 0x1004004, 16777732, 16900, 16896, 0, 512, 0x1000004, 4, 0x1000200, 0, 16777732, 0x1000200, 16896, 516, 16384, 16794116, 0x1000000, 16794112, 4, 16388, 16794116, 0x1000004, 16794112, 0x1004000, 16388};
    private static final int[] des_7 = new int[]{0x20800080, 0x20820000, 131200, 0, 0x20020000, 0x800080, 0x20800000, 0x20820080, 128, 0x20000000, 0x820000, 131200, 0x820080, 0x20020080, 0x20000080, 0x20800000, 131072, 0x820080, 0x800080, 0x20020000, 0x20820080, 0x20000080, 0, 0x820000, 0x20000000, 0x800000, 0x20020080, 0x20800080, 0x800000, 131072, 0x20820000, 128, 0x800000, 131072, 0x20000080, 0x20820080, 131200, 0x20000000, 0, 0x820000, 0x20800080, 0x20020080, 0x20020000, 0x800080, 0x20820000, 128, 0x800080, 0x20020000, 0x20820080, 0x800000, 0x20800000, 0x20000080, 0x820000, 131200, 0x20020080, 0x20800000, 128, 0x20820000, 0x820080, 0, 0x20000000, 0x20800080, 131072, 0x820080};
    private static final int[] skb_0 = new int[]{0, 16, 0x20000000, 0x20000010, 65536, 65552, 0x20010000, 0x20010010, 2048, 2064, 0x20000800, 536872976, 67584, 67600, 536938496, 536938512, 32, 48, 0x20000020, 0x20000030, 65568, 65584, 0x20010020, 536936496, 2080, 2096, 0x20000820, 536873008, 67616, 67632, 536938528, 536938544, 524288, 524304, 0x20080000, 537395216, 589824, 589840, 0x20090000, 537460752, 526336, 526352, 0x20080800, 537397264, 591872, 591888, 537462784, 537462800, 524320, 524336, 0x20080020, 537395248, 589856, 589872, 0x20090020, 537460784, 526368, 526384, 0x20080820, 537397296, 591904, 591920, 537462816, 537462832};
    private static final int[] skb_1 = new int[]{0, 0x2000000, 8192, 0x2002000, 0x200000, 0x2200000, 0x202000, 0x2202000, 4, 0x2000004, 8196, 0x2002004, 0x200004, 0x2200004, 0x202004, 0x2202004, 1024, 0x2000400, 9216, 0x2002400, 0x200400, 0x2200400, 0x202400, 0x2202400, 1028, 0x2000404, 9220, 0x2002404, 0x200404, 0x2200404, 0x202404, 0x2202404, 0x10000000, 0x12000000, 0x10002000, 0x12002000, 0x10200000, 0x12200000, 0x10202000, 0x12202000, 0x10000004, 301989892, 268443652, 301998084, 270532612, 304087044, 270540804, 304095236, 0x10000400, 301990912, 268444672, 301999104, 270533632, 304088064, 270541824, 304096256, 0x10000404, 301990916, 268444676, 301999108, 270533636, 304088068, 270541828, 304096260};
    private static final int[] skb_2 = new int[]{0, 1, 262144, 262145, 0x1000000, 0x1000001, 0x1040000, 0x1040001, 2, 3, 262146, 262147, 0x1000002, 0x1000003, 17039362, 17039363, 512, 513, 262656, 262657, 0x1000200, 0x1000201, 17039872, 17039873, 514, 515, 262658, 262659, 0x1000202, 16777731, 17039874, 17039875, 0x8000000, 0x8000001, 0x8040000, 134479873, 0x9000000, 0x9000001, 0x9040000, 151257089, 0x8000002, 0x8000003, 134479874, 134479875, 0x9000002, 0x9000003, 151257090, 151257091, 0x8000200, 134218241, 134480384, 134480385, 0x9000200, 150995457, 151257600, 151257601, 0x8000202, 134218243, 134480386, 134480387, 0x9000202, 150995459, 151257602, 151257603};
    private static final int[] skb_3 = new int[]{0, 0x100000, 256, 0x100100, 8, 0x100008, 264, 0x100108, 4096, 0x101000, 4352, 0x101100, 4104, 0x101008, 4360, 0x101108, 0x4000000, 0x4100000, 0x4000100, 0x4100100, 0x4000008, 68157448, 67109128, 68157704, 0x4001000, 0x4101000, 0x4001100, 0x4101100, 67112968, 68161544, 67113224, 68161800, 131072, 0x120000, 131328, 0x120100, 131080, 1179656, 131336, 1179912, 135168, 0x121000, 135424, 0x121100, 135176, 1183752, 135432, 1184008, 0x4020000, 68288512, 67240192, 68288768, 67239944, 68288520, 67240200, 68288776, 67244032, 68292608, 67244288, 68292864, 67244040, 68292616, 67244296, 68292872};
    private static final int[] skb_4 = new int[]{0, 0x10000000, 65536, 0x10010000, 4, 0x10000004, 65540, 0x10010004, 0x20000000, 0x30000000, 0x20010000, 0x30010000, 0x20000004, 0x30000004, 536936452, 805371908, 0x100000, 0x10100000, 0x110000, 0x10110000, 0x100004, 0x10100004, 0x110004, 0x10110004, 0x20100000, 0x30100000, 0x20110000, 0x30110000, 537919492, 806354948, 537985028, 806420484, 4096, 0x10001000, 69632, 0x10011000, 4100, 0x10001004, 69636, 0x10011004, 0x20001000, 0x30001000, 0x20011000, 0x30011000, 536875012, 805310468, 536940548, 805376004, 0x101000, 0x10101000, 0x111000, 0x10111000, 0x101004, 0x10101004, 0x111004, 0x10111004, 0x20101000, 0x30101000, 0x20111000, 0x30111000, 537923588, 806359044, 537989124, 806424580};
    private static final int[] skb_5 = new int[]{0, 0x8000000, 8, 0x8000008, 1024, 0x8000400, 1032, 0x8000408, 131072, 0x8020000, 131080, 0x8020008, 132096, 134349824, 132104, 134349832, 1, 0x8000001, 9, 0x8000009, 1025, 134218753, 1033, 134218761, 131073, 134348801, 131081, 134348809, 132097, 134349825, 132105, 134349833, 0x2000000, 0xA000000, 0x2000008, 0xA000008, 0x2000400, 0xA000400, 33555464, 167773192, 0x2020000, 0xA020000, 0x2020008, 167903240, 0x2020400, 167904256, 33686536, 167904264, 0x2000001, 0xA000001, 0x2000009, 0xA000009, 33555457, 167773185, 33555465, 167773193, 0x2020001, 167903233, 0x2020009, 167903241, 33686529, 167904257, 33686537, 167904265};
    private static final int[] skb_6 = new int[]{0, 256, 524288, 524544, 0x1000000, 0x1000100, 0x1080000, 0x1080100, 16, 272, 524304, 524560, 0x1000010, 0x1000110, 0x1080010, 0x1080110, 0x200000, 0x200100, 0x280000, 2621696, 0x1200000, 0x1200100, 19398656, 19398912, 0x200010, 0x200110, 2621456, 2621712, 0x1200010, 0x1200110, 19398672, 19398928, 512, 768, 524800, 525056, 0x1000200, 0x1000300, 17302016, 17302272, 528, 784, 524816, 525072, 0x1000210, 0x1000310, 17302032, 17302288, 0x200200, 0x200300, 0x280200, 2622208, 0x1200200, 18875136, 19399168, 19399424, 0x200210, 2097936, 2621968, 2622224, 0x1200210, 18875152, 19399184, 19399440};
    private static final int[] skb_7 = new int[]{0, 0x4000000, 262144, 0x4040000, 2, 0x4000002, 262146, 0x4040002, 8192, 0x4002000, 270336, 0x4042000, 8194, 0x4002002, 270338, 0x4042002, 32, 0x4000020, 262176, 0x4040020, 34, 0x4000022, 262178, 0x4040022, 8224, 0x4002020, 270368, 0x4042020, 8226, 0x4002022, 270370, 0x4042022, 2048, 0x4000800, 264192, 0x4040800, 2050, 67110914, 264194, 67373058, 10240, 67119104, 272384, 67381248, 10242, 67119106, 272386, 67381250, 2080, 67110944, 264224, 67373088, 2082, 67110946, 264226, 67373090, 10272, 67119136, 272416, 67381280, 10274, 67119138, 272418, 67381282};

    public static String crypt(String keyString, String salt) {
        int i;
        int len = keyString.length();
        if (8 < len) {
            len = 8;
        }
        int swap0 = Crypt.toSalt(salt.charAt(0)) << 2;
        int swap1 = Crypt.toSalt(salt.charAt(1)) << 6;
        char[] result = new char[12];
        byte[] key = new byte[8];
        for (i = 0; i < len; ++i) {
            char ch = keyString.charAt(i);
            key[i] = (byte)(ch << 1);
        }
        while (i < 8) {
            key[i] = 0;
            ++i;
        }
        int[] keySchedule = new int[32];
        Crypt.setKeySchedule(key, keySchedule);
        long value = Crypt.encrypt(keySchedule, swap0, swap1);
        return Crypt.resultToString(salt, value);
    }

    private static int toSalt(char ch) {
        if (ch < ':') {
            return ch - 46;
        }
        if (ch < '[') {
            return ch - 58 + 5;
        }
        return ch - 91 + 32;
    }

    private static void setKeySchedule(byte[] key, int[] schedule) {
        int c = key[0] & 0xFF | (key[1] & 0xFF) << 8 | (key[2] & 0xFF) << 16 | (key[3] & 0xFF) << 24;
        int d = key[4] & 0xFF | (key[5] & 0xFF) << 8 | (key[6] & 0xFF) << 16 | (key[7] & 0xFF) << 24;
        int temp = (d >>> 4 ^ c) & 0xF0F0F0F;
        c ^= temp;
        d ^= temp << 4;
        temp = (c << 18 ^ c) & 0xCCCC0000;
        c ^= temp ^ temp >>> 18;
        temp = (d << 18 ^ d) & 0xCCCC0000;
        d ^= temp ^ temp >>> 18;
        temp = (d >>> 1 ^ c) & 0x55555555;
        c ^= temp;
        d ^= temp << 1;
        temp = (c >>> 8 ^ d) & 0xFF00FF;
        d ^= temp;
        c ^= temp << 8;
        temp = (d >>> 1 ^ c) & 0x55555555;
        d ^= temp << 1;
        d = (d & 0xFF) << 16 | d & 0xFF00 | (d & 0xFF0000) >>> 16 | ((c ^= temp) & 0xF0000000) >>> 4;
        c = (int)((long)c & 0xFFFFFFFL);
        int k = 0;
        for (int i = 0; i < 16; ++i) {
            if (KEY_SHIFTS[i]) {
                c = c >> 2 | c << 26;
                d = d >> 2 | d << 26;
            } else {
                c = c >> 1 | c << 27;
                d = d >> 1 | d << 27;
            }
            int s = skb_0[(c &= 0xFFFFFFF) & 0x3F] | skb_1[c >> 6 & 3 | c >> 7 & 0x3C] | skb_2[c >> 13 & 0xF | c >> 14 & 0x30] | skb_3[c >> 20 & 1 | c >> 21 & 6 | c >> 22 & 0x38];
            int t = skb_4[(d &= 0xFFFFFFF) & 0x3F] | skb_5[d >> 7 & 3 | d >> 8 & 0x3C] | skb_6[d >> 15 & 0x3F] | skb_7[d >> 21 & 0xF | d >> 22 & 0x30];
            int t2 = t << 16 | s & 0xFFFF;
            schedule[k++] = Crypt.rotate(t2, 30);
            t2 = s >>> 16 | t & 0xFFFF0000;
            schedule[k++] = Crypt.rotate(t2, 26);
        }
    }

    private static long encrypt(int[] key, int swap0, int swap1) {
        int temp;
        int l = 0;
        int r = 0;
        for (int j = 0; j < 25; ++j) {
            for (int i = 0; i < 32; i += 8) {
                l = Crypt.encrypt(l, r, key[i + 0], key[i + 1], swap0, swap1);
                r = Crypt.encrypt(r, l, key[i + 2], key[i + 3], swap0, swap1);
                l = Crypt.encrypt(l, r, key[i + 4], key[i + 5], swap0, swap1);
                r = Crypt.encrypt(r, l, key[i + 6], key[i + 7], swap0, swap1);
            }
            temp = l;
            l = r;
            r = temp;
        }
        l = Crypt.rotate(l, 3);
        r = Crypt.rotate(r, 3);
        temp = (l >>> 1 ^ r) & 0x55555555;
        r ^= temp;
        l ^= temp << 1;
        temp = (r >>> 8 ^ l) & 0xFF00FF;
        l ^= temp;
        r ^= temp << 8;
        temp = (l >>> 2 ^ r) & 0x33333333;
        r ^= temp;
        l ^= temp << 2;
        temp = (r >>> 16 ^ l) & 0xFFFF;
        l ^= temp;
        r ^= temp << 16;
        temp = (l >>> 4 ^ r) & 0xF0F0F0F;
        return ((long)(l ^= temp << 4) << 32) + ((long)(r ^= temp) & 0xFFFFFFFFL);
    }

    private static int encrypt(int l, int r, int key0, int key1, int swap0, int swap1) {
        int t = r ^ r >>> 16;
        int x = t & swap0;
        int y = t & swap1;
        x ^= r ^ key0 ^ x << 16;
        y ^= r ^ key1 ^ y << 16;
        y = Crypt.rotate(y, 4);
        return l ^= des_0[x >> 2 & 0x3F] ^ des_2[x >> 10 & 0x3F] ^ des_4[x >> 18 & 0x3F] ^ des_6[x >> 26 & 0x3F] ^ des_1[y >> 2 & 0x3F] ^ des_3[y >> 10 & 0x3F] ^ des_5[y >> 18 & 0x3F] ^ des_7[y >> 26 & 0x3F];
    }

    private static int rotate(int v, int n) {
        return (v >>> n) + (v << 32 - n);
    }

    private static String resultToString(String salt, long v) {
        StringBuilder sb = new StringBuilder();
        if (salt.length() > 2) {
            sb.append(salt.substring(0, 2));
        } else {
            sb.append(salt);
        }
        v = (v & 0xFFL) << 56 | (v & 0xFF00L) << 40 | (v & 0xFF0000L) << 24 | (v & 0xFF000000L) << 8 | (v & 0xFF00000000L) >>> 8 | (v & 0xFF0000000000L) >>> 24 | (v & 0xFF000000000000L) >>> 40 | (v & 0xFF00000000000000L) >>> 56;
        sb.append(Crypt.resultToChar(v >> 58));
        sb.append(Crypt.resultToChar(v >> 52));
        sb.append(Crypt.resultToChar(v >> 46));
        sb.append(Crypt.resultToChar(v >> 40));
        sb.append(Crypt.resultToChar(v >> 34));
        sb.append(Crypt.resultToChar(v >> 28));
        sb.append(Crypt.resultToChar(v >> 22));
        sb.append(Crypt.resultToChar(v >> 16));
        sb.append(Crypt.resultToChar(v >> 10));
        sb.append(Crypt.resultToChar(v >> 4));
        sb.append(Crypt.resultToChar(v << 2));
        return sb.toString();
    }

    static char resultToChar(long result) {
        int v = (int)(result & 0x3FL);
        if (v < 12) {
            return (char)(v + 46);
        }
        if (v < 38) {
            return (char)(v + 65 - 12);
        }
        return (char)(v + 97 - 38);
    }
}

