/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.xml;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XMLWriter {
    private static final Logger log = Logger.getLogger(XMLWriter.class.getName());
    private static final L10N L = new L10N(XMLWriter.class);
    private static final XMLWriterStream NULL_STREAM = new XMLWriterStream();
    private XMLWriterStream _s = NULL_STREAM;
    private WriterState _state = WriterState.TOP;
    private HashMap<StringValue, StringValue> _nsMap = new HashMap();
    private ArrayList<StringValue> _elementStack = new ArrayList();
    private ArrayList<ArrayList<StringValue>> _nsStack = new ArrayList();

    public Value flush() {
        return this._s.flush();
    }

    public boolean openMemory(Env env) {
        StringValue s = env.createUnicodeBuilder();
        this._s = new MemoryXMLWriterStream(s);
        this._nsMap.clear();
        this._elementStack.clear();
        this._nsStack.clear();
        this._state = WriterState.TOP;
        return true;
    }

    public boolean openURI(Env env, Path path) {
        try {
            WriteStream out = path.openWrite();
            this._s = new PathXMLWriterStream(out);
            this._nsMap.clear();
            this._elementStack.clear();
            this._nsStack.clear();
            this._state = WriterState.TOP;
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        return true;
    }

    public Value outputMemory() {
        return this.flush();
    }

    public boolean endAttribute() {
        if (this._state != WriterState.ATTRIBUTE) {
            return false;
        }
        this._s.append("\"");
        this._state = WriterState.ELEMENT_HEADER;
        return true;
    }

    public boolean endCData() {
        if (this._state != WriterState.CDATA) {
            return false;
        }
        this._state = WriterState.ELEMENT_BODY;
        this._s.append("]]>");
        return true;
    }

    public boolean endComment() {
        if (this._state != WriterState.COMMENT) {
            return false;
        }
        this._state = WriterState.ELEMENT_BODY;
        this._s.append("-->");
        return true;
    }

    public boolean endPI() {
        if (this._state != WriterState.PI) {
            return false;
        }
        this._state = WriterState.ELEMENT_BODY;
        this._s.append("?>");
        return true;
    }

    public boolean endDocument() {
        return true;
    }

    public boolean endDTDAttlist() {
        return true;
    }

    public boolean endDTDElement() {
        return true;
    }

    public boolean endDTDEntity() {
        return true;
    }

    public boolean endDTD() {
        return true;
    }

    public boolean endElement(Env env) {
        if (this._state == WriterState.ATTRIBUTE) {
            this.endAttribute();
        }
        if (this._elementStack.size() == 0) {
            return false;
        }
        if (this._state == WriterState.ELEMENT_HEADER) {
            this.popElement();
            this._s.append("/>");
            return true;
        }
        if (this._state == WriterState.ELEMENT_BODY) {
            StringValue name = this.popElement();
            this._s.append("</").append(env, name).append(">");
            return true;
        }
        return false;
    }

    public boolean endElementNS(Env env) {
        return this.endElement(env);
    }

    public boolean fullEndElement(Env env) {
        if (this._state == WriterState.ATTRIBUTE) {
            this.endAttribute();
        }
        if (this._elementStack.size() == 0) {
            return false;
        }
        if (this._state == WriterState.ELEMENT_HEADER) {
            this._s.append(">");
        } else if (this._state != WriterState.ELEMENT_BODY) {
            return false;
        }
        StringValue name = this.popElement();
        this._s.append("</").append(env, name).append(">");
        return true;
    }

    public boolean setIndent(boolean isIndent) {
        return false;
    }

    public boolean setIndentString(StringValue value) {
        return false;
    }

    public boolean startAttribute(Env env, StringValue name) {
        if (this._state != WriterState.ELEMENT_HEADER) {
            return false;
        }
        this._s.append(" ").append(env, name).append("=\"");
        this._state = WriterState.ATTRIBUTE;
        return true;
    }

    public boolean startAttributeNS(Env env, StringValue prefix, StringValue name, StringValue uri) {
        if (this._state != WriterState.ELEMENT_HEADER) {
            return false;
        }
        this.pushNamespace(env, prefix, uri);
        this._s.append(" ").append(env, prefix).append(":").append(env, name);
        this._s.append("=\"");
        this._state = WriterState.ATTRIBUTE;
        return true;
    }

    public boolean startCData() {
        this.startContent();
        this._state = WriterState.CDATA;
        this._s.append("<![CDATA[");
        return true;
    }

    public boolean startComment() {
        this.startContent();
        this._state = WriterState.COMMENT;
        this._s.append("<!--");
        return true;
    }

    public boolean startDocument(Env env, @Optional StringValue version, @Optional StringValue encoding, @Optional StringValue standalone) {
        this._s.append("<?xml");
        if (version == null || version.length() == 0) {
            this._s.append(" version=\"1.0\"");
        } else {
            this._s.append(" version=\"").append(env, version).append("\"");
        }
        if (encoding != null && encoding.length() != 0) {
            this._s.append(" encoding=\"").append(env, encoding).append("\"");
        }
        if (standalone != null && standalone.length() != 0) {
            this._s.append(" standalone=\"").append(env, standalone).append("\"");
        }
        this._s.append("?>\n");
        return true;
    }

    public boolean startDTDAttlist(StringValue name) {
        return true;
    }

    public boolean startDTDElement(StringValue name) {
        return true;
    }

    public boolean startDTDEntity(StringValue name) {
        return true;
    }

    public boolean startDTD(StringValue name, @Optional StringValue publicId, @Optional StringValue systemId) {
        return true;
    }

    public boolean startElement(Env env, StringValue name) {
        if (this._state == WriterState.ELEMENT_HEADER) {
            this._s.append(">");
        }
        this._s.append("<").append(env, name);
        this._elementStack.add(name);
        this._nsStack.add(null);
        this._state = WriterState.ELEMENT_HEADER;
        return true;
    }

    public boolean startElementNS(Env env, StringValue prefix, StringValue name, StringValue uri) {
        this.startContent();
        this._s.append("<").append(env, prefix).append(":").append(env, name);
        StringValue endName = prefix.createStringBuilder();
        endName.append(prefix).append(":").append(name);
        this._elementStack.add(endName);
        this._nsStack.add(null);
        this.pushNamespace(env, prefix, uri);
        this._state = WriterState.ELEMENT_HEADER;
        return true;
    }

    public boolean startPI(Env env, StringValue target) {
        this.startContent();
        this._state = WriterState.PI;
        this._s.append("<?").append(env, target).append(" ");
        return true;
    }

    public boolean text(Env env, StringValue text) {
        if (this._state == WriterState.ELEMENT_HEADER) {
            this.startContent();
        }
        if (this._state == WriterState.ELEMENT_BODY || this._state == WriterState.TOP) {
            int len = text.length();
            block6: for (int i = 0; i < len; ++i) {
                char ch = text.charAt(i);
                switch (ch) {
                    case '<': {
                        this._s.append("&lt;");
                        continue block6;
                    }
                    case '>': {
                        this._s.append("&gt;");
                        continue block6;
                    }
                    case '&': {
                        this._s.append("&amp;");
                        continue block6;
                    }
                    case '\"': {
                        this._s.append("&quot;");
                        continue block6;
                    }
                    default: {
                        this._s.append(ch);
                    }
                }
            }
        } else {
            this._s.append(env, text);
        }
        return true;
    }

    public boolean writeAttribute(Env env, StringValue name, StringValue value) {
        this.startAttribute(env, name);
        this.text(env, value);
        this.endAttribute();
        return true;
    }

    public boolean writeAttributeNS(Env env, StringValue prefix, StringValue name, StringValue uri, StringValue value) {
        this.startAttributeNS(env, prefix, name, uri);
        this.text(env, value);
        this.endAttribute();
        return true;
    }

    public boolean writeCData(Env env, StringValue value) {
        this.startCData();
        this.text(env, value);
        this.endCData();
        return true;
    }

    public boolean writeComment(Env env, StringValue value) {
        this.startComment();
        this.text(env, value);
        this.endComment();
        return true;
    }

    public boolean writeDTDAttlist(Env env, StringValue name, StringValue content) {
        this.startDTDAttlist(name);
        this.text(env, content);
        this.endDTDAttlist();
        return true;
    }

    public boolean writeDTDElement(Env env, StringValue name, StringValue content) {
        this.startDTDElement(name);
        this.text(env, content);
        this.endDTDElement();
        return true;
    }

    public boolean writeDTDEntity(Env env, StringValue name, StringValue content) {
        this.startDTDEntity(name);
        this.text(env, content);
        this.endDTDEntity();
        return true;
    }

    public boolean writeDTD(Env env, StringValue name, @Optional StringValue publicId, @Optional StringValue systemId, @Optional StringValue subset) {
        this.startDTD(name, publicId, systemId);
        this.text(env, subset);
        this.endDTDEntity();
        return true;
    }

    public boolean writeElement(Env env, StringValue name, @Optional StringValue content) {
        this.startElement(env, name);
        if (content != null && content.length() > 0) {
            this.text(env, content);
        }
        this.endElement(env);
        return true;
    }

    public boolean writeElementNS(Env env, StringValue prefix, StringValue name, StringValue uri, @Optional StringValue content) {
        this.startElementNS(env, prefix, name, uri);
        if (content != null && content.length() > 0) {
            this.text(env, content);
        }
        this.endElement(env);
        return true;
    }

    public boolean writePI(Env env, StringValue name, StringValue value) {
        this.startPI(env, name);
        this.text(env, value);
        this.endPI();
        return true;
    }

    public boolean writeRaw(Env env, StringValue value) {
        this._s.append(env, value);
        return true;
    }

    private void startContent() {
        if (this._state == WriterState.ATTRIBUTE) {
            this._s.append("\">");
            this._state = WriterState.ELEMENT_BODY;
        } else if (this._state == WriterState.ELEMENT_HEADER) {
            this._s.append(">");
            this._state = WriterState.ELEMENT_BODY;
        }
    }

    private void pushNamespace(Env env, StringValue prefix, StringValue uri) {
        if (!uri.equals(this._nsMap.get(prefix))) {
            this._s.append(" ");
            if (prefix.length() == 0) {
                this._s.append("xmlns");
            } else {
                this._s.append("xmlns:").append(env, prefix);
            }
            this._s.append("=\"").append(env, uri).append("\"");
            ArrayList<StringValue> stack = this._nsStack.get(this._nsStack.size() - 1);
            if (stack == null) {
                stack = new ArrayList();
                this._nsStack.set(this._nsStack.size() - 1, stack);
            }
            stack.add(prefix);
            this._nsMap.put(prefix, uri);
        }
    }

    private StringValue popElement() {
        this._state = this._elementStack.size() > 1 ? WriterState.ELEMENT_BODY : WriterState.TOP;
        if (this._elementStack.size() > 0) {
            StringValue name = this._elementStack.remove(this._elementStack.size() - 1);
            ArrayList<StringValue> prefixList = this._nsStack.remove(this._nsStack.size() - 1);
            if (prefixList != null) {
                for (StringValue prefix : prefixList) {
                    this._nsMap.remove(prefix);
                }
            }
            return name;
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }

    static class PathXMLWriterStream
    extends XMLWriterStream {
        private WriteStream _out;

        PathXMLWriterStream(WriteStream out) {
            this._out = out;
        }

        XMLWriterStream append(char v) {
            try {
                this._out.print(v);
            }
            catch (IOException e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            return this;
        }

        XMLWriterStream append(Env env, StringValue v) {
            v.print(env, this._out);
            return this;
        }

        XMLWriterStream append(String text) {
            try {
                this._out.print(text);
            }
            catch (IOException e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            return this;
        }

        Value flush() {
            try {
                this._out.close();
            }
            catch (IOException e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            return LongValue.create(1L);
        }
    }

    static class MemoryXMLWriterStream
    extends XMLWriterStream {
        private StringValue _v;

        MemoryXMLWriterStream(StringValue v) {
            this._v = v;
        }

        XMLWriterStream append(char v) {
            this._v.append(v);
            return this;
        }

        XMLWriterStream append(Env env, StringValue v) {
            this._v.append(v);
            return this;
        }

        XMLWriterStream append(String text) {
            this._v.append(text);
            return this;
        }

        Value flush() {
            return this._v;
        }
    }

    static class XMLWriterStream {
        XMLWriterStream() {
        }

        XMLWriterStream append(char v) {
            return this;
        }

        XMLWriterStream append(Env env, StringValue v) {
            return this;
        }

        XMLWriterStream append(String v) {
            return this;
        }

        Value flush() {
            return NullValue.NULL;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum WriterState {
        TOP,
        ELEMENT_HEADER,
        ATTRIBUTE,
        COMMENT,
        CDATA,
        ELEMENT_BODY,
        PI;

    }
}

