/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.marshal;

import com.caucho.quercus.env.BigIntegerValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.marshal.Marshal;
import java.math.BigInteger;

public class BigIntegerMarshal
extends Marshal {
    public static final Marshal MARSHAL = new BigIntegerMarshal();

    public Object marshal(Env env, Expr expr, Class argClass) {
        return expr.eval(env).toBigInteger();
    }

    public Object marshal(Env env, Value value, Class argClass) {
        return value.toBigInteger();
    }

    public Value unmarshal(Env env, Object value) {
        return env.wrapJava((BigInteger)value);
    }

    protected int getMarshalingCostImpl(Value argValue) {
        if (argValue instanceof BigIntegerValue) {
            return 0;
        }
        if (argValue instanceof LongValue) {
            return 100;
        }
        if (argValue.isLongConvertible()) {
            return 100;
        }
        return 400;
    }

    public Class getExpectedClass() {
        return BigInteger.class;
    }
}

