/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.marshal;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.marshal.Marshal;

public class EnumMarshal
extends Marshal {
    private Class _enumClass;

    public EnumMarshal(Class enumClass) {
        this._enumClass = enumClass;
    }

    public Object marshal(Env env, Expr expr, Class argClass) {
        String name = expr.evalString(env);
        if (name == null) {
            return null;
        }
        try {
            return Enum.valueOf(this._enumClass, name);
        }
        catch (IllegalArgumentException e) {
            env.warning(e);
            return null;
        }
    }

    public Object marshal(Env env, Value value, Class argClass) {
        return value.toJavaEnum(env, argClass);
    }

    public Value unmarshal(Env env, Object value) {
        if (value == null) {
            return NullValue.NULL;
        }
        return env.wrapJava(value);
    }

    public Class getExpectedClass() {
        return this._enumClass;
    }

    public int getMarshalingCostImpl(Value value) {
        return 400;
    }
}

