/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.marshal;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.util.L10N;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Marshal {
    protected static final L10N L = new L10N(Marshal.class);
    public static final int ZERO = 0;
    public static final int COST_IDENTICAL = 0;
    public static final int COST_VALUE = 10;
    public static final int ONE = 100;
    public static final int COST_EQUAL = 100;
    public static final int TWO = 200;
    public static final int COST_NUMERIC_LOSSLESS = 200;
    public static final int THREE = 300;
    public static final int COST_NUMERIC_LOSSY = 300;
    public static final int COST_FROM_NULL = 310;
    public static final int COST_STRING_TO_CHAR_ARRAY = 305;
    public static final int COST_TO_JAVA_OBJECT = 320;
    public static final int COST_STRING_TO_CHAR = 320;
    public static final int COST_BINARY_TO_BYTE = 320;
    public static final int COST_STRING_TO_BYTE = 340;
    public static final int COST_BINARY_TO_STRING = 330;
    public static final int COST_STRING_TO_BINARY = 330;
    public static final int COST_TO_STRING = 350;
    public static final int COST_TO_CHAR_ARRAY = 355;
    public static final int COST_TO_CHAR = 360;
    public static final int COST_TO_BOOLEAN = 380;
    public static final int COST_TO_BYTE_ARRAY = 390;
    public static final int FOUR = 400;
    public static final int COST_INCOMPATIBLE = 400;
    public static final int MAX = 0x3FFFFFF;
    public static final int PHP5_STRING_VALUE_COST = 0;
    public static final int PHP5_BYTE_ARRAY_COST = 101;
    public static final int PHP5_CHARACTER_ARRAY_COST = 102;
    public static final int PHP5_STRING_COST = 103;
    public static final int PHP5_BYTE_OBJECT_ARRAY_COST = 104;
    public static final int PHP5_CHARACTER_OBJECT_ARRAY_COST = 105;
    public static final int PHP5_BINARY_VALUE_COST = 106;
    public static final int UNICODE_STRING_VALUE_COST = 100;
    public static final int UNICODE_BINARY_VALUE_COST = 101;
    public static final int UNICODE_CHARACTER_ARRAY_COST = 102;
    public static final int UNICODE_STRING_COST = 103;
    public static final int UNICODE_BYTE_ARRAY_COST = 104;
    public static final int UNICODE_CHARACTER_OBJECT_ARRAY_COST = 105;
    public static final int UNICODE_BYTE_OBJECT_ARRAY_COST = 106;
    public static final int BINARY_BINARY_VALUE_COST = 0;
    public static final int BINARY_STRING_VALUE_COST = 101;
    public static final int BINARY_BYTE_ARRAY_COST = 102;
    public static final int BINARY_STRING_COST = 103;
    public static final int BINARY_CHARACTER_ARRAY_COST = 104;
    public static final int BINARY_BYTE_OBJECT_ARRAY_COST = 105;
    public static final int BINARY_CHARACTER_OBJECT_ARRAY_COST = 106;
    public static final int DOUBLE_CONVERTIBLE_DOUBLE_VALUE_COST = 300;
    public static final int DOUBLE_CONVERTIBLE_DOUBLE_COST = 301;
    public static final int DOUBLE_CONVERTIBLE_DOUBLE_OBJECT_COST = 302;
    public static final int DOUBLE_CONVERTIBLE_FLOAT_COST = 303;
    public static final int DOUBLE_CONVERTIBLE_FLOAT_OBJECT_COST = 304;
    public static final int DOUBLE_CONVERTIBLE_LONG_VALUE_COST = 305;
    public static final int DOUBLE_CONVERTIBLE_LONG_COST = 306;
    public static final int DOUBLE_CONVERTIBLE_LONG_OBJECT_COST = 307;
    public static final int DOUBLE_CONVERTIBLE_INTEGER_COST = 308;
    public static final int DOUBLE_CONVERTIBLE_INTEGER_OBJECT_COST = 309;
    public static final int DOUBLE_CONVERTIBLE_BYTE_COST = 310;
    public static final int DOUBLE_CONVERTIBLE_BYTE_OBJECT_COST = 311;
    public static final int LONG_CONVERTIBLE_DOUBLE_VALUE_COST = 300;
    public static final int LONG_CONVERTIBLE_LONG_VALUE_COST = 301;
    public static final int LONG_CONVERTIBLE_DOUBLE_COST = 302;
    public static final int LONG_CONVERTIBLE_DOUBLE_OBJECT_COST = 303;
    public static final int LONG_CONVERTIBLE_FLOAT_COST = 304;
    public static final int LONG_CONVERTIBLE_FLOAT_OBJECT_COST = 305;
    public static final int LONG_CONVERTIBLE_LONG_COST = 306;
    public static final int LONG_CONVERTIBLE_LONG_OBJECT_COST = 307;
    public static final int LONG_CONVERTIBLE_INTEGER_COST = 308;
    public static final int LONG_CONVERTIBLE_INTEGER_OBJECT_COST = 309;
    public static final int LONG_CONVERTIBLE_BYTE_COST = 310;
    public static final int LONG_CONVERTIBLE_BYTE_OBJECT_COST = 311;

    public boolean isBoolean() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isLong() {
        return false;
    }

    public boolean isDouble() {
        return false;
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean isReference() {
        return false;
    }

    public boolean isValue() {
        return false;
    }

    public abstract Object marshal(Env var1, Expr var2, Class var3);

    public Object marshal(Env env, Value value, Class argClass) {
        return this.marshalImpl(env, value.toValue(), argClass);
    }

    protected Object marshalImpl(Env env, Value value, Class<?> argClass) {
        return value;
    }

    public Value unmarshal(Env env, Object value) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public final int getMarshalingCost(Value value) {
        Class expectedClass = this.getExpectedClass();
        if (expectedClass.equals(value.getClass())) {
            return 0;
        }
        return this.getMarshalingCostImpl(value);
    }

    protected int getMarshalingCostImpl(Value value) {
        throw new UnsupportedOperationException(this.getClass().toString());
    }

    public int getMarshalingCost(Expr expr) {
        return 0x3FFFFFF;
    }

    public Class getExpectedClass() {
        throw new UnsupportedOperationException(this.getClass().toString());
    }

    protected void unexpectedType(Env env, Value value, Class<?> actual, Class<?> expected) {
        env.warning(L.l("'{0}' of type '{1}' is an unexpected argument, expected {2}", (Object)value, (Object)actual.getSimpleName(), (Object)expected.getSimpleName()));
    }

    protected void unexpectedNull(Env env, Class<?> expected) {
        env.warning(L.l("null is an unexpected argument, expected {0}", (Object)expected.getSimpleName()));
    }
}

