/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.marshal;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.JavaValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.marshal.Marshal;
import com.caucho.quercus.program.JavaClassDef;
import com.caucho.vfs.Path;

public class PathMarshal
extends Marshal {
    public static final Marshal MARSHAL = new PathMarshal();

    public boolean isReadOnly() {
        return true;
    }

    public Object marshal(Env env, Expr expr, Class expectedClass) {
        return env.lookupPwd(expr.eval(env));
    }

    public Object marshal(Env env, Value value, Class expectedClass) {
        return env.lookupPwd(value);
    }

    public Value unmarshal(Env env, Object value) {
        String className = value.getClass().getName();
        JavaClassDef def = env.getQuercus().getJavaClassDefinition(className);
        return def.wrap(env, value);
    }

    protected int getMarshalingCostImpl(Value argValue) {
        if (argValue instanceof JavaValue && Path.class.isAssignableFrom(argValue.toJavaObject().getClass())) {
            return 0;
        }
        if (argValue.isString()) {
            return 300;
        }
        return 400;
    }

    public Class getExpectedClass() {
        return Path.class;
    }
}

