/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.parser;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.expr.ExprFactory;
import com.caucho.quercus.parser.Scope;
import com.caucho.quercus.program.Function;
import com.caucho.quercus.program.InterpretedClassDef;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionScope
extends Scope {
    private ExprFactory _exprFactory;
    private HashMap<StringValue, Function> _functionMap = new HashMap();
    private HashMap<String, InterpretedClassDef> _classMap = new HashMap();
    private HashMap<String, InterpretedClassDef> _conditionalClassMap;
    private HashMap<StringValue, Function> _conditionalFunctionMap;

    FunctionScope(ExprFactory exprFactory, Scope parent) {
        super(parent);
        this._exprFactory = exprFactory;
    }

    @Override
    public boolean isFunction() {
        return true;
    }

    @Override
    public void addFunction(StringValue name, Function function, boolean isTop) {
        if (this._functionMap.get(name = name.toLowerCase(Locale.ENGLISH)) == null) {
            this._functionMap.put(name, function);
        }
        this._parent.addFunction(name, function, false);
    }

    @Override
    protected void addConditionalFunction(StringValue name, Function function) {
        if (this._conditionalFunctionMap == null) {
            this._conditionalFunctionMap = new HashMap(4);
        }
        StringValue compilationName = function.getInfo().getQuercus().createString(function.getCompilationName());
        this._conditionalFunctionMap.put(compilationName, function);
        this._parent.addConditionalFunction(name, function);
    }

    @Override
    public InterpretedClassDef addClass(Location location, String name, String parentName, ArrayList<String> ifaceList, int index, boolean isTop) {
        InterpretedClassDef existingClass = this._classMap.get(name);
        String[] ifaces = new String[ifaceList.size()];
        ifaceList.toArray(ifaces);
        InterpretedClassDef cl = this._exprFactory.createClassDef(location, name, parentName, ifaces, index);
        if (existingClass == null) {
            this._classMap.put(name, cl);
        }
        this._parent.addConditionalClass(cl);
        return cl;
    }

    @Override
    protected void addConditionalClass(InterpretedClassDef def) {
        if (this._conditionalClassMap == null) {
            this._conditionalClassMap = new HashMap(1);
        }
        this._conditionalClassMap.put(def.getCompilationName(), def);
        this._parent.addConditionalClass(def);
    }
}

