/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.resources;

import com.caucho.quercus.QuercusException;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.EnvCleanup;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.resources.StreamResource;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;

public class StreamReadWrite
extends StreamResource
implements EnvCleanup {
    private Env _env;
    private ReadStream _is;
    private WriteStream _os;

    public StreamReadWrite(Env env) {
        this._env = env;
        this._env.addCleanup(this);
    }

    public StreamReadWrite(Env env, ReadStream is, WriteStream os) {
        this(env);
        this.init(is, os);
    }

    protected void init(ReadStream is, WriteStream os) {
        this._is = is;
        this._os = os;
    }

    public int read() throws IOException {
        if (this._is != null) {
            return this._is.read();
        }
        return -1;
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (this._is != null) {
            return this._is.read(buffer, offset, length);
        }
        return -1;
    }

    public boolean readOptionalLinefeed() throws IOException {
        if (this._is != null) {
            int ch = this._is.read();
            if (ch == 10) {
                return true;
            }
            this._is.unread();
            return false;
        }
        return false;
    }

    public StringValue readLine(Env env) throws IOException {
        if (this._is != null) {
            return env.createString(this._is.readLineNoChop());
        }
        return env.getEmptyString();
    }

    public int readLine(char[] buffer) {
        try {
            if (this._is != null) {
                return this._is.readLine(buffer, buffer.length, false);
            }
            return -1;
        }
        catch (IOException e) {
            return -1;
        }
    }

    public int write(byte[] buffer, int offset, int length) throws IOException {
        if (this._os != null) {
            this._os.write(buffer, offset, length);
            return length;
        }
        return -1;
    }

    public void print(char ch) throws IOException {
        this.print(String.valueOf(ch));
    }

    public void print(String s) throws IOException {
        if (this._os != null) {
            this._os.print(s);
        }
    }

    public boolean isEOF() {
        return true;
    }

    public void flush() {
        try {
            if (this._os != null) {
                this._os.flush();
            }
        }
        catch (IOException e) {
            throw new QuercusException(e);
        }
    }

    public long getPosition() {
        return 0L;
    }

    public void closeRead() {
        ReadStream is = this._is;
        this._is = null;
        if (is != null) {
            is.close();
        }
    }

    public void closeWrite() {
        WriteStream os = this._os;
        this._os = null;
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void close() {
        this._env.removeCleanup(this);
        this.cleanup();
    }

    public void cleanup() {
        ReadStream is = this._is;
        this._is = null;
        WriteStream os = this._os;
        this._os = null;
        if (is != null) {
            is.close();
        }
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

