/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.script;

import com.caucho.quercus.QuercusContext;
import com.caucho.quercus.QuercusExitException;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.page.InterpretedPage;
import com.caucho.quercus.program.QuercusProgram;
import com.caucho.quercus.script.QuercusScriptEngine;
import com.caucho.vfs.NullWriteStream;
import com.caucho.vfs.WriteStream;
import com.caucho.vfs.WriterStreamImpl;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

public class QuercusCompiledScript
extends CompiledScript {
    private static final Logger log = Logger.getLogger(QuercusCompiledScript.class.getName());
    private final QuercusScriptEngine _engine;
    private final QuercusProgram _program;

    QuercusCompiledScript(QuercusScriptEngine engine, QuercusProgram program) {
        this._engine = engine;
        this._program = program;
    }

    public Object eval(ScriptContext cxt) throws ScriptException {
        QuercusContext quercus = this._engine.getQuercus();
        Env env = null;
        try {
            WriteStream out;
            Writer writer = cxt.getWriter();
            if (writer != null) {
                WriterStreamImpl s = new WriterStreamImpl();
                s.setWriter(writer);
                WriteStream os = new WriteStream(s);
                os.setNewlineString("\n");
                String outputEncoding = quercus.getOutputEncoding();
                if (outputEncoding == null) {
                    outputEncoding = "utf-8";
                }
                try {
                    os.setEncoding(outputEncoding);
                }
                catch (Exception e) {
                    log.log(Level.FINE, e.getMessage(), e);
                }
                out = os;
            } else {
                out = new NullWriteStream();
            }
            InterpretedPage page = new InterpretedPage(this._program);
            env = new Env(quercus, page, out, null, null);
            env.setScriptContext(cxt);
            env.start();
            Value result = null;
            try {
                Value value = this._program.execute(env);
                if (value != null) {
                    result = value;
                }
            }
            catch (QuercusExitException quercusExitException) {
                // empty catch block
            }
            out.flushBuffer();
            out.free();
            Value value = result;
            return value;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            if (env != null) {
                env.close();
            }
        }
    }

    public ScriptEngine getEngine() {
        return this._engine;
    }

    public String toString() {
        return "QuercusCompiledScript[]";
    }
}

