/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.script;

import com.caucho.quercus.QuercusContext;
import com.caucho.quercus.QuercusExitException;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.page.InterpretedPage;
import com.caucho.quercus.parser.QuercusParser;
import com.caucho.quercus.program.QuercusProgram;
import com.caucho.quercus.script.EncoderStream;
import com.caucho.quercus.script.QuercusCompiledScript;
import com.caucho.quercus.script.QuercusScriptEngineFactory;
import com.caucho.util.L10N;
import com.caucho.vfs.NullWriteStream;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.VfsStream;
import com.caucho.vfs.WriteStream;
import com.caucho.vfs.WriterStreamImpl;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

public class QuercusScriptEngine
extends AbstractScriptEngine
implements Compilable {
    private static final L10N L = new L10N(QuercusScriptEngine.class);
    private static final Logger log = Logger.getLogger(QuercusScriptEngine.class.getName());
    private final QuercusScriptEngineFactory _factory;
    private QuercusContext _quercus;
    private String _scriptEncoding = "utf-8";
    private boolean _isUnicodeSemantics;

    public QuercusScriptEngine() {
        this(new QuercusScriptEngineFactory());
    }

    public QuercusScriptEngine(boolean isUnicodeSemantics) {
        this(new QuercusScriptEngineFactory(), isUnicodeSemantics);
    }

    public QuercusScriptEngine(QuercusContext quercus) {
        this(new QuercusScriptEngineFactory(), quercus);
    }

    public QuercusScriptEngine(QuercusScriptEngineFactory factory) {
        this(factory, true);
    }

    public QuercusScriptEngine(QuercusScriptEngineFactory factory, boolean isUnicodeSemantics) {
        this._factory = factory;
        this._isUnicodeSemantics = isUnicodeSemantics;
    }

    public QuercusScriptEngine(QuercusScriptEngineFactory factory, QuercusContext quercus) {
        this._factory = factory;
        this._quercus = quercus;
        this._scriptEncoding = this._quercus.getScriptEncoding();
        this._isUnicodeSemantics = quercus.isUnicodeSemantics();
    }

    public boolean isUnicodeSemantics() {
        return this._isUnicodeSemantics;
    }

    public void setUnicodeSemantics(boolean isUnicodeSemantics) {
        this._isUnicodeSemantics = isUnicodeSemantics;
    }

    public String getScriptEncoding() {
        return this._scriptEncoding;
    }

    public void setScriptEncoding(String encoding) {
        this._scriptEncoding = encoding;
        if (this._quercus != null) {
            this._quercus.setScriptEncoding(encoding);
        }
    }

    private static QuercusContext createQuercus(String scriptEncoding, boolean isUnicodeSemantics) {
        QuercusContext quercus = new QuercusContext();
        quercus.setScriptEncoding(scriptEncoding);
        quercus.setUnicodeSemantics(isUnicodeSemantics);
        quercus.init();
        quercus.start();
        return quercus;
    }

    public QuercusContext getQuercus() {
        if (this._quercus == null) {
            this._quercus = QuercusScriptEngine.createQuercus(this._scriptEncoding, this._isUnicodeSemantics);
        }
        return this._quercus;
    }

    public Object eval(Reader script, ScriptContext cxt) throws ScriptException {
        QuercusContext quercus = this.getQuercus();
        Env env = null;
        try {
            WriteStream out;
            QuercusProgram program;
            if (this.isUnicodeSemantics()) {
                program = QuercusParser.parse(quercus, null, script);
            } else {
                ReadStream is = EncoderStream.open(script, quercus.getScriptEncoding());
                ReadStream rs = new ReadStream(new VfsStream(is, null));
                program = QuercusParser.parse(quercus, null, rs);
            }
            Writer writer = cxt.getWriter();
            if (writer != null) {
                WriterStreamImpl s = new WriterStreamImpl();
                s.setWriter(writer);
                WriteStream os = new WriteStream(s);
                os.setNewlineString("\n");
                String outputEncoding = quercus.getOutputEncoding();
                if (outputEncoding == null) {
                    outputEncoding = "utf-8";
                }
                try {
                    os.setEncoding(outputEncoding);
                }
                catch (Exception e) {
                    log.log(Level.FINE, e.getMessage(), e);
                }
                out = os;
            } else {
                out = new NullWriteStream();
            }
            InterpretedPage page = new InterpretedPage(program);
            env = new Env(quercus, page, out, null, null);
            env.setScriptContext(cxt);
            env.start();
            Value result = null;
            try {
                Value value = program.execute(env);
                if (value != null) {
                    result = value;
                }
            }
            catch (QuercusExitException quercusExitException) {
                // empty catch block
            }
            out.flushBuffer();
            out.free();
            writer.flush();
            Value value = result;
            return value;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            if (env != null) {
                env.close();
            }
        }
    }

    public Object eval(String script, ScriptContext cxt) throws ScriptException {
        return this.eval((Reader)new StringReader(script), cxt);
    }

    public CompiledScript compile(Reader reader) throws ScriptException {
        try {
            QuercusProgram program = QuercusParser.parse(this.getQuercus(), null, reader);
            return new QuercusCompiledScript(this, program);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public CompiledScript compile(String script) throws ScriptException {
        return this.compile(new StringReader(script));
    }

    public QuercusScriptEngineFactory getFactory() {
        return this._factory;
    }

    public Bindings createBindings() {
        return new SimpleBindings();
    }

    public void close() {
        if (this._quercus != null) {
            this._quercus.close();
            this._quercus = null;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[isUnicodeSemantics=" + this._isUnicodeSemantics + "]";
    }
}

