/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.env.thread.ThreadPool;
import com.caucho.util.Alarm;
import com.caucho.util.CurrentTime;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;

public class AlarmClock {
    private static final Logger log = Logger.getLogger(AlarmClock.class.getName());
    private static final int CLOCK_PERIOD = 60000;
    private static final int CLOCK_NEXT = 5000;
    private static final int CLOCK_INTERVAL = 1;
    private Alarm[] _clockArray = new Alarm[60000];
    private AtomicLong _now = new AtomicLong();
    private AtomicLong _nextAlarmTime = new AtomicLong();
    private final ArrayList<Alarm> _currentAlarms = new ArrayList();
    private long _lastTime;
    private Object _lock = new Object();
    private ThreadPool _threadPool = ThreadPool.getThreadPool();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queueAt(Alarm alarm, long wakeTime) {
        long oldWakeTime;
        long prevNextAlarmTime;
        boolean isEarliest = false;
        do {
            prevNextAlarmTime = this._nextAlarmTime.get();
        } while (wakeTime > 0L && wakeTime < prevNextAlarmTime && !this._nextAlarmTime.compareAndSet(prevNextAlarmTime, wakeTime));
        if (wakeTime < prevNextAlarmTime) {
            isEarliest = true;
        }
        if ((oldWakeTime = alarm.getAndSetWakeTime(wakeTime)) == wakeTime) {
            return false;
        }
        if (oldWakeTime <= 0L || !this.dequeueImpl(alarm)) {
            // empty if block
        }
        if (wakeTime <= 0L) {
            return false;
        }
        long now = this._now.get();
        if (wakeTime <= now) {
            this.queueCurrent(alarm);
            return true;
        }
        Object object = this._lock;
        synchronized (object) {
            if (alarm.getBucket() >= 0) {
                return false;
            }
            int bucket = this.getBucket(wakeTime);
            alarm.setBucket(bucket);
            Alarm top = this._clockArray[bucket];
            alarm.setNext(top);
            this._clockArray[bucket] = alarm;
        }
        now = this._now.get();
        long nextWakeTime = alarm.getWakeTime();
        if (nextWakeTime != wakeTime || wakeTime < now) {
            this.dequeueImpl(alarm);
            this.queueCurrent(alarm);
        }
        return isEarliest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueCurrent(Alarm alarm) {
        ArrayList<Alarm> arrayList = this._currentAlarms;
        synchronized (arrayList) {
            this._currentAlarms.add(alarm);
        }
    }

    void dequeue(Alarm alarm) {
        alarm.setWakeTime(0L);
        if (alarm.getBucket() >= 0) {
            this.dequeueImpl(alarm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dequeueImpl(Alarm alarm) {
        Object object = this._lock;
        synchronized (object) {
            int bucket = alarm.getBucket();
            Alarm next = alarm.getNext();
            alarm.setBucket(-1);
            alarm.setNext(null);
            if (bucket < 0) {
                return false;
            }
            Alarm head = this._clockArray[bucket];
            if (head == null) {
                return false;
            }
            if (head == alarm) {
                this._clockArray[bucket] = next;
                return true;
            }
            Alarm prev = head;
            for (Alarm ptr = prev.getNext(); ptr != null; ptr = ptr.getNext()) {
                if (ptr == alarm) {
                    prev.setNext(next);
                    return true;
                }
                prev = ptr;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Alarm extractNextAlarm(int bucket, long time, boolean isTest) {
        if (this._clockArray[bucket] == null) {
            return null;
        }
        Object object = this._lock;
        synchronized (object) {
            Alarm ptr = this._clockArray[bucket];
            Alarm prev = null;
            while (ptr != null) {
                Alarm next = ptr.getNext();
                long wakeTime = ptr.getWakeTime();
                if (wakeTime <= time) {
                    ptr.setNext(null);
                    ptr.setBucket(-1);
                    if (prev != null) {
                        prev.setNext(next);
                    } else {
                        this._clockArray[bucket] = next;
                    }
                    return ptr;
                }
                prev = ptr;
                ptr = next;
            }
        }
        return null;
    }

    public long extractAlarm(long now, boolean isTest) {
        Alarm alarm;
        long lastTime = this._now.getAndSet(now);
        long nextTime = this._nextAlarmTime.get();
        if (now < nextTime) {
            return nextTime;
        }
        this._nextAlarmTime.set(now + 5000L);
        int delta = (int)(now - lastTime) / 1;
        if (60000 <= delta) {
            delta = 60000;
        }
        int bucket = this.getBucket(lastTime);
        for (int i = 0; i <= delta; ++i) {
            while ((alarm = this.extractNextAlarm(bucket, now, isTest)) != null) {
                this.dispatch(alarm, now, isTest);
            }
            bucket = (bucket + 1) % 60000;
        }
        while ((alarm = this.extractNextCurrentAlarm()) != null) {
            this.dispatch(alarm, now, isTest);
        }
        long next = this.updateNextAlarmTime(now);
        this._lastTime = now;
        return next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Alarm extractNextCurrentAlarm() {
        if (this._currentAlarms.size() == 0) {
            return null;
        }
        ArrayList<Alarm> arrayList = this._currentAlarms;
        synchronized (arrayList) {
            if (this._currentAlarms.size() > 0) {
                Alarm alarm = this._currentAlarms.remove(this._currentAlarms.size() - 1);
                return alarm;
            }
            return null;
        }
    }

    private long updateNextAlarmTime(long now) {
        long nextTime = this._nextAlarmTime.get();
        long delta = Math.min(nextTime - now, 60000L);
        int i = 0;
        while ((long)i < delta) {
            long time = now + (long)i;
            if (nextTime < time) {
                return nextTime;
            }
            int bucket = this.getBucket(time);
            if (this._clockArray[bucket] != null) {
                while (time < nextTime) {
                    if (this._nextAlarmTime.compareAndSet(nextTime, time)) {
                        return time;
                    }
                    nextTime = this._nextAlarmTime.get();
                }
            }
            ++i;
        }
        return nextTime;
    }

    private void dispatch(Alarm alarm, long now, boolean isTest) {
        boolean isStressTest = false;
        now = isStressTest ? CurrentTime.getExactTime() : CurrentTime.getCurrentTime();
        long wakeTime = alarm.getAndSetWakeTime(0L);
        long delta = now - wakeTime;
        if (wakeTime != 0L) {
            if (delta > 10000L) {
                log.warning(this + " slow alarm " + alarm + " " + delta + "ms" + " coordinator-delta " + (now - this._lastTime) + "ms");
            } else if (isStressTest && delta > 100L) {
                System.out.println(this + " slow alarm " + alarm + " " + delta + " coordinator-delta " + (now - this._lastTime) + "ms");
            }
        }
        if (isTest) {
            try {
                alarm.run();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else if (alarm.isPriority()) {
            this._threadPool.schedulePriority(alarm);
        } else {
            this._threadPool.schedule(alarm);
        }
    }

    private int getBucket(long time) {
        return (int)((time + 1L - 1L) / 1L % 60000L);
    }

    long getNextAlarmTime() {
        return this._nextAlarmTime.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void testClear() {
        this._now.set(0L);
        this._nextAlarmTime.set(0L);
        Object object = this._lock;
        synchronized (object) {
            this._currentAlarms.clear();
            for (int i = 59999; i >= 0; --i) {
                Alarm alarm = this._clockArray[i];
                this._clockArray[i] = null;
                while (alarm != null) {
                    Alarm next = alarm.getNext();
                    alarm.setNext(null);
                    alarm.setBucket(-1);
                    alarm.setWakeTime(alarm.getWakeTime(), 0L);
                    alarm = next;
                }
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

