/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IoUtil {
    private static final Logger log = Logger.getLogger(IoUtil.class.getName());

    public static int readInt(InputStream is) throws IOException {
        return (is.read() << 24) + (is.read() << 16) + (is.read() << 8) + is.read();
    }

    public static void writeInt(OutputStream os, int v) throws IOException {
        os.write(v >> 24);
        os.write(v >> 16);
        os.write(v >> 8);
        os.write(v);
    }

    public static long readLong(InputStream is) throws IOException {
        return ((long)is.read() << 56) + ((long)is.read() << 48) + ((long)is.read() << 40) + ((long)is.read() << 32) + ((long)is.read() << 24) + ((long)is.read() << 16) + ((long)is.read() << 8) + (long)is.read();
    }

    public static void writeLong(OutputStream os, long v) throws IOException {
        os.write((int)(v >> 56));
        os.write((int)(v >> 48));
        os.write((int)(v >> 40));
        os.write((int)(v >> 32));
        os.write((int)(v >> 24));
        os.write((int)(v >> 16));
        os.write((int)(v >> 8));
        os.write((int)v);
    }

    public static void close(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }

    public static void close(OutputStream os) {
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (IOException e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }

    public static void close(Writer os) {
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (IOException e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }
}

