/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;

public class Sprintf {
    private static final L10N L = new L10N(Sprintf.class);
    private static final int ALT = 1;
    private static final int ZERO_FILL = 2;
    private static final int POS_PLUS = 4;
    private static final int POS_SPACE = 8;
    private static final int LALIGN = 16;
    private static final int BIG = 32;
    private static final int NO_TRAIL_ZERO = 64;
    private static final int JAVAESCAPE = 128;
    private static final int CSVESCAPE = 256;
    private static final int XMLESCAPE = 512;
    private static char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static char[] bigDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static String sprintf(String format, Object[] args) {
        void var2_5;
        CharBuffer cb = CharBuffer.allocate();
        try {
            Sprintf.sprintf(cb, format, args);
            Object var5_3 = null;
            String ret = cb.close();
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            String ret = cb.close();
            throw throwable;
        }
        return var2_5;
    }

    public static String sprintf(String format, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9) {
        return Sprintf.sprintf(format, new Object[]{arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9});
    }

    public static String sprintf(String format, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8) {
        return Sprintf.sprintf(format, new Object[]{arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8});
    }

    public static String sprintf(String format, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7) {
        return Sprintf.sprintf(format, new Object[]{arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7});
    }

    public static String sprintf(String format, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) {
        return Sprintf.sprintf(format, new Object[]{arg0, arg1, arg2, arg3, arg4, arg5, arg6});
    }

    public static String sprintf(String format, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return Sprintf.sprintf(format, new Object[]{arg0, arg1, arg2, arg3, arg4, arg5});
    }

    public static String sprintf(String format, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
        return Sprintf.sprintf(format, new Object[]{arg0, arg1, arg2, arg3, arg4});
    }

    public static String sprintf(String format, Object arg0, Object arg1, Object arg2, Object arg3) {
        return Sprintf.sprintf(format, new Object[]{arg0, arg1, arg2, arg3});
    }

    public static String sprintf(String format, Object arg0, Object arg1, Object arg2) {
        return Sprintf.sprintf(format, new Object[]{arg0, arg1, arg2});
    }

    public static String sprintf(String format, Object arg0, Object arg1) {
        return Sprintf.sprintf(format, new Object[]{arg0, arg1});
    }

    public static String sprintf(String format, Object arg0) {
        return Sprintf.sprintf(format, new Object[]{arg0});
    }

    public static CharBuffer sprintf(CharBuffer result, String format, Object ... args) {
        int length = args.length;
        int arg = 0;
        int len = format.length();
        block23: for (int i = 0; i < len; ++i) {
            int start = i;
            char ch = format.charAt(i);
            if (ch != '%') {
                result.append(ch);
                continue;
            }
            int flags = 0;
            block24: while (++i < len) {
                ch = format.charAt(i);
                switch (ch) {
                    case '0': {
                        flags |= 2;
                        continue block24;
                    }
                    case '+': {
                        flags |= 4;
                        continue block24;
                    }
                    case ' ': {
                        flags |= 8;
                        continue block24;
                    }
                    case '#': {
                        flags |= 1;
                        continue block24;
                    }
                    case '-': {
                        flags |= 0x10;
                        continue block24;
                    }
                    case 'j': {
                        flags |= 0x80;
                        continue block24;
                    }
                    case 'v': {
                        flags |= 0x80;
                        flags |= 0x100;
                        continue block24;
                    }
                    case 'm': {
                        flags |= 0x200;
                        continue block24;
                    }
                }
            }
            int width = 0;
            while (i < len && (ch = format.charAt(i)) >= '0' && ch <= '9') {
                width = 10 * width + ch - 48;
                ++i;
            }
            if (i >= len) {
                Sprintf.fixBits(result, format, start, i);
                break;
            }
            int prec = 0;
            if (ch == '.') {
                while (++i < len && (ch = format.charAt(i)) >= '0' && ch <= '9') {
                    prec = 10 * prec + ch - 48;
                }
            } else {
                prec = -1;
            }
            if (i >= len) {
                Sprintf.fixBits(result, format, start, i);
                break;
            }
            switch (ch) {
                case '%': {
                    result.append('%');
                    continue block23;
                }
                case 'D': 
                case 'U': 
                case 'd': 
                case 'i': 
                case 'u': {
                    if (arg >= length) {
                        Sprintf.missing(arg);
                    }
                    Sprintf.formatInteger(result, Sprintf.toLong(args[arg++]), width, prec, flags, 10);
                    continue block23;
                }
                case 'O': 
                case 'o': {
                    if (arg >= length) {
                        Sprintf.missing(arg);
                    }
                    Sprintf.formatInteger(result, Sprintf.toLong(args[arg++]), width, prec, flags, 8);
                    continue block23;
                }
                case 'X': {
                    flags |= 0x20;
                }
                case 'x': {
                    if (arg >= length) {
                        Sprintf.missing(arg);
                    }
                    Sprintf.formatInteger(result, Sprintf.toLong(args[arg++]), width, prec, flags, 16);
                    continue block23;
                }
                case 'E': 
                case 'G': {
                    flags |= 0x20;
                }
                case 'e': 
                case 'f': 
                case 'g': {
                    if (arg >= length) {
                        Sprintf.missing(arg);
                    }
                    Sprintf.formatDouble(result, Sprintf.toDouble(args[arg++]), width, prec, flags, ch);
                    continue block23;
                }
                case 'c': {
                    if (arg >= length) {
                        Sprintf.missing(arg);
                    }
                    Sprintf.formatChar(result, Sprintf.toLong(args[arg++]), width, flags);
                    continue block23;
                }
                case 's': {
                    if (arg >= length) {
                        Sprintf.missing(arg);
                    }
                    Sprintf.formatString(result, Sprintf.toString(args[arg++], "#null"), prec, width, flags);
                    continue block23;
                }
                case 'z': {
                    if (arg >= length) {
                        Sprintf.missing(arg);
                    }
                    Sprintf.formatString(result, Sprintf.toString(args[arg++], ""), prec, width, flags);
                    continue block23;
                }
                case 'p': {
                    if (arg >= length) {
                        Sprintf.missing(arg);
                    }
                    Object o = args[arg++];
                    result.append(o.getClass().getName());
                    result.append('@');
                    result.append(Integer.toHexString(o.hashCode()));
                }
                default: {
                    Sprintf.fixBits(result, format, start, i + 1);
                }
            }
        }
        return result;
    }

    private static void missing(int arg) {
        throw new IllegalArgumentException(L.l("missing sprintf argument {0}", arg));
    }

    public static void formatDouble(CharBuffer cb, double value, int prec, int flags, int type) {
        int i;
        String raw = Double.toString(value);
        int expt = 0;
        CharBuffer digits = new CharBuffer();
        char ch = raw.charAt(i);
        boolean seenDigit = false;
        for (i = 0; i < raw.length() && (ch = raw.charAt(i)) != '.' && ch != 'e' && ch != 'E'; ++i) {
            if (!seenDigit && ch == '0') continue;
            seenDigit = true;
            digits.append(ch);
            ++expt;
        }
        if (ch == '.') {
            ++i;
        }
        while (i < raw.length()) {
            ch = raw.charAt(i);
            if (!seenDigit && ch == '0') {
                --expt;
            } else if (ch >= '0' && ch <= '9') {
                digits.append(ch);
                seenDigit = true;
            } else {
                int sign = 1;
                if ((ch = raw.charAt(++i)) == '+') {
                    ++i;
                } else if (ch == '-') {
                    ++i;
                    sign = -1;
                }
                int e = 0;
                while (i < raw.length() && (ch = raw.charAt(i)) >= '0' && ch <= '9') {
                    e = 10 * e + ch - 48;
                    ++i;
                }
                expt += sign * e;
                break;
            }
            ++i;
        }
        if (!seenDigit) {
            expt = 1;
        }
        while (digits.length() > 0 && digits.charAt(digits.length() - 1) == '0') {
            digits.setLength(digits.length() - 1);
        }
        if (type == 102) {
            if (Sprintf.roundDigits(digits, expt + prec)) {
                ++expt;
            }
            Sprintf.formatFixed(cb, digits, expt, prec, flags);
        } else if (type == 101 || type == 69) {
            if (Sprintf.roundDigits(digits, prec + 1)) {
                ++expt;
            }
            Sprintf.formatExpt(cb, digits, expt, prec, flags);
        } else {
            if (Sprintf.roundDigits(digits, prec)) {
                ++expt;
            }
            if (expt < -3 || expt > prec) {
                Sprintf.formatExpt(cb, digits, expt, prec - 1, flags | 0x40);
            } else {
                Sprintf.formatFixed(cb, digits, expt, prec - expt, flags | 0x40);
            }
        }
    }

    public static void formatDouble(CharBuffer cb, double value, int width, int prec, int flags, int type) {
        if (prec < 0) {
            prec = 6;
        }
        int offset = cb.length();
        if ((flags & 2) != 0 && (value < 0.0 || (flags & 0xC) != 0)) {
            ++offset;
            --width;
        }
        if (value < 0.0) {
            cb.append('-');
            value = -value;
        } else if ((flags & 4) != 0) {
            cb.append('+');
        } else if ((flags & 8) != 0) {
            cb.append(' ');
        }
        Sprintf.formatDouble(cb, value, prec, flags, type);
        width -= cb.length() - offset;
        for (int i = 0; i < width; ++i) {
            if ((flags & 0x10) != 0) {
                cb.append(' ');
                continue;
            }
            cb.insert(offset, (flags & 2) == 0 ? (char)' ' : '0');
        }
    }

    private static boolean roundDigits(CharBuffer digits, int len) {
        if (len < 0 || digits.length() <= len) {
            return false;
        }
        char value = digits.charAt(len);
        if (value < '5') {
            return false;
        }
        for (int i = len - 1; i >= 0; --i) {
            char ch = digits.charAt(i);
            if (ch != '9') {
                digits.setCharAt(i, (char)(ch + '\u0001'));
                return false;
            }
            digits.setCharAt(i, '0');
        }
        digits.insert(0, '1');
        return true;
    }

    private static void formatFixed(CharBuffer cb, CharBuffer digits, int expt, int prec, int flags) {
        int i = 0;
        int origExpt = expt;
        while (expt > 0) {
            if (i < digits.length()) {
                cb.append(digits.charAt(i++));
            } else {
                cb.append('0');
            }
            --expt;
        }
        if (origExpt <= 0) {
            cb.append('0');
        }
        if (prec > 0 || (flags & 1) != 0) {
            cb.append('.');
        }
        while (expt < 0 && prec > 0) {
            cb.append('0');
            --prec;
            ++expt;
        }
        while (prec > 0 && i < digits.length()) {
            cb.append(digits.charAt(i));
            --prec;
            ++i;
        }
        while (prec > 0 && (flags & 0x41) != 64) {
            cb.append('0');
            --prec;
        }
    }

    private static void formatExpt(CharBuffer cb, CharBuffer digits, int expt, int prec, int flags) {
        if (digits.length() == 0) {
            cb.append('0');
        } else {
            cb.append(digits.charAt(0));
        }
        if (prec > 0 || (flags & 1) != 0) {
            cb.append('.');
        }
        for (int i = 1; i < digits.length(); ++i) {
            if (prec > 0) {
                cb.append(digits.charAt(i));
            }
            --prec;
        }
        while (prec > 0 && (flags & 0x41) != 64) {
            cb.append('0');
            --prec;
        }
        if ((flags & 0x20) != 0) {
            cb.append('E');
        } else {
            cb.append('e');
        }
        Sprintf.formatInteger(cb, expt - 1, 0, 2, 4, 10);
    }

    public static void formatInteger(CharBuffer cb, long dvalue, int width, int prec, int flags, int radix) {
        boolean isBig = (flags & 0x20) != 0;
        int begin = cb.length();
        long value = dvalue > 0L ? (long)((double)dvalue + 0.5) : (long)((double)dvalue - 0.5);
        if (value < 0L && radix == 10) {
            cb.append('-');
            value = -value;
        } else if (value >= 0L && radix == 10 && (flags & 4) != 0) {
            cb.append('+');
        } else if (value >= 0L && radix == 10 && (flags & 8) != 0) {
            cb.append(' ');
        } else if (value < 0L) {
            value &= 0xFFFFFFFFL;
        } else if (radix == 8 && (flags & 1) != 0 && value != 0L) {
            cb.append('0');
        } else if (radix == 16 && (flags & 1) != 0) {
            cb.append((flags & 0x20) == 0 ? "0x" : "0X");
        }
        if ((flags & 2) != 0) {
            width -= cb.length() - begin;
            begin = cb.length();
        }
        int offset = cb.length();
        int len = 0;
        while (value != 0L) {
            ++len;
            cb.insert(offset, (isBig ? bigDigits : digits)[(int)(value % (long)radix)]);
            value /= (long)radix;
        }
        for (int i = 0; i < prec - len; ++i) {
            cb.insert(offset, '0');
        }
        if (len == 0 && prec == 0) {
            cb.insert(offset, '0');
        }
        width -= cb.length() - begin;
        while (width > 0) {
            if ((flags & 0x10) != 0) {
                cb.append(' ');
            } else if ((flags & 2) != 0 && prec < 0) {
                cb.insert(begin, '0');
            } else {
                cb.insert(begin, ' ');
            }
            --width;
        }
        if (cb.length() == begin) {
            cb.append('0');
        }
    }

    public static void formatInteger(CharBuffer cb, double dvalue, int width, int prec, int flags, int radix) {
        long value = dvalue > 0.0 ? (long)(dvalue + 0.5) : (long)(dvalue - 0.5);
        Sprintf.formatInteger(cb, value, width, prec, flags, radix);
    }

    public static void formatChar(CharBuffer cb, long ch, int width, int flags) {
        int offset = cb.length();
        cb.append((char)ch);
        if ((flags & 0x10) == 0) {
            for (int i = 0; i < width - 1; ++i) {
                cb.insert(offset, ' ');
            }
        } else {
            for (int i = 0; i < width - 1; ++i) {
                cb.append(' ');
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void formatString(CharBuffer cb, String string, int prec, int width, int flags) {
        offset = cb.length();
        if (prec < 0) {
            prec = 0x7FFFFFFF;
        }
        if ((flags & 256) != 0) {
            cb.append('\"');
            ++offset;
            --width;
        }
        block13: for (i = 0; i < string.length() && i < prec; ++i) {
            --width;
            ch = string.charAt(i);
            if ((flags & 128) == 0) ** GOTO lbl-1000
            switch (ch) {
                case '\\': {
                    cb.append("\\\\");
                    ++offset;
                    --width;
                    continue block13;
                }
                case '\n': {
                    cb.append("\\n");
                    ++offset;
                    --width;
                    continue block13;
                }
                case '\r': {
                    cb.append("\\r");
                    ++offset;
                    --width;
                    continue block13;
                }
                case '\"': {
                    cb.append("\\\"");
                    ++offset;
                    --width;
                    continue block13;
                }
                default: lbl-1000:
                // 2 sources

                {
                    if ((flags & 512) != 0) {
                        switch (ch) {
                            case '<': {
                                cb.append("&lt;");
                                offset += 3;
                                width -= 3;
                                continue block13;
                            }
                            case '>': {
                                cb.append("&gt;");
                                offset += 3;
                                width -= 3;
                                continue block13;
                            }
                            case '&': {
                                cb.append("&amp;");
                                offset += 4;
                                width -= 4;
                                continue block13;
                            }
                            case '\'': {
                                cb.append("&#039;");
                                offset += 5;
                                width -= 5;
                                continue block13;
                            }
                            case '\"': {
                                cb.append("&#034;");
                                offset += 5;
                                width -= 5;
                                continue block13;
                            }
                        }
                    }
                    cb.append(ch);
                }
            }
        }
        if ((flags & 256) != 0) {
            cb.append('\"');
            ++offset;
            --width;
        }
        if ((flags & 16) == 0) {
            for (i = 0; i < width; ++i) {
                cb.insert(offset, ' ');
            }
        } else {
            for (i = 0; i < width; ++i) {
                cb.append(' ');
            }
        }
    }

    private static void fixBits(CharBuffer cb, String format, int s, int i) {
        while (s < i) {
            cb.append(format.charAt(s));
            ++s;
        }
    }

    public static double toDouble(Object value) {
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Number) {
            double dValue = ((Number)value).doubleValue();
            if (Double.isNaN(dValue)) {
                return 0.0;
            }
            return dValue;
        }
        if (value.equals("")) {
            return 0.0;
        }
        if (value instanceof String) {
            double dValue = Double.parseDouble((String)value);
            if (Double.isNaN(dValue)) {
                return 0.0;
            }
            return dValue;
        }
        throw new IllegalArgumentException(L.l("can't convert {0} to double.", (Object)value.getClass().getName()));
    }

    public static long toLong(Object value) {
        if (value == null) {
            return 0L;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value.equals("")) {
            return 0L;
        }
        if (value instanceof String) {
            int i;
            int sign = 1;
            String string = (String)value;
            int length = string.length();
            long intValue = 0L;
            for (i = 0; i < length && Character.isWhitespace(string.charAt(i)); ++i) {
            }
            if (length <= i) {
                return 0L;
            }
            char ch = string.charAt(i);
            if (ch == '-') {
                sign = -1;
                ++i;
            } else if (ch == '+') {
                ++i;
            }
            while (i < length) {
                ch = string.charAt(i);
                if (ch < '0' || ch > '9') {
                    if (ch != '.') break;
                    i = length;
                    break;
                }
                intValue = 10L * intValue + (long)ch - 48L;
                ++i;
            }
            while (i < length && Character.isWhitespace(string.charAt(i))) {
                ++i;
            }
            if (i < length) {
                throw new IllegalArgumentException(L.l("can't convert '{0}' to long.", (Object)string));
            }
            return (long)sign * intValue;
        }
        throw new IllegalArgumentException(L.l("can't convert {0} to long.", (Object)value.getClass().getName()));
    }

    public static String toString(Object value, String nullValue) {
        return value == null ? nullValue : value.toString();
    }
}

