/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.ClientDisconnectException;
import com.caucho.vfs.StreamImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DatagramStream
extends StreamImpl {
    private static final Logger log = Logger.getLogger(DatagramStream.class.getName());
    private DatagramSocket _s;
    private DatagramInputStream _is;
    private DatagramOutputStream _os;
    private boolean _throwReadInterrupts = false;
    private long _totalReadBytes;
    private long _totalWriteBytes;

    public DatagramStream(DatagramSocket s) {
        this._s = s;
        this._is = new DatagramInputStream(s);
        this._os = new DatagramOutputStream(s);
    }

    public InputStream getInputStream() {
        return this._is;
    }

    public OutputStream getOutputStream() {
        return this._os;
    }

    public void setThrowReadInterrupts(boolean allowThrow) {
        this._throwReadInterrupts = allowThrow;
    }

    public boolean getThrowReadInterrupts() {
        return this._throwReadInterrupts;
    }

    public long getPosition() {
        return this._totalReadBytes;
    }

    public boolean setPosition(long offset) {
        return false;
    }

    public void unread() throws IOException {
        this._is.unread();
    }

    public boolean hasSkip() {
        return this.canRead();
    }

    public boolean canRead() {
        return this._s != null;
    }

    public long skip(long n) throws IOException {
        if (this._s == null) {
            return -1L;
        }
        return this._is.skip(n);
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        try {
            if (this._s == null || this._is == null) {
                return -1;
            }
            int readLength = this._is.read(buf, offset, length);
            if (readLength >= 0) {
                this._totalReadBytes += (long)readLength;
            }
            return readLength;
        }
        catch (InterruptedIOException e) {
            if (this._throwReadInterrupts) {
                throw e;
            }
            log.log(Level.FINEST, e.toString(), e);
        }
        catch (IOException e) {
            if (this._throwReadInterrupts) {
                throw e;
            }
            log.log(Level.FINER, e.toString(), e);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readTimeout(byte[] buf, int offset, int length, long timeout) throws IOException {
        int n;
        if (this._s == null || this._is == null) {
            return -1;
        }
        int oldTimeout = this._s.getSoTimeout();
        try {
            int readLength;
            this._s.setSoTimeout((int)timeout);
            n = readLength = this.read(buf, offset, length);
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            this._s.setSoTimeout(oldTimeout);
            throw throwable;
        }
        this._s.setSoTimeout(oldTimeout);
        return n;
    }

    public int getAvailable() throws IOException {
        if (this._is == null) {
            return -1;
        }
        return this._is.available();
    }

    public boolean canWrite() {
        return this._s != null;
    }

    public void write(byte[] buf, int offset, int length, boolean isEnd) throws IOException {
        if (this._s == null) {
            return;
        }
        try {
            this._os.write(buf, offset, length);
            this._totalWriteBytes += (long)length;
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ClientDisconnectException.create(e);
        }
    }

    public void resetTotalBytes() {
        this._totalReadBytes = 0L;
        this._totalWriteBytes = 0L;
    }

    public long getTotalReadBytes() {
        return this._totalReadBytes;
    }

    public long getTotalWriteBytes() {
        return this._totalWriteBytes;
    }

    public void closeWrite() throws IOException {
        DatagramOutputStream os = this._os;
        this._os = null;
        os.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        DatagramSocket s = this._s;
        this._s = null;
        DatagramOutputStream os = this._os;
        this._os = null;
        DatagramInputStream is = this._is;
        this._is = null;
        try {
            if (os != null) {
                os.close();
            }
            if (is != null) {
                is.close();
            }
            Object var5_4 = null;
            if (s != null) {
                s.close();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (s != null) {
                s.close();
            }
            throw throwable;
        }
    }

    static class DatagramOutputStream
    extends OutputStream {
        private final DatagramSocket _s;
        private final DatagramPacket _packet;

        DatagramOutputStream(DatagramSocket s) {
            this._s = s;
            this._packet = new DatagramPacket(new byte[0], 0, this._s.getInetAddress(), this._s.getPort());
        }

        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b}, 0, 1);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this._packet.setData(b, off, len);
            this._s.send(this._packet);
        }
    }

    static class DatagramInputStream
    extends InputStream {
        private final DatagramSocket _s;
        private final DatagramPacket _packet;
        private final byte[] _buf;
        private int _length;
        private int _offset;

        DatagramInputStream(DatagramSocket s) {
            this._s = s;
            this._buf = new byte[65536];
            this._packet = new DatagramPacket(this._buf, this._buf.length);
        }

        public int available() throws IOException {
            return this._length - this._offset;
        }

        public void unread() throws IOException {
            if (this._offset > 0) {
                --this._offset;
            }
        }

        public int read() throws IOException {
            byte[] b = new byte[1];
            this.read(b, 0, 1);
            return b[0];
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (this._length - this._offset == 0) {
                this.receivePacket();
            }
            int sublen = Math.min(this._length - this._offset, len);
            System.arraycopy(this._buf, this._offset, b, off, sublen);
            this._offset += sublen;
            return sublen;
        }

        public long skip(long n) throws IOException {
            int sublen = (int)Math.min((long)(this._length - this._offset), n);
            this._offset += sublen;
            return sublen;
        }

        private void receivePacket() throws IOException {
            this._s.receive(this._packet);
            this._offset = 0;
            this._length = this._packet.getLength();
        }
    }
}

