/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import java.io.Serializable;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GoogleInode
implements Serializable {
    private final String _name;
    private final FileType _type;
    private final long _length;
    private long _lastModified;
    private transient HashMap<String, GoogleInode> _dirMap;

    private GoogleInode() {
        this._name = null;
        this._type = FileType.NONE;
        this._length = -1L;
        this._lastModified = -1L;
    }

    public GoogleInode(String name, FileType type, long length, long lastModified) {
        this._name = name;
        this._type = type;
        this._length = length;
        this._lastModified = lastModified;
    }

    public GoogleInode(GoogleInode inode) {
        this._name = inode._name;
        this._type = inode._type;
        this._length = inode._length;
        this._lastModified = inode._lastModified;
    }

    public final String getName() {
        return this._name;
    }

    public final boolean exists() {
        return this._type == FileType.FILE || this._type == FileType.DIRECTORY;
    }

    public final boolean isFile() {
        return this._type == FileType.FILE;
    }

    public final boolean isDirectory() {
        return this._type == FileType.DIRECTORY;
    }

    public final long getLength() {
        return this._length;
    }

    public final long getLastModified() {
        return this._lastModified;
    }

    public void setLastModified(long time) {
        this._lastModified = time;
    }

    public HashMap<String, GoogleInode> getDirMap() {
        return this._dirMap;
    }

    public void setDirMap(HashMap<String, GoogleInode> map) {
        this._dirMap = map;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._name + "," + (Object)((Object)this._type) + "," + this._length + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileType {
        NONE,
        FILE,
        DIRECTORY;

    }
}

