/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.ByteBuffer;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipartStream
extends StreamImpl {
    private static final L10N L = new L10N(MultipartStream.class);
    private ByteBuffer _boundary = new ByteBuffer();
    private byte[] _boundaryBuffer;
    private int _boundaryLength;
    private ByteBuffer _peekBuffer = new ByteBuffer();
    private byte[] _peek;
    private int _peekOffset;
    private int _peekLength;
    private byte[] _dummyBuffer = new byte[32];
    private ReadStream _is;
    private ReadStream _readStream;
    private boolean _isPartDone;
    private boolean _isDone;
    private boolean _isComplete;
    private HashMap<String, List<String>> _headers = new HashMap();
    private CharBuffer _line = new CharBuffer();
    private long _maxLength = 262144L;
    private String _defaultEncoding;

    public MultipartStream() throws IOException {
        this._boundary = new ByteBuffer();
    }

    public MultipartStream(ReadStream is, String boundary) throws IOException {
        this();
        this.init(is, boundary);
    }

    public String getEncoding() {
        return this._defaultEncoding;
    }

    public void setEncoding(String encoding) {
        this._defaultEncoding = encoding;
    }

    public void init(ReadStream is, String headerBoundary) throws IOException {
        this._is = is;
        this._boundary.clear();
        this._boundary.add("--");
        this._boundary.add(headerBoundary);
        this._boundaryBuffer = this._boundary.getBuffer();
        this._boundaryLength = this._boundary.getLength();
        this._peekBuffer.setLength(this._boundaryLength + 5);
        this._peek = this._peekBuffer.getBuffer();
        this._peekOffset = 0;
        this._peekLength = 0;
        this._peek[this._peekLength++] = 10;
        this._isPartDone = false;
        this._isDone = false;
        this._isComplete = false;
        while (this.read(this._dummyBuffer, 0, this._dummyBuffer.length) >= 0) {
        }
        this._isPartDone = true;
    }

    public boolean isComplete() {
        return this._isComplete;
    }

    public ReadStream openRead() throws IOException {
        if (this._isDone) {
            return null;
        }
        if (this._readStream == null) {
            this._readStream = new ReadStream(this, null);
        } else if (!this._isPartDone) {
            int len;
            while ((len = this.read(this._dummyBuffer, 0, this._dummyBuffer.length)) >= 0) {
            }
            if (this._isDone) {
                return null;
            }
        }
        this._readStream.init(this, null);
        this._isPartDone = false;
        if (this.scanHeaders()) {
            String contentType = this.getAttribute("content-type");
            String charset = MultipartStream.getAttributePart(contentType, "charset");
            if (charset != null) {
                this._readStream.setEncoding(charset);
            } else if (this._defaultEncoding != null) {
                this._readStream.setEncoding(this._defaultEncoding);
            }
            return this._readStream;
        }
        this._isDone = true;
        this._readStream.close();
        return null;
    }

    @Override
    public String getAttribute(String key) {
        List<String> values = this._headers.get(key.toLowerCase(Locale.ENGLISH));
        if (values != null && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    public Iterator getAttributeNames() {
        return this._headers.keySet().iterator();
    }

    public HashMap<String, List<String>> getHeaders() {
        return this._headers;
    }

    private boolean scanHeaders() throws IOException {
        int ch = this.read();
        long length = 0L;
        this._headers.clear();
        while (ch > 0 && ch != 10 && ch != 13) {
            int i;
            this._line.clear();
            this._line.append((char)ch);
            ch = this.read();
            while (ch >= 0 && ch != 10 && ch != 13) {
                this._line.append((char)ch);
                if (this._maxLength < length++) {
                    throw new IOException(L.l("header length {0} exceeded.", this._maxLength));
                }
                ch = this.read();
            }
            if (ch == 13) {
                ch = this.read();
                if (ch == 10) {
                    ch = this.read();
                }
            } else if (ch == 10) {
                ch = this.read();
            }
            for (i = 0; i < this._line.length() && this._line.charAt(i) != ':'; ++i) {
            }
            String key = null;
            String value = null;
            if (i >= this._line.length()) continue;
            key = this._line.substring(0, i).trim().toLowerCase(Locale.ENGLISH);
            value = this._line.substring(i + 1).trim();
            List<String> values = this._headers.get(key);
            if (values == null) {
                values = new ArrayList<String>();
            }
            values.add(value);
            this._headers.put(key, values);
        }
        if (ch == 13 && (ch = this.read()) != 10) {
            this._peek[0] = (byte)ch;
            this._peekOffset = 0;
            this._peekLength = 1;
        }
        return true;
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public int getAvailable() throws IOException {
        if (this._isPartDone) {
            return 0;
        }
        if (this._peekOffset < this._peekLength) {
            return this._peekLength - this._peekOffset;
        }
        int ch = this.read();
        if (ch < 0) {
            return 0;
        }
        this._peekOffset = 0;
        this._peekLength = 1;
        this._peek[0] = (byte)ch;
        return 1;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int b = -1;
        if (this._isPartDone) {
            return -1;
        }
        int i = 0;
        while (this._peekOffset + 1 < this._peekLength && length > 0) {
            buffer[offset + i++] = this._peek[this._peekOffset++];
            --length;
        }
        while (i < length && (b = this.read()) >= 0) {
            int j;
            boolean hasCr = false;
            if (b == 13) {
                hasCr = true;
                b = this.read();
                if (b != 10) {
                    buffer[offset + i++] = 13;
                    this._peek[0] = (byte)b;
                    this._peekOffset = 0;
                    this._peekLength = 1;
                    continue;
                }
            } else if (b != 10) {
                buffer[offset + i++] = (byte)b;
                continue;
            }
            for (j = 0; j < this._boundaryLength && (b = this.read()) >= 0 && this._boundaryBuffer[j] == b; ++j) {
            }
            if (j == this._boundaryLength) {
                this._isPartDone = true;
                b = this.read();
                if (b == 45 && (b = this.read()) == 45) {
                    this._isDone = true;
                    this._isComplete = true;
                }
                while (b > 0 && b != 13 && b != 10) {
                    b = this.read();
                }
                if (b == 13 && (b = this.read()) != 10) {
                    this._peek[0] = (byte)b;
                    this._peekOffset = 0;
                    this._peekLength = 1;
                }
                return i > 0 ? i : -1;
            }
            this._peekLength = 0;
            if (hasCr && i + 1 < length) {
                buffer[offset + i++] = 13;
                buffer[offset + i++] = 10;
            } else if (hasCr) {
                buffer[offset + i++] = 13;
                this._peek[this._peekLength++] = 10;
            } else {
                buffer[offset + i++] = 10;
            }
            int k = 0;
            while (k < j && i + 1 < length) {
                buffer[offset + i++] = this._boundaryBuffer[k++];
            }
            while (k < j) {
                this._peek[this._peekLength++] = this._boundaryBuffer[k++];
            }
            this._peek[this._peekLength++] = (byte)b;
            this._peekOffset = 0;
        }
        if (i <= 0) {
            this._isPartDone = true;
            if (b < 0) {
                this._isDone = true;
            }
            return -1;
        }
        return i;
    }

    private int read() throws IOException {
        if (this._peekOffset < this._peekLength) {
            return this._peek[this._peekOffset++] & 0xFF;
        }
        return this._is.read();
    }

    private static String getAttributePart(String attr, String name) {
        CharBuffer value;
        block8: {
            char ch;
            int i;
            int length;
            block9: {
                block7: {
                    if (attr == null) {
                        return null;
                    }
                    length = attr.length();
                    i = attr.indexOf(name);
                    if (i < 0) {
                        return null;
                    }
                    i += name.length();
                    while (i < length && attr.charAt(i) != '=') {
                        ++i;
                    }
                    ++i;
                    while (i < length && attr.charAt(i) == ' ') {
                        ++i;
                    }
                    value = CharBuffer.allocate();
                    if (i >= length || attr.charAt(i) != '\'') break block7;
                    ++i;
                    while (i < length && attr.charAt(i) != '\'') {
                        value.append(attr.charAt(i));
                        ++i;
                    }
                    break block8;
                }
                if (i >= length || attr.charAt(i) != '\"') break block9;
                ++i;
                while (i < length && attr.charAt(i) != '\"') {
                    value.append(attr.charAt(i));
                    ++i;
                }
                break block8;
            }
            if (i >= length) break block8;
            while (i < length && (ch = attr.charAt(i)) != ' ' && ch != ';') {
                value.append(ch);
                ++i;
            }
        }
        return value.close();
    }
}

