/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.NullPath;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import java.io.IOException;

public class StringReader
extends StreamImpl {
    private String string;
    private int length;
    private int index;

    private StringReader(String string) {
        this.string = string;
        this.length = string.length();
        this.index = 0;
    }

    public static ReadStream open(String string) {
        StringReader ss = new StringReader(string);
        ReadStream rs = new ReadStream(ss);
        try {
            rs.setEncoding("UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        rs.setPath(new NullPath("string"));
        return rs;
    }

    public boolean canRead() {
        return true;
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        int i = 0;
        while (this.index < this.length && i < length) {
            char ch = this.string.charAt(this.index);
            if (ch < '\u0080') {
                buf[offset + i] = (byte)ch;
                ++i;
            } else {
                if (i + 1 >= length) break;
                if (ch < '\u0800') {
                    buf[offset + i] = (byte)(192 + (ch >> 6));
                    buf[offset + i + 1] = (byte)(128 + (ch & 0x3F));
                    i += 2;
                } else {
                    if (i + 2 >= length) break;
                    buf[offset + i] = (byte)(224 + (ch >> 12));
                    buf[offset + i + 1] = (byte)(128 + (ch >> 6 & 0x3F));
                    buf[offset + i + 2] = (byte)(128 + (ch & 0x3F));
                    i += 3;
                }
            }
            ++this.index;
        }
        return i > 0 ? i : -1;
    }

    public int getAvailable() throws IOException {
        return this.length - this.index;
    }
}

