/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.FreeRing;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TempBuffer
implements Serializable {
    private static Logger _log;
    private static final FreeRing<TempBuffer> _freeList;
    private static final FreeRing<TempBuffer> _smallFreeList;
    private static final FreeRing<TempBuffer> _largeFreeList;
    private static final boolean _isSmallmem;
    public static final int SMALL_SIZE;
    public static final int LARGE_SIZE;
    public static final int SIZE;
    private static boolean _isFreeException;
    TempBuffer _next;
    final byte[] _buf;
    int _offset;
    int _length;
    int _bufferCount;
    private transient boolean _isFree;
    private transient RuntimeException _freeException;

    public TempBuffer(int size) {
        this._buf = new byte[size];
    }

    public static boolean isSmallmem() {
        return _isSmallmem;
    }

    public static TempBuffer allocate() {
        TempBuffer next = _freeList.allocate();
        if (next == null) {
            return new TempBuffer(SIZE);
        }
        if (!next._isFree) {
            throw new IllegalStateException();
        }
        next._isFree = false;
        next._next = null;
        next._offset = 0;
        next._length = 0;
        next._bufferCount = 0;
        return next;
    }

    public static TempBuffer allocateSmall() {
        TempBuffer next = _smallFreeList.allocate();
        if (next == null) {
            return new TempBuffer(SMALL_SIZE);
        }
        next._isFree = false;
        next._next = null;
        next._offset = 0;
        next._length = 0;
        next._bufferCount = 0;
        return next;
    }

    public static TempBuffer allocateLarge() {
        TempBuffer next = _smallFreeList.allocate();
        if (next == null) {
            return new TempBuffer(LARGE_SIZE);
        }
        next._isFree = false;
        next._next = null;
        next._offset = 0;
        next._length = 0;
        next._bufferCount = 0;
        return next;
    }

    public void clear() {
        this._next = null;
        this._offset = 0;
        this._length = 0;
        this._bufferCount = 0;
    }

    public final byte[] getBuffer() {
        return this._buf;
    }

    public final int getLength() {
        return this._length;
    }

    public final void setLength(int length) {
        this._length = length;
    }

    public final int getCapacity() {
        return this._buf.length;
    }

    public int getAvailable() {
        return this._buf.length - this._length;
    }

    public final TempBuffer getNext() {
        return this._next;
    }

    public final void setNext(TempBuffer next) {
        this._next = next;
    }

    public int write(byte[] buf, int offset, int length) {
        byte[] thisBuf = this._buf;
        int thisLength = this._length;
        if (thisBuf.length - thisLength < length) {
            length = thisBuf.length - thisLength;
        }
        System.arraycopy(buf, offset, thisBuf, thisLength, length);
        this._length = thisLength + length;
        return length;
    }

    public void freeSelf() {
        if (this._buf.length == SIZE) {
            TempBuffer.free(this);
        } else if (this._buf.length == SMALL_SIZE) {
            TempBuffer.freeSmall(this);
        } else if (this._buf.length == LARGE_SIZE) {
            TempBuffer.freeLarge(this);
        }
    }

    public static void free(TempBuffer buf) {
        buf._next = null;
        if (buf._isFree) {
            _isFreeException = true;
            RuntimeException freeException = buf._freeException;
            IllegalStateException secondException = new IllegalStateException("duplicate free");
            secondException.fillInStackTrace();
            TempBuffer.log().log(Level.WARNING, "initial free location", freeException);
            TempBuffer.log().log(Level.WARNING, "secondary free location", secondException);
            throw new IllegalStateException();
        }
        buf._isFree = true;
        if (buf._buf.length == SIZE) {
            if (_isFreeException) {
                buf._freeException = new IllegalStateException("initial free");
                buf._freeException.fillInStackTrace();
            }
            _freeList.free(buf);
        }
    }

    public static void freeAll(TempBuffer buf) {
        while (buf != null) {
            TempBuffer next = buf._next;
            buf._next = null;
            TempBuffer.free(buf);
            buf = next;
        }
    }

    public static void freeSmall(TempBuffer buf) {
        buf._next = null;
        if (buf._buf.length == SMALL_SIZE) {
            if (buf._isFree) {
                IllegalStateException e = new IllegalStateException("illegal TempBuffer.free.  Please report at http://bugs.caucho.com");
                TempBuffer.log().log(Level.SEVERE, e.toString(), e);
                throw e;
            }
            buf._isFree = true;
            _smallFreeList.free(buf);
        }
    }

    public static void freeAllSmall(TempBuffer buf) {
        while (buf != null) {
            TempBuffer next = buf._next;
            buf._next = null;
            if (buf._buf.length == SMALL_SIZE) {
                if (buf._isFree) {
                    IllegalStateException e = new IllegalStateException("illegal TempBuffer.free.  Please report at http://bugs.caucho.com");
                    TempBuffer.log().log(Level.SEVERE, e.toString(), e);
                    throw e;
                }
                buf._isFree = true;
                _smallFreeList.free(buf);
            }
            buf = next;
        }
    }

    public static void freeLarge(TempBuffer buf) {
        buf._next = null;
        if (buf._buf.length == LARGE_SIZE) {
            if (buf._isFree) {
                IllegalStateException e = new IllegalStateException("illegal TempBuffer.free.  Please report at http://bugs.caucho.com");
                TempBuffer.log().log(Level.SEVERE, e.toString(), e);
                throw e;
            }
            buf._isFree = true;
            _largeFreeList.free(buf);
        }
    }

    public static void freeAllLarge(TempBuffer buf) {
        while (buf != null) {
            TempBuffer next = buf._next;
            buf._next = null;
            if (buf._buf.length == LARGE_SIZE) {
                if (buf._isFree) {
                    IllegalStateException e = new IllegalStateException("illegal TempBuffer.free.  Please report at http://bugs.caucho.com");
                    TempBuffer.log().log(Level.SEVERE, e.toString(), e);
                    throw e;
                }
                buf._isFree = true;
                _largeFreeList.free(buf);
            }
            buf = next;
        }
    }

    public static void clearFreeLists() {
        while (_freeList.allocate() != null) {
        }
        while (_largeFreeList.allocate() != null) {
        }
        while (_smallFreeList.allocate() != null) {
        }
    }

    private static Logger log() {
        if (_log == null) {
            _log = Logger.getLogger(TempBuffer.class.getName());
        }
        return _log;
    }

    static {
        _freeList = new FreeRing(64);
        _smallFreeList = new FreeRing(256);
        _largeFreeList = new FreeRing(32);
        int size = 8192;
        boolean isSmallmem = false;
        String smallmem = System.getProperty("caucho.smallmem");
        if (smallmem != null && !"false".equals(smallmem)) {
            isSmallmem = true;
            size = 512;
        }
        _isSmallmem = isSmallmem;
        SIZE = size;
        LARGE_SIZE = 8192;
        SMALL_SIZE = 512;
    }
}

