/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.CharSegment;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.LockableStream;
import com.caucho.vfs.OutputStreamWithBuffer;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReaderWriterStream;
import com.caucho.vfs.SendfileOutputStream;
import com.caucho.vfs.StreamFilter;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.StreamPrintWriter;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.VfsWriteObject;
import com.caucho.vfs.i18n.EncodingWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WriteStream
extends OutputStreamWithBuffer
implements LockableStream,
SendfileOutputStream {
    private static final byte[] LF_BYTES = new byte[]{10};
    private static final byte[] CR_BYTES = new byte[]{13};
    private static final byte[] CRLF_BYTES = new byte[]{13, 10};
    private static String _sysNewline = Path.getNewlineString();
    private static byte[] _sysNewlineBytes = _sysNewline.getBytes();
    private static final int CHARS_LENGTH = 256;
    private TempBuffer _tempWrite;
    private byte[] _writeBuffer;
    private int _writeLength;
    private boolean _isFlushRequired;
    private StreamImpl _source;
    private long _position;
    private final char[] _chars = new char[256];
    private byte[] _bytes;
    private EncodingWriter _writeEncoding;
    private String _writeEncodingName;
    private boolean _implicitFlush = false;
    private boolean _isFlushOnNewline;
    private boolean _disableClose;
    private boolean _isDisableCloseSource;
    private boolean _isDisableFlush;
    private boolean _isReuseBuffer;
    private StreamPrintWriter _printWriter;
    private String _newline = "\n";
    private byte[] _newlineBytes = LF_BYTES;

    public WriteStream() {
    }

    public WriteStream(StreamImpl source) {
        this.init(source);
    }

    public void init(StreamImpl source) {
        this._disableClose = false;
        this._isDisableCloseSource = false;
        if (this._source != null && this._source != source) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (source == null) {
            throw new IllegalArgumentException();
        }
        if (this._tempWrite == null) {
            this._tempWrite = TempBuffer.allocate();
            this._writeBuffer = this._tempWrite._buf;
        }
        this._source = source;
        this._position = 0L;
        this._writeLength = 0;
        this._isFlushRequired = false;
        this._isFlushOnNewline = source.getFlushOnNewline();
        this._newline = "\n";
        this._newlineBytes = LF_BYTES;
        this._writeEncoding = null;
        this._writeEncodingName = "ISO-8859-1";
    }

    public void setSysNewline() {
        this._newline = _sysNewline;
        this._newlineBytes = _sysNewlineBytes;
    }

    public StreamImpl getSource() {
        return this._source;
    }

    public void pushFilter(StreamFilter filter) {
        filter.init(this._source);
        this._source = filter;
    }

    public boolean canWrite() {
        return this._source != null && this._source.canWrite();
    }

    public void clearWrite() {
        if (this._source != null) {
            this._source.clearWrite();
        }
    }

    public void setReuseBuffer(boolean reuse) {
        this._isReuseBuffer = reuse;
    }

    @Override
    public byte[] getBuffer() {
        return this._writeBuffer;
    }

    @Override
    public int getBufferOffset() {
        return this._writeLength;
    }

    @Override
    public void setBufferOffset(int offset) {
        this._writeLength = offset;
    }

    public int getBufferSize() {
        return this._writeBuffer.length;
    }

    public int getRemaining() {
        if (this._source == null) {
            return 0;
        }
        return this._writeBuffer.length - this._writeLength;
    }

    public void setImplicitFlush(boolean implicitFlush) {
        this._implicitFlush = implicitFlush;
    }

    @Override
    public void write(int ch) throws IOException {
        byte[] writeBuffer = this._writeBuffer;
        int len = this._writeLength;
        if (writeBuffer.length <= len) {
            if (this._source == null) {
                return;
            }
            this._writeLength = 0;
            this._source.write(writeBuffer, 0, len, false);
            this._position += (long)len;
            this._isFlushRequired = true;
            len = 0;
        }
        writeBuffer[len] = (byte)ch;
        this._writeLength = len + 1;
        if (this._implicitFlush) {
            this.flush();
        }
    }

    @Override
    public void write(byte[] buf, int offset, int length) throws IOException {
        byte[] buffer = this._writeBuffer;
        int bufferLength = buffer.length;
        int writeLength = this._writeLength;
        StreamImpl source = this._source;
        if (source == null) {
            return;
        }
        if (bufferLength <= length) {
            if (writeLength > 0) {
                source.write(buffer, 0, writeLength, false);
            }
            source.write(buf, offset, length, false);
            this._writeLength = 0;
            this._position += (long)length;
            this._isFlushRequired = true;
            return;
        }
        while (length > 0) {
            int sublen = Math.min(length, bufferLength - writeLength);
            System.arraycopy(buf, offset, buffer, writeLength, sublen);
            offset += sublen;
            length -= sublen;
            if (bufferLength > (writeLength += sublen)) continue;
            int len = writeLength;
            writeLength = 0;
            source.write(buffer, 0, len, false);
            this._position += (long)len;
        }
        this._writeLength = writeLength;
        if (this._implicitFlush) {
            this.flush();
        }
    }

    @Override
    public byte[] nextBuffer(int offset) throws IOException {
        this._writeLength = 0;
        if (this._source != null) {
            this._source.write(this._writeBuffer, 0, offset, false);
            this._isFlushRequired = true;
        }
        this._position += (long)offset;
        if (this._implicitFlush) {
            this.flush();
        }
        return this._writeBuffer;
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    @Override
    public void flush() throws IOException {
        if (this._isDisableFlush || this._source == null) {
            return;
        }
        int len = this._writeLength;
        if (len > 0) {
            this._writeLength = 0;
            this._source.write(this._writeBuffer, 0, len, false);
            this._isFlushRequired = true;
            this._position += (long)len;
        }
        if (this._source != null && this._isFlushRequired) {
            this._isFlushRequired = false;
            this._source.flush();
        }
    }

    public void flushToDisk() throws IOException {
        StreamImpl source = this._source;
        if (this._isDisableFlush || source == null) {
            return;
        }
        this.flush();
        source.flushToDisk();
    }

    public final void flushBuffer() throws IOException {
        StreamImpl source = this._source;
        if (this._isDisableFlush || this._source == null) {
            return;
        }
        int len = this._writeLength;
        if (len > 0) {
            this._writeLength = 0;
            source.write(this._writeBuffer, 0, len, false);
            this._position += (long)len;
            this._isFlushRequired = true;
            source.flushBuffer();
        }
    }

    public void seekStart(long pos) throws IOException {
        this.flushBuffer();
        StreamImpl source = this._source;
        if (source != null) {
            source.seekStart(pos);
            this._position = pos;
        }
    }

    public void seekEnd(long offset) throws IOException {
        this.flushBuffer();
        StreamImpl source = this._source;
        if (source != null) {
            source.seekEnd(offset);
        }
        this._position = offset;
    }

    public void setEncoding(String encoding) throws UnsupportedEncodingException {
        String mimeName;
        if (this._source instanceof ReaderWriterStream) {
            encoding = "UTF-8";
        }
        if ((mimeName = Encoding.getMimeName(encoding)) != null && mimeName.equals(this._writeEncodingName)) {
            return;
        }
        if (this._source != null) {
            this._source.setWriteEncoding(encoding);
        }
        this._writeEncoding = Encoding.getWriteEncoding(encoding);
        this._writeEncodingName = mimeName;
    }

    public void setLocale(Locale locale) throws UnsupportedEncodingException {
        if (this._writeEncoding == null && locale != null) {
            this.setEncoding(Encoding.getMimeName(locale));
        }
    }

    public String getEncoding() {
        if (this._source instanceof ReaderWriterStream) {
            return ((ReaderWriterStream)this._source).getEncoding();
        }
        return this._writeEncodingName;
    }

    public String getJavaEncoding() {
        return Encoding.getJavaName(this.getEncoding());
    }

    public void setFlushOnNewline(boolean flushOnNewline) {
        this._isFlushOnNewline = flushOnNewline;
    }

    public String getNewlineString() {
        return this._newline;
    }

    public void setNewlineString(String newline) {
        if (newline != null) {
            if (this._newline != newline && !newline.equals(this._newline)) {
                this._newlineBytes = newline == "\n" || newline.equals("\n") ? LF_BYTES : (newline == "\r\n" || newline.equals("\r\n") ? CRLF_BYTES : (newline == "\r" || newline.equals("\r") ? CR_BYTES : newline.getBytes()));
            }
            this._newline = newline;
        }
    }

    public final void print(char[] buffer, int offset, int length) throws IOException {
        if (this._source == null) {
            return;
        }
        if (this._writeEncoding != null) {
            this._isDisableFlush = true;
            this._writeEncoding.write(this, buffer, offset, length);
            this._isDisableFlush = false;
            return;
        }
        this.printLatin1(buffer, offset, length);
    }

    public final void printLatin1(char[] buffer, int offset, int length) throws IOException {
        if (this._source == null) {
            return;
        }
        byte[] writeBuffer = this._writeBuffer;
        int writeLength = this._writeLength;
        while (length > 0) {
            int sublen = writeBuffer.length - writeLength;
            if (sublen <= 0) {
                this._source.write(writeBuffer, 0, writeLength, false);
                this._position += (long)writeLength;
                this._isFlushRequired = true;
                writeLength = 0;
                sublen = writeBuffer.length - writeLength;
            }
            sublen = Math.min(sublen, length);
            for (int i = sublen - 1; i >= 0; --i) {
                char ch = buffer[offset + i];
                writeBuffer[writeLength + i] = ch < '\u0100' ? (int)ch : 63;
            }
            writeLength += sublen;
            offset += sublen;
            length -= sublen;
        }
        this._writeLength = writeLength;
    }

    public final void printUtf8(String value, int offset, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            char ch = value.charAt(offset + i);
            if (ch < '\u0080') {
                this.write(ch);
                continue;
            }
            if (ch < '\u0800') {
                this.write(0xC0 | ch >> 6);
                this.write(0x80 | ch & 0x3F);
                continue;
            }
            this.write(0xE0 | ch >> 12);
            this.write(0x80 | ch >> 6 & 0x3F);
            this.write(0x80 | ch & 0x3F);
        }
    }

    public final void print(char ch) throws IOException {
        if (this._writeEncoding != null) {
            this._isDisableFlush = true;
            this._writeEncoding.write(this, ch);
            this._isDisableFlush = false;
            return;
        }
        this.write((byte)ch);
    }

    public final void print(char[] buffer) throws IOException {
        this.print(buffer, 0, buffer.length);
    }

    public final void print(CharSegment segment) throws IOException {
        this.print(segment.getBuffer(), segment.getOffset(), segment.getLength());
    }

    public final void print(String string) throws IOException {
        if (string == null) {
            string = "null";
        }
        int length = string.length();
        int offset = 0;
        char[] chars = this._chars;
        while (length > 0) {
            int sublen = Math.min(length, 256);
            string.getChars(offset, offset + sublen, chars, 0);
            this.print(chars, 0, sublen);
            length -= sublen;
            offset += sublen;
        }
    }

    public final void printLatin1(String string) throws IOException {
        if (string == null) {
            string = "null";
        }
        int length = string.length();
        int offset = 0;
        char[] chars = this._chars;
        while (length > 0) {
            int sublen = Math.min(length, 256);
            string.getChars(offset, offset + sublen, chars, 0);
            this.printLatin1(chars, 0, sublen);
            length -= sublen;
            offset += sublen;
        }
    }

    public final void XprintLatin1NoLf(String string) throws IOException {
        int sublen;
        if (this._source == null) {
            return;
        }
        if (string == null) {
            string = "null";
        }
        byte[] writeBuffer = this._writeBuffer;
        int writeLength = this._writeLength;
        int offset = 0;
        int charsLength = 256;
        char[] chars = this._chars;
        for (int length = string.length(); length > 0; length -= sublen) {
            sublen = Math.min(charsLength, writeBuffer.length - writeLength);
            if (sublen <= 0) {
                this._source.write(writeBuffer, 0, writeLength, false);
                this._position += (long)writeLength;
                this._isFlushRequired = true;
                writeLength = 0;
                sublen = Math.min(charsLength, writeBuffer.length - writeLength);
            }
            sublen = Math.min(length, sublen);
            string.getChars(offset, sublen, chars, 0);
            for (int i = 0; i < sublen; ++i) {
                byte value = (byte)chars[i];
                if (value == 13 || value == 10) {
                    length = 0;
                    break;
                }
                writeBuffer[writeLength++] = value;
            }
            offset += sublen;
        }
        this._writeLength = writeLength;
    }

    public final void printLatin1NoLf(String string) throws IOException {
        if (string == null) {
            string = "null";
        }
        int length = string.length();
        int offset = 0;
        char[] chars = this._chars;
        while (length > 0) {
            int sublen = Math.min(length, chars.length);
            string.getChars(offset, offset + sublen, chars, 0);
            for (int i = sublen - 1; i >= 0; --i) {
                char value = chars[i];
                if (value != '\r' && value != '\n') continue;
                length = sublen = i;
            }
            this.printLatin1(chars, 0, sublen);
            length -= sublen;
            offset += sublen;
        }
    }

    public final void print(String string, int offset, int length) throws IOException {
        if (string == null) {
            string = "null";
        }
        int charsLength = 256;
        char[] chars = this._chars;
        while (length > 0) {
            int sublen = Math.min(length, charsLength);
            string.getChars(offset, offset + sublen, chars, 0);
            this.print(chars, 0, sublen);
            length -= sublen;
            offset += sublen;
        }
    }

    public final void print(boolean b) throws IOException {
        this.print(b ? "true" : "false");
    }

    public final void print(int i) throws IOException {
        if (i == Integer.MIN_VALUE) {
            this.print("-2147483648");
            return;
        }
        if (i < 0) {
            this.write(45);
            i = -i;
        } else if (i < 9) {
            this.write(48 + i);
            return;
        }
        int length = 0;
        int exp = 10;
        if (i >= 1000000000) {
            length = 9;
        } else {
            while (i >= exp) {
                exp = 10 * exp;
                ++length;
            }
        }
        byte[] buffer = this._writeBuffer;
        int writeLength = this._writeLength;
        if (writeLength + length < buffer.length) {
            this._writeLength = (writeLength += length) + 1;
            for (int j = 0; j <= length; ++j) {
                buffer[writeLength - j] = (byte)(i % 10 + 48);
                i /= 10;
            }
            return;
        }
        if (this._bytes == null) {
            this._bytes = new byte[32];
        }
        int j = 31;
        while (i > 0) {
            this._bytes[--j] = (byte)(i % 10 + 48);
            i /= 10;
        }
        this.write(this._bytes, j, 31 - j);
    }

    public final void print(long i) throws IOException {
        if (i == Long.MIN_VALUE) {
            this.print("-9223372036854775808");
            return;
        }
        if (this._bytes == null) {
            this._bytes = new byte[32];
        }
        if (i < 0L) {
            this.write(45);
            i = -i;
        } else if (i == 0L) {
            this.write(48);
            return;
        }
        int j = 31;
        while (i > 0L) {
            this._bytes[--j] = (byte)(i % 10L + 48L);
            i /= 10L;
        }
        this.write(this._bytes, j, 31 - j);
    }

    public final void print(float f) throws IOException {
        this.print(String.valueOf(f));
    }

    public final void print(double d) throws IOException {
        this.print(String.valueOf(d));
    }

    public final void print(Object o) throws IOException {
        if (o == null) {
            this.print("null");
        } else if (o instanceof VfsWriteObject) {
            ((VfsWriteObject)o).print(this);
        } else {
            this.print(o.toString());
        }
    }

    public final void println() throws IOException {
        this.write(this._newlineBytes, 0, this._newlineBytes.length);
        if (this._isFlushOnNewline) {
            this.flush();
        }
    }

    public final void println(char[] buf, int offset, int length) throws IOException {
        this.print(buf, offset, length);
        this.write(this._newlineBytes, 0, this._newlineBytes.length);
        if (this._isFlushOnNewline) {
            this.flush();
        }
    }

    public final void println(String string) throws IOException {
        this.print(string);
        this.write(this._newlineBytes, 0, this._newlineBytes.length);
        if (this._isFlushOnNewline) {
            this.flush();
        }
    }

    public final void println(boolean b) throws IOException {
        this.println(b ? "true" : "false");
    }

    public final void println(char ch) throws IOException {
        this.write(ch);
        this.write(this._newlineBytes, 0, this._newlineBytes.length);
        if (this._isFlushOnNewline) {
            this.flush();
        }
    }

    public final void println(int i) throws IOException {
        this.print(i);
        this.write(this._newlineBytes, 0, this._newlineBytes.length);
        if (this._isFlushOnNewline) {
            this.flush();
        }
    }

    public final void println(long l) throws IOException {
        this.print(l);
        this.write(this._newlineBytes, 0, this._newlineBytes.length);
        if (this._isFlushOnNewline) {
            this.flush();
        }
    }

    public final void println(float f) throws IOException {
        this.println(String.valueOf(f));
    }

    public final void println(double d) throws IOException {
        this.println(String.valueOf(d));
    }

    public final void println(Object o) throws IOException {
        if (o == null) {
            this.println("null");
        } else {
            this.println(o.toString());
        }
    }

    public PrintWriter getPrintWriter() {
        if (this._printWriter == null) {
            this._printWriter = new StreamPrintWriter(this);
        }
        return this._printWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void log(String string) {
        try {
            WriteStream writeStream = this;
            synchronized (writeStream) {
                this.println(string);
                this.flush();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void log(Throwable exn) {
        try {
            PrintWriter out = this.getPrintWriter();
            WriteStream writeStream = this;
            synchronized (writeStream) {
                if (exn != null) {
                    exn.printStackTrace(out);
                    this.flush();
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public long writeStream(InputStream source) throws IOException {
        int len;
        int tmplen;
        if (source == null) {
            return 0L;
        }
        int length = this._writeBuffer.length;
        long outputLength = 0L;
        if (length <= this._writeLength) {
            tmplen = this._writeLength;
            this._writeLength = 0;
            this._source.write(this._writeBuffer, 0, tmplen, false);
            this._isFlushRequired = true;
            this._position += (long)tmplen;
            outputLength += (long)tmplen;
        }
        while ((len = source.read(this._writeBuffer, this._writeLength, length - this._writeLength)) >= 0) {
            this._writeLength += len;
            outputLength += (long)len;
            if (length > this._writeLength) continue;
            tmplen = this._writeLength;
            this._writeLength = 0;
            this._source.write(this._writeBuffer, 0, tmplen, false);
            this._isFlushRequired = true;
            this._position += (long)tmplen;
        }
        if (this._isFlushOnNewline || this._implicitFlush) {
            this.flush();
        }
        return outputLength;
    }

    public void writeStream(Reader reader) throws IOException {
        int len;
        if (reader == null) {
            return;
        }
        char[] chars = this._chars;
        while ((len = reader.read(chars, 0, 256)) > 0) {
            this.print(chars, 0, len);
        }
    }

    public void writeStream(InputStream source, int totalLength) throws IOException {
        if (source == null) {
            return;
        }
        int length = this._writeBuffer.length;
        if (length <= this._writeLength) {
            int tmplen = this._writeLength;
            this._writeLength = 0;
            this._source.write(this._writeBuffer, 0, tmplen, false);
            this._isFlushRequired = true;
            this._position += (long)tmplen;
        }
        while (totalLength > 0) {
            int sublen = Math.min(totalLength, length - this._writeLength);
            if ((sublen = source.read(this._writeBuffer, this._writeLength, sublen)) < 0) break;
            this._writeLength += sublen;
            totalLength -= sublen;
            if (length > this._writeLength) continue;
            int tmplen = this._writeLength;
            this._writeLength = 0;
            this._source.write(this._writeBuffer, 0, tmplen, false);
            this._isFlushRequired = true;
            this._position += (long)tmplen;
        }
        if (this._isFlushOnNewline || this._implicitFlush) {
            this.flush();
        }
    }

    public void writeStream(StreamImpl source) throws IOException {
        int len;
        int tmplen;
        if (source == null) {
            return;
        }
        int length = this._writeBuffer.length;
        if (length <= this._writeLength) {
            tmplen = this._writeLength;
            this._writeLength = 0;
            this._source.write(this._writeBuffer, 0, tmplen, false);
            this._isFlushRequired = true;
            this._position += (long)tmplen;
        }
        while ((len = source.read(this._writeBuffer, this._writeLength, length - this._writeLength)) >= 0) {
            this._writeLength += len;
            if (length > this._writeLength) continue;
            tmplen = this._writeLength;
            this._writeLength = 0;
            this._source.write(this._writeBuffer, 0, tmplen, false);
            this._isFlushRequired = true;
            this._position += (long)tmplen;
        }
        if (this._isFlushOnNewline || this._implicitFlush) {
            this.flush();
        }
    }

    public void writeFile(Path path) throws IOException {
        StreamImpl is = path.openReadImpl();
        try {
            if (is != null) {
                this.writeStream(is);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public void setDisableClose(boolean disableClose) {
        this._disableClose = disableClose;
    }

    public boolean getDisableClose() {
        return this._disableClose;
    }

    public void setDisableCloseSource(boolean disableClose) {
        this._isDisableCloseSource = disableClose;
    }

    @Override
    public final boolean isClosed() {
        return this._source == null || this._source.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IOException {
        Path path;
        StreamImpl s;
        block13: {
            TempBuffer tempWrite2;
            s = this._source;
            try {
                int len = this._writeLength;
                if (len > 0) {
                    this._writeLength = 0;
                    if (s != null) {
                        s.write(this._writeBuffer, 0, len, !this._disableClose);
                    }
                }
                Object var4_4 = null;
                if (this._disableClose) {
                    return;
                }
                this._source = null;
                if (this._writeEncoding != null) {
                    this._writeEncoding = null;
                }
                if (this._isReuseBuffer) break block13;
                tempWrite2 = this._tempWrite;
                this._tempWrite = null;
                this._writeBuffer = null;
                if (tempWrite2 == null) break block13;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (this._disableClose) {
                    return;
                }
                this._source = null;
                if (this._writeEncoding != null) {
                    this._writeEncoding = null;
                }
                if (!this._isReuseBuffer) {
                    TempBuffer tempWrite2 = this._tempWrite;
                    this._tempWrite = null;
                    this._writeBuffer = null;
                    if (tempWrite2 != null) {
                        TempBuffer.free(tempWrite2);
                    }
                }
                if (s != null && !this._isDisableCloseSource) {
                    s.closeWrite();
                }
                throw throwable;
            }
            TempBuffer.free(tempWrite2);
        }
        if (s != null && !this._isDisableCloseSource) {
            s.closeWrite();
        }
        if (s != null && (path = s.getPath()) != null) {
            path.clearStatusCache();
        }
    }

    public final void free() {
        this._source = null;
        TempBuffer tempWrite = this._tempWrite;
        this._tempWrite = null;
        this._writeBuffer = null;
        if (tempWrite != null) {
            TempBuffer.free(tempWrite);
        }
    }

    public Object getAttribute(String name) throws IOException {
        return this._source.getAttribute(name);
    }

    public void setAttribute(String name, Object value) throws IOException {
        this._source.setAttribute(name, value);
    }

    public void removeAttribute(String name) throws IOException {
        this._source.removeAttribute(name);
    }

    public Iterator<String> getAttributeNames() throws IOException {
        return this._source.getAttributeNames();
    }

    public Path getPath() {
        if (this._source != null) {
            return this._source.getPath();
        }
        return null;
    }

    public String getUserPath() {
        return this._source.getPath().getUserPath();
    }

    public void setPath(Path path) {
        this._source.setPath(path);
    }

    public static void setSystemNewline(String newline) {
        _sysNewline = newline;
        _sysNewlineBytes = _sysNewline.getBytes();
    }

    @Override
    public boolean lock(boolean shared, boolean block) {
        if (!(this._source instanceof LockableStream)) {
            return true;
        }
        LockableStream ls = (LockableStream)((Object)this._source);
        return ls.lock(shared, block);
    }

    @Override
    public boolean unlock() {
        if (!(this._source instanceof LockableStream)) {
            return true;
        }
        LockableStream ls = (LockableStream)((Object)this._source);
        return ls.unlock();
    }

    public long getPosition() {
        return this._position + (long)this._writeLength;
    }

    public void clearPosition() {
        this._position = -this._writeLength;
    }

    public boolean setPosition(long pos) throws IOException {
        if (pos < 0L) {
            return false;
        }
        this.seekStart(pos);
        return this._source != null;
    }

    @Override
    public boolean isMmapEnabled() {
        return this._source.isMmapEnabled();
    }

    @Override
    public boolean isSendfileEnabled() {
        return this._source.isSendfileEnabled();
    }

    @Override
    public void writeMmap(long mmapAddress, long[] mmapBlocks, long mmapOffset, long mmapLength) throws IOException {
        if (this._writeLength > 0) {
            int writeLength = this._writeLength;
            this._writeLength = 0;
            this._position += (long)writeLength;
            this._source.write(this._writeBuffer, 0, writeLength, false);
        }
        this._source.writeMmap(mmapAddress, mmapBlocks, mmapOffset, mmapLength);
        this._isFlushRequired = true;
        this._position += mmapLength;
    }

    @Override
    public void writeSendfile(byte[] fileName, int nameLength, long fileLength) throws IOException {
        int writeLength = this._writeLength;
        if (writeLength > 0) {
            this._writeLength = 0;
            this._position += (long)writeLength;
        }
        this._source.writeSendfile(this._writeBuffer, 0, writeLength, fileName, nameLength, fileLength);
        this._isFlushRequired = true;
        this._position += fileLength;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._source + "]";
    }
}

