/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml.stream;

import com.caucho.util.CharBuffer;
import com.caucho.vfs.WriteStream;
import java.io.IOException;

public class Escapifier {
    public static String escape(String s) {
        if (s == null) {
            return "";
        }
        CharBuffer cb = null;
        int len = s.length();
        block6: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c >= ' ' && c <= '\u007f' && c != '&' && c != '<' && c != '>' && c != '\"' || Character.isWhitespace(c)) {
                if (cb == null) continue;
                cb.append(c);
                continue;
            }
            if (cb == null) {
                cb = new CharBuffer();
                cb.append(s.substring(0, i));
            }
            switch (c) {
                case '&': {
                    cb.append("&amp;");
                    continue block6;
                }
                case '<': {
                    cb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    cb.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    cb.append("&quot;");
                    continue block6;
                }
                default: {
                    cb.append("&#" + (c & 0xFFFF) + ";");
                }
            }
        }
        if (cb == null) {
            return s;
        }
        return cb.toString();
    }

    public static void escape(String s, WriteStream ws) throws IOException {
        ws.print(Escapifier.escape(s));
    }

    public static void escape(char[] buffer, int offset, int len, WriteStream out) throws IOException {
        block7: for (int i = 0; i < len; ++i) {
            char ch = buffer[offset + i];
            switch (ch) {
                case '&': {
                    out.print("&amp;");
                    continue block7;
                }
                case '<': {
                    out.print("&lt;");
                    continue block7;
                }
                case '>': {
                    out.print("&gt;");
                    continue block7;
                }
                case '\"': {
                    out.print("&quot;");
                    continue block7;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    out.print(ch);
                    continue block7;
                }
                default: {
                    if (' ' <= ch && ch <= '\u007f') {
                        out.print(ch);
                        continue block7;
                    }
                    out.print("&#" + ch + ";");
                }
            }
        }
    }
}

