/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.expr;

import com.caucho.util.CharBuffer;
import com.caucho.xpath.Expr;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.XPathFun;
import com.caucho.xpath.pattern.AbstractPattern;
import java.util.ArrayList;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunExpr
extends Expr {
    private String _name;
    private AbstractPattern _pattern;
    private ArrayList<Expr> _args;

    public FunExpr(String name, AbstractPattern pattern, ArrayList<Expr> args) {
        this._name = name;
        this._pattern = pattern;
        this._args = args;
    }

    @Override
    public boolean evalBoolean(Node node, ExprEnvironment env) throws XPathException {
        return FunExpr.toBoolean(this.evalObject(node, env));
    }

    @Override
    public double evalNumber(Node node, ExprEnvironment env) throws XPathException {
        return FunExpr.toDouble(this.evalObject(node, env));
    }

    @Override
    public String evalString(Node node, ExprEnvironment env) throws XPathException {
        return FunExpr.toString(this.evalObject(node, env));
    }

    @Override
    public Object evalObject(Node node, ExprEnvironment env) throws XPathException {
        XPathFun fun = env.getFunction(this._name);
        if (fun == null) {
            throw new RuntimeException("unknown function: " + this._name);
        }
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; i < this._args.size(); ++i) {
            Expr expr = this._args.get(i);
            values.add(expr.evalObject(node, env));
        }
        return fun.eval(node, env, this._pattern, values);
    }

    public String toString() {
        CharBuffer cb = new CharBuffer();
        cb.append(this._name);
        cb.append("(");
        for (int i = 0; i < this._args.size(); ++i) {
            if (i != 0) {
                cb.append(", ");
            }
            cb.append(this._args.get(i));
        }
        cb.append(")");
        return cb.toString();
    }
}

