/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xpath.pattern.NamespaceNode;
import com.caucho.xpath.pattern.NodeIterator;
import com.caucho.xpath.pattern.SelectedAttribute;
import com.caucho.xpath.pattern.SelectedNode;
import java.util.logging.Level;
import org.w3c.dom.Node;

public class NamespaceIterator
extends NodeIterator {
    protected NodeIterator _parentIter;
    protected AbstractPattern _match;
    protected NamespaceNode _node;
    protected NamespaceNode _next;

    protected NamespaceIterator(ExprEnvironment env) {
        super(env);
    }

    public NamespaceIterator(Node node, NodeIterator parentIter, ExprEnvironment env, AbstractPattern match) throws XPathException {
        super(env);
        this._parentIter = parentIter;
        this._match = match;
        if (parentIter == null) {
            this._node = NamespaceNode.create(node);
        }
        this._next = this._node = this.findFirstMatchingNode();
    }

    public boolean hasNext() {
        if (this._next == null) {
            try {
                this._next = (NamespaceNode)this.nextNode();
            }
            catch (XPathException e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        return this._next != null;
    }

    public Node nextNode() throws XPathException {
        if (this._next != null) {
            this._node = this._next;
            this._next = null;
            return this._node;
        }
        if (this._node != null) {
            this._node = (NamespaceNode)this._node.getNextSibling();
            this._node = this.findFirstMatchingNode();
        }
        this._next = null;
        return this._node;
    }

    public SelectedNode nextSelectedNode() throws XPathException {
        Node node = this.nextNode();
        return node == null ? null : new SelectedAttribute(node);
    }

    private NamespaceNode findFirstMatchingNode() throws XPathException {
        while (true) {
            Node parentNode;
            if (this._node != null) {
                if (this._match == null || this._match.match(this._node, this._env)) {
                    ++this._position;
                    return this._node;
                }
                this._node = (NamespaceNode)this._node.getNextSibling();
                continue;
            }
            if (this._parentIter == null || (parentNode = this._parentIter.nextNode()) == null) {
                return null;
            }
            this._position = 0;
            this._size = 0;
            this._node = NamespaceNode.create(parentNode);
        }
    }

    public int getContextSize() {
        return this._position;
    }

    public Object clone() {
        return null;
    }

    public String toString() {
        return "NamespaceIterator[" + this._match + "]";
    }
}

