/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rdfs;

import java.net.URI;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.structr.rdfs.OWLParserv2;
import org.structr.rdfs.OWLProperty;
import org.structr.rdfs.RDFItem;
import org.w3c.dom.Element;

public class OWLClass
extends RDFItem<OWLClass> {
    private final Set<OWLProperty> properties = new TreeSet<OWLProperty>();
    private final Set<OWLClass> sourceClasses = new TreeSet<OWLClass>();
    private final Set<OWLClass> targetClasses = new TreeSet<OWLClass>();
    private final Set<String> domainIds = new TreeSet<String>();
    private final Set<String> rangeIds = new TreeSet<String>();
    private boolean isRelationship = false;
    private boolean allowsInstances = false;
    private boolean multipleOccurrences = false;
    private boolean isMixedIn = false;
    private boolean oneWay = false;
    private boolean primary = false;
    private OWLClass actualSourceType = null;
    private OWLClass actualTargetType = null;
    private OWLClass inverse = null;
    private URI inverseId = null;
    protected String icon = null;

    public OWLClass(Element element) {
        super(element);
        this.initialize();
    }

    @Override
    public String toString() {
        return this.getStructrName(true);
    }

    public String getIcon() {
        return this.icon;
    }

    public void addProperty(OWLProperty oWLProperty) {
        this.properties.add(oWLProperty);
    }

    public Set<OWLProperty> getProperties() {
        return this.properties;
    }

    public Set<OWLProperty> getAllProperties() {
        Set set = this.getTypeAndSuperclasses();
        TreeSet<OWLProperty> treeSet = new TreeSet<OWLProperty>();
        for (OWLClass oWLClass : set) {
            treeSet.addAll(oWLClass.getProperties());
        }
        return treeSet;
    }

    public boolean hasSuperclass(OWLClass oWLClass) {
        OWLClass oWLClass2 = (OWLClass)this.getSuperclass();
        if (oWLClass2 != null) {
            if (oWLClass2.getId().equals(oWLClass.getId())) {
                return true;
            }
            return oWLClass2.hasSuperclass(oWLClass);
        }
        return false;
    }

    public Set<String> getDomainIds() {
        if (this.domainIds.isEmpty() && this.getSuperclass() != null) {
            return ((OWLClass)this.getSuperclass()).getDomainIds();
        }
        return this.domainIds;
    }

    public Set<String> getRangeIds() {
        if (this.rangeIds.isEmpty() && this.getSuperclass() != null) {
            return ((OWLClass)this.getSuperclass()).getRangeIds();
        }
        return this.rangeIds;
    }

    public void resolveRelatedTypes(Map<URI, OWLClass> map) {
        OWLClass oWLClass;
        URI uRI;
        for (String string : this.getDomainIds()) {
            uRI = URI.create(string);
            oWLClass = map.get(uRI);
            if (oWLClass != null) {
                this.sourceClasses.add(oWLClass);
                continue;
            }
            OWLParserv2.logger.println("No class found for " + string);
        }
        for (String string : this.getRangeIds()) {
            uRI = URI.create(string);
            oWLClass = map.get(uRI);
            if (oWLClass != null) {
                this.targetClasses.add(oWLClass);
                continue;
            }
            OWLParserv2.logger.println("No class found for " + string);
        }
    }

    public void setIsRelationship(boolean bl) {
        this.isRelationship = bl;
    }

    public boolean isRelationship() {
        return this.isRelationship;
    }

    public void setSourceClass(OWLClass oWLClass) {
        this.sourceClasses.add(oWLClass);
    }

    public void setTargetClass(OWLClass oWLClass) {
        this.targetClasses.add(oWLClass);
    }

    public void resolveRelationshipTypes(Map<URI, OWLClass> map) {
        if (this.inverseId != null) {
            this.inverse = map.get(this.inverseId);
        }
        this.actualSourceType = this.findCommonBaseType(this.sourceClasses);
        this.actualTargetType = this.findCommonBaseType(this.targetClasses);
    }

    public Set<OWLClass> getSourceClasses() {
        return this.sourceClasses;
    }

    public Set<OWLClass> getTargetClasses() {
        return this.targetClasses;
    }

    public OWLClass getInverse() {
        return this.inverse;
    }

    public URI getInverseOfId() {
        return this.inverseId;
    }

    public boolean multipleOccurrences() {
        return this.multipleOccurrences;
    }

    public List<OWLClass> getActualSourceTypes() {
        LinkedList<OWLClass> linkedList = new LinkedList<OWLClass>();
        if (this.actualSourceType != null) {
            linkedList.add(this.actualSourceType);
        } else {
            linkedList.addAll(this.findCommonBaseTypes(this.sourceClasses));
        }
        return linkedList;
    }

    public List<OWLClass> getActualTargetTypes() {
        LinkedList<OWLClass> linkedList = new LinkedList<OWLClass>();
        if (this.actualTargetType != null) {
            linkedList.add(this.actualTargetType);
        } else {
            linkedList.addAll(this.findCommonBaseTypes(this.targetClasses));
        }
        return linkedList;
    }

    public boolean hasInverse() {
        return this.inverse != null;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    private OWLClass findCommonBaseType(Set<OWLClass> set) {
        if (!set.isEmpty()) {
            if (set.size() > 1) {
                LinkedHashSet linkedHashSet = null;
                for (OWLClass oWLClass : set) {
                    Set set2 = oWLClass.getTypeAndSuperclasses();
                    if (linkedHashSet == null) {
                        linkedHashSet = new LinkedHashSet();
                        linkedHashSet.addAll(set2);
                        continue;
                    }
                    linkedHashSet.retainAll(set2);
                }
                if (!linkedHashSet.isEmpty()) {
                    return (OWLClass)linkedHashSet.iterator().next();
                }
            } else {
                return set.iterator().next();
            }
        }
        return null;
    }

    private List<OWLClass> findCommonBaseTypes(Set<OWLClass> set) {
        LinkedList<OWLClass> linkedList = new LinkedList<OWLClass>();
        if (!set.isEmpty()) {
            linkedList.addAll(set);
        }
        return linkedList;
    }

    @Override
    protected Set<String> getInheritanceIdentifiers() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("rdfs:subClassOf");
        hashSet.add("rdfs:subPropertyOf");
        return hashSet;
    }

    private void initialize() {
        String string;
        Element element;
        this.domainIds.addAll(this.getResourceIds("rdfs:domain"));
        this.rangeIds.addAll(this.getResourceIds("rdfs:range"));
        this.allowsInstances = "true".equals(this.getValue(this.getFirstElement(this.getElement(), "krdf:allowsInstances")));
        this.multipleOccurrences = "true".equals(this.getValue(this.getFirstElement(this.getElement(), "krdf:multipleOccurrences")));
        this.isMixedIn = "true".equals(this.getValue(this.getFirstElement(this.getElement(), "krdf:isMixedIn")));
        this.oneWay = "true".equals(this.getValue(this.getFirstElement(this.getElement(), "krdf:oneWay")));
        this.icon = this.getValue(this.getFirstElement(this.getElement(), "krdf:icon"));
        String string2 = this.getValue(this.getFirstElement(this.getElement(), "krdf:primary"));
        if (string2 == null || "true".equals(string2)) {
            this.primary = true;
        }
        if ((element = this.getFirstElement(this.getElement(), "owl:inverseOf")) != null && (string = this.getResourceId(element)) != null) {
            this.inverseId = URI.create(string);
        }
    }
}

