/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rdfs;

import java.net.URI;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.Localization;
import org.structr.core.graph.NodeAttribute;
import org.structr.core.property.PropertyKey;
import org.structr.rdfs.Choice;
import org.structr.rdfs.OWLClass;
import org.structr.rdfs.OWLParserv2;
import org.structr.rdfs.RDFItem;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class OWLProperty<T extends RDFItem>
extends RDFItem<T> {
    private static final Map<String, String> replacementMap = new LinkedHashMap<String, String>();
    private final Set<OWLProperty> datatypeProperties = new TreeSet<OWLProperty>();
    private final Set<OWLProperty> objectProperties = new TreeSet<OWLProperty>();
    private final Set<String> domainIds = new TreeSet<String>();
    private final Set<String> rangeIds = new TreeSet<String>();
    private final Set<String> typeIds = new TreeSet<String>();
    private boolean allowsInstances = false;
    private boolean multipleOccurrences = false;
    private boolean isMixedIn = false;
    private boolean oneWay = false;

    public OWLProperty(Element element) {
        super(element);
        this.initialize();
    }

    @Override
    public String toString() {
        return this.getTypeName() + "(" + (this.typeIds.isEmpty() ? this.rangeIds : this.typeIds) + ")";
    }

    public void resolveClassProperties(Map<URI, OWLClass> map) {
        for (String string : this.getDomainIds()) {
            URI uRI = URI.create(string);
            OWLClass oWLClass = map.get(uRI);
            if (oWLClass != null) {
                oWLClass.addProperty(this);
                continue;
            }
            OWLParserv2.logger.println("No class found for " + string);
        }
    }

    public Set<String> getDomainIds() {
        if (this.domainIds.isEmpty() && this.getSuperclass() != null) {
            return ((OWLProperty)this.getSuperclass()).getDomainIds();
        }
        return this.domainIds;
    }

    public Set<String> getRangeIds() {
        if (this.rangeIds.isEmpty() && this.getSuperclass() != null) {
            return ((OWLProperty)this.getSuperclass()).getRangeIds();
        }
        return this.rangeIds;
    }

    public Set<String> getTypeIds() {
        return this.typeIds;
    }

    public boolean allowsInstances() {
        return this.allowsInstances;
    }

    public boolean multipleOccurrences() {
        return this.multipleOccurrences;
    }

    public boolean isMixedIn() {
        return this.isMixedIn;
    }

    public boolean oneWay() {
        return this.oneWay;
    }

    public void addDatatypeProperty(OWLProperty oWLProperty) {
        this.datatypeProperties.add(oWLProperty);
    }

    public void addObjectProperty(OWLProperty oWLProperty) {
        this.objectProperties.add(oWLProperty);
    }

    public Set<OWLProperty> getDatatypeProperties() {
        return this.datatypeProperties;
    }

    public Set<OWLProperty> getObjectProperties() {
        return this.objectProperties;
    }

    public boolean isPrimitiveType() {
        return !this.getTypeIds().isEmpty();
    }

    public String getRawPrimitiveType() {
        if (!this.getTypeIds().isEmpty()) {
            return this.getTypeIds().iterator().next();
        }
        return null;
    }

    public String getStructrType() {
        String string = this.getRawPrimitiveType();
        if (string != null) {
            String string2 = OWLParserv2.customKTypeMapping.get(string);
            if (string2 != null) {
                return OWLParserv2.xmlSchemaPropertyMapping.get(string2);
            }
            switch (string) {
                case "KBlob": {
                    return "File";
                }
                case "KChoice": {
                    return "Enum";
                }
            }
        }
        return null;
    }

    public String getAdditionalFormat() {
        switch (this.getRawPrimitiveType()) {
            case "KDate": {
                return "dd.MM.yyyy";
            }
            case "KDateAndTime": {
                return "dd.MM.yyyy HH:mm:ss";
            }
            case "KFlexTime": {
                return "dd.MM.yyyy";
            }
        }
        return null;
    }

    public Set<Choice> getChoices() {
        NodeList nodeList = this.getElements(this.getElement(), "krdf:hasChoice");
        TreeSet<Choice> treeSet = new TreeSet<Choice>();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            String string;
            Element element;
            Element element2 = (Element)nodeList.item(i);
            Element element3 = this.getFirstElement(element2, "krdf:Choice");
            if (element3 == null || (element = this.getFirstElement(element3, "krdf:choiceName")) == null || (string = this.getValue(element)) == null) continue;
            Choice choice = new Choice(string, this.convertValue(string).toString());
            String string2 = this.getValue(this.getFirstElement(element3, "krdf:order"));
            if (string2 != null && StringUtils.isNumeric((String)string2)) {
                choice.setPosition(Integer.parseInt(string2));
            }
            choice.setTranslations(this.getElements(element3, "krdf:choiceTranslation"));
            treeSet.add(choice);
        }
        return treeSet;
    }

    public Object convertValue(Object object) {
        if ("Enum".equals(this.getStructrType()) && object != null) {
            String string = object.toString();
            for (Map.Entry<String, String> entry : replacementMap.entrySet()) {
                string = string.replace(entry.getKey(), entry.getValue());
            }
            return "_" + string.replaceAll("[\\W_]+", "_");
        }
        return object;
    }

    public String[] getEnums(String string) throws FrameworkException {
        App app = StructrApp.getInstance();
        Set<Choice> set = this.getChoices();
        String[] stringArray = new String[set.size()];
        int n = 0;
        for (Choice choice : set) {
            stringArray[n++] = choice.getIdentifier();
            for (Map.Entry<String, String> entry : choice.getTranslations().entrySet()) {
                app.create(Localization.class, new NodeAttribute[]{new NodeAttribute((PropertyKey)Localization.domain, (Object)string), new NodeAttribute((PropertyKey)Localization.name, (Object)choice.getIdentifier()), new NodeAttribute((PropertyKey)Localization.locale, (Object)entry.getKey()), new NodeAttribute((PropertyKey)Localization.localizedName, (Object)entry.getValue())});
            }
        }
        return stringArray;
    }

    @Override
    protected Set<String> getInheritanceIdentifiers() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("rdfs:subPropertyOf");
        return hashSet;
    }

    private void initialize() {
        this.domainIds.addAll(this.getResourceIds("rdfs:domain"));
        this.rangeIds.addAll(this.getResourceIds("rdfs:range"));
        this.typeIds.addAll(this.getResourceIds("krdf:type"));
        this.allowsInstances = "true".equals(this.getValue(this.getFirstElement(this.getElement(), "krdf:allowsInstances")));
        this.multipleOccurrences = "true".equals(this.getValue(this.getFirstElement(this.getElement(), "krdf:multipleOccurrences")));
        this.isMixedIn = "true".equals(this.getValue(this.getFirstElement(this.getElement(), "krdf:isMixedIn")));
        this.oneWay = "true".equals(this.getValue(this.getFirstElement(this.getElement(), "krdf:oneWay")));
    }

    static {
        replacementMap.put("&lt;", "less");
        replacementMap.put("<;", "less");
        replacementMap.put("&gt;", "greater");
        replacementMap.put(">", "greater");
        replacementMap.put("=", "equal");
        replacementMap.put("\u20ac", "euro");
        replacementMap.put("$", "dollar");
        replacementMap.put("%", "percent");
        replacementMap.put("/", " per ");
        replacementMap.put("\u00e4", "ae");
        replacementMap.put("\u00c4", "Ae");
        replacementMap.put("\u00f6", "oe");
        replacementMap.put("\u00d6", "Oe");
        replacementMap.put("\u00fc", "ue");
        replacementMap.put("\u00dc", "Ue");
        replacementMap.put("\u00df", "ss");
        replacementMap.put("?", "unknown");
        replacementMap.put("\u00b5", "micro");
        replacementMap.put(".", "dot");
        replacementMap.put("(", "_");
        replacementMap.put(")", "_");
    }
}

