/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rdfs;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.structr.common.SecurityContext;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.NodeInterface;
import org.structr.core.property.PropertyKey;
import org.structr.rdfs.OWLClass;
import org.structr.rdfs.OWLProperty;
import org.structr.rdfs.RDFItem;
import org.structr.schema.ConfigurationProvider;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RDFDescription
extends RDFItem<RDFDescription> {
    private String referenceId = null;

    public RDFDescription(Element element) {
        super(element);
        this.initialize();
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public void resolveProperties(NodeInterface nodeInterface, Map<String, OWLClass> map, Map<String, OWLProperty> map2) {
        ConfigurationProvider configurationProvider = StructrApp.getConfiguration();
        NodeList nodeList = this.getElement().getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            String string = element.getTagName();
            OWLProperty oWLProperty = map2.get(string);
            if (oWLProperty != null) {
                Class<?> clazz = nodeInterface.getClass();
                String string2 = oWLProperty.getStructrName(false);
                Object object = this.getValue(element);
                try {
                    Class clazz2;
                    OWLClass oWLClass;
                    OWLClass oWLClass2;
                    PropertyKey propertyKey = configurationProvider.getPropertyKeyForJSONName(clazz, string2, false);
                    if (propertyKey == null && (oWLClass2 = map.get(clazz.getSimpleName())) != null && (oWLClass = oWLClass2.getInverse()) != null && (clazz2 = configurationProvider.getNodeEntityClass(oWLClass.getStructrName(true))) != null) {
                        propertyKey = configurationProvider.getPropertyKeyForJSONName(clazz2, string2, false);
                    }
                    if (propertyKey != null) {
                        oWLClass2 = propertyKey.inputConverter(SecurityContext.getSuperUserInstance());
                        if (oWLClass2 != null) {
                            object = oWLClass2.convert(object);
                        }
                        nodeInterface.setProperty(propertyKey, object);
                        continue;
                    }
                    System.out.println("Description: no property key found for " + string2 + " of " + clazz.getSimpleName());
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                continue;
            }
            System.out.println("Property for " + string + " not found!");
        }
    }

    @Override
    protected Set<String> getInheritanceIdentifiers() {
        return Collections.emptySet();
    }

    private void initialize() {
        this.referenceId = this.getAttribute(this.getElement(), "rdf:ID");
    }
}

