/*
 * Decompiled with CFR 0.152.
 */
package org.structr.text;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.structr.agent.Task;
import org.structr.api.service.LicenseManager;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.common.fulltext.FulltextIndexer;
import org.structr.common.fulltext.Indexable;
import org.structr.core.GraphObjectMap;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractSchemaNode;
import org.structr.core.property.GenericProperty;
import org.structr.core.property.PropertyKey;
import org.structr.module.StructrModule;
import org.structr.schema.action.Actions;
import org.structr.text.FulltextIndexingTask;
import org.structr.text.FulltextTokenizer;

public class FulltextIndexerModule
implements FulltextIndexer,
StructrModule {
    public void onLoad(LicenseManager licenseManager) {
    }

    public void addToFulltextIndex(Indexable node) throws FrameworkException {
        StructrApp.getInstance((SecurityContext)node.getSecurityContext()).processTasks(new Task[]{new FulltextIndexingTask(node)});
    }

    public GraphObjectMap getContextObject(String searchTerm, String text, int contextLength) {
        GraphObjectMap contextObject = new GraphObjectMap();
        LinkedHashSet<String> contextValues = new LinkedHashSet<String>();
        String[] searchParts = searchTerm.split("[\\s,;]+");
        GenericProperty contextKey = new GenericProperty("context");
        for (String searchString : searchParts) {
            String lowerCaseSearchString = searchString.toLowerCase();
            String lowerCaseText = text.toLowerCase();
            StringBuilder wordBuffer = new StringBuilder();
            StringBuilder lineBuffer = new StringBuilder();
            int textLength = text.length();
            int newlineCount = 0;
            int wordCount = 0;
            int pos = -1;
            do {
                char c;
                int i;
                if ((pos = lowerCaseText.indexOf(lowerCaseSearchString, pos + 1)) <= 0) continue;
                lineBuffer.setLength(0);
                wordBuffer.setLength(0);
                wordCount = 0;
                newlineCount = 0;
                for (i = pos; i >= 0; --i) {
                    c = text.charAt(i);
                    if (!(Character.isAlphabetic(c) || Character.isDigit(c) || FulltextTokenizer.SpecialChars.contains(Character.valueOf(c)))) {
                        wordBuffer.insert(0, c);
                        newlineCount = c == '\n' ? ++newlineCount : 0;
                        if (newlineCount <= 1 && (wordCount += FulltextIndexerModule.flushWordBuffer(lineBuffer, wordBuffer, true)) <= contextLength / 2) continue;
                        break;
                    }
                    wordBuffer.insert(0, c);
                    newlineCount = 0;
                }
                wordCount += FulltextIndexerModule.flushWordBuffer(lineBuffer, wordBuffer, true);
                wordBuffer.setLength(0);
                for (i = pos + 1; i < textLength; ++i) {
                    c = text.charAt(i);
                    if (!(Character.isAlphabetic(c) || Character.isDigit(c) || FulltextTokenizer.SpecialChars.contains(Character.valueOf(c)))) {
                        wordBuffer.append(c);
                        newlineCount = c == '\n' ? ++newlineCount : 0;
                        if (newlineCount <= 1 && (wordCount += FulltextIndexerModule.flushWordBuffer(lineBuffer, wordBuffer, false)) <= contextLength) continue;
                        break;
                    }
                    wordBuffer.append(c);
                    newlineCount = 0;
                }
                wordCount += FulltextIndexerModule.flushWordBuffer(lineBuffer, wordBuffer, false);
                contextValues.add(lineBuffer.toString().trim());
            } while (pos >= 0);
        }
        contextObject.put((PropertyKey)contextKey, contextValues);
        return contextObject;
    }

    public String getName() {
        return "text-search";
    }

    public Set<String> getDependencies() {
        return null;
    }

    public Set<String> getFeatures() {
        return null;
    }

    public void insertImportStatements(AbstractSchemaNode schemaNode, StringBuilder buf) {
    }

    public void insertSourceCode(AbstractSchemaNode schemaNode, StringBuilder buf) {
    }

    public Set<String> getInterfacesForType(AbstractSchemaNode schemaNode) {
        return null;
    }

    public void insertSaveAction(AbstractSchemaNode schemaNode, StringBuilder buf, Actions.Type type) {
    }

    private static int flushWordBuffer(StringBuilder lineBuffer, StringBuilder wordBuffer, boolean prepend) {
        int wordCount = 0;
        if (wordBuffer.length() > 0) {
            String word = wordBuffer.toString().replaceAll("[\\n\\t]+", " ");
            if (StringUtils.isNotBlank((CharSequence)word)) {
                if (prepend) {
                    lineBuffer.insert(0, word);
                } else {
                    lineBuffer.append(word);
                }
                wordCount = 1;
            }
            wordBuffer.setLength(0);
        }
        return wordCount;
    }
}

