/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.net;

import java.io.IOException;
import java.nio.channels.ByteChannel;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.internal.messaging.PackStreamMessageFormatV1;
import org.neo4j.driver.internal.net.BufferingChunkedInput;
import org.neo4j.driver.internal.net.ChunkedOutput;
import org.neo4j.driver.internal.net.SocketProtocol;

public class SocketProtocolV1
implements SocketProtocol {
    private final MessageFormat messageFormat = new PackStreamMessageFormatV1();
    private final MessageFormat.Reader reader;
    private final MessageFormat.Writer writer;

    public SocketProtocolV1(ByteChannel channel) throws IOException {
        ChunkedOutput output = new ChunkedOutput(channel);
        BufferingChunkedInput input = new BufferingChunkedInput(channel);
        this.writer = new PackStreamMessageFormatV1.Writer(output, output.messageBoundaryHook());
        this.reader = new PackStreamMessageFormatV1.Reader(input, input.messageBoundaryHook());
    }

    @Override
    public MessageFormat.Reader reader() {
        return this.reader;
    }

    @Override
    public MessageFormat.Writer writer() {
        return this.writer;
    }

    @Override
    public int version() {
        return this.messageFormat.version();
    }
}

