/*
 * Decompiled with CFR 0.152.
 */
package org.structr.xmpp;

import java.util.HashMap;
import java.util.List;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Presence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.View;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.core.Export;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.ModificationQueue;
import org.structr.core.graph.NodeAttribute;
import org.structr.core.graph.Tx;
import org.structr.core.property.BooleanProperty;
import org.structr.core.property.EndNodes;
import org.structr.core.property.EnumProperty;
import org.structr.core.property.FunctionProperty;
import org.structr.core.property.IntProperty;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.core.property.StringProperty;
import org.structr.rest.RestMethodResult;
import org.structr.schema.SchemaService;
import org.structr.xmpp.XMPPClientConnection;
import org.structr.xmpp.XMPPClientRequest;
import org.structr.xmpp.XMPPContext;
import org.structr.xmpp.XMPPInfo;
import org.structr.xmpp.XMPPRequest;

public class XMPPClient
extends AbstractNode
implements XMPPInfo {
    private static final Logger logger = LoggerFactory.getLogger((String)XMPPClient.class.getName());
    public static final Property<List<XMPPRequest>> pendingRequests = new EndNodes("pendingRequests", XMPPClientRequest.class);
    public static final Property<String> xmppHandle = new FunctionProperty("xmppHandle").format("concat(this.xmppUsername, '@', this.xmppHost)").indexed();
    public static final Property<String> xmppUsername = new StringProperty("xmppUsername").indexed();
    public static final Property<String> xmppPassword = new StringProperty("xmppPassword");
    public static final Property<String> xmppService = new StringProperty("xmppService");
    public static final Property<String> xmppHost = new StringProperty("xmppHost");
    public static final Property<Integer> xmppPort = new IntProperty("xmppPort");
    public static final Property<Presence.Mode> presenceMode = new EnumProperty("presenceMode", Presence.Mode.class, (Enum)Presence.Mode.available);
    public static final Property<Boolean> isEnabled = new BooleanProperty("isEnabled");
    public static final Property<Boolean> isConnected = new BooleanProperty("isConnected");
    public static final View publicView;
    public static final View uiView;

    public boolean onCreation(SecurityContext securityContext, ErrorBuffer errorBuffer) throws FrameworkException {
        if (((Boolean)this.getProperty((PropertyKey)isEnabled)).booleanValue()) {
            XMPPContext.connect(this);
        }
        return super.onCreation(securityContext, errorBuffer);
    }

    public boolean onModification(SecurityContext securityContext, ErrorBuffer errorBuffer, ModificationQueue modificationQueue) throws FrameworkException {
        XMPPClientConnection xMPPClientConnection = XMPPContext.getClientForId(this.getUuid());
        boolean bl = (Boolean)this.getProperty((PropertyKey)isEnabled);
        if (!bl) {
            if (xMPPClientConnection != null && xMPPClientConnection.isConnected()) {
                xMPPClientConnection.disconnect();
            }
        } else {
            if (xMPPClientConnection == null || !xMPPClientConnection.isConnected()) {
                XMPPContext.connect(this);
            }
            if ((xMPPClientConnection = XMPPContext.getClientForId(this.getUuid())) != null) {
                if (xMPPClientConnection.isConnected()) {
                    this.setProperty((PropertyKey)isConnected, true);
                    xMPPClientConnection.setPresence((Presence.Mode)this.getProperty((PropertyKey)presenceMode));
                } else {
                    this.setProperty((PropertyKey)isConnected, false);
                }
            }
        }
        return super.onModification(securityContext, errorBuffer, modificationQueue);
    }

    public boolean onDeletion(SecurityContext securityContext, ErrorBuffer errorBuffer, PropertyMap propertyMap) throws FrameworkException {
        XMPPClientConnection xMPPClientConnection;
        String string = (String)propertyMap.get((PropertyKey)id);
        if (string != null && (xMPPClientConnection = XMPPContext.getClientForId(string)) != null) {
            xMPPClientConnection.disconnect();
        }
        return super.onDeletion(securityContext, errorBuffer, propertyMap);
    }

    @Override
    public String getUsername() {
        return (String)this.getProperty((PropertyKey)xmppUsername);
    }

    @Override
    public String getPassword() {
        return (String)this.getProperty((PropertyKey)xmppPassword);
    }

    @Override
    public String getService() {
        return (String)this.getProperty((PropertyKey)xmppService);
    }

    @Override
    public String getHostName() {
        return (String)this.getProperty((PropertyKey)xmppHost);
    }

    @Override
    public int getPort() {
        return (Integer)this.getProperty((PropertyKey)xmppPort);
    }

    @Export
    public RestMethodResult doSendMessage(String string, String string2) throws FrameworkException {
        if (((Boolean)this.getProperty((PropertyKey)isEnabled)).booleanValue()) {
            XMPPClientConnection xMPPClientConnection = XMPPContext.getClientForId(this.getUuid());
            if (xMPPClientConnection.isConnected()) {
                xMPPClientConnection.sendMessage(string, string2);
            } else {
                throw new FrameworkException(422, "Not connected.");
            }
        }
        return new RestMethodResult(200);
    }

    @Export
    public RestMethodResult doSubscribe(String string) throws FrameworkException {
        if (((Boolean)this.getProperty((PropertyKey)isEnabled)).booleanValue()) {
            XMPPClientConnection xMPPClientConnection = XMPPContext.getClientForId(this.getUuid());
            if (xMPPClientConnection.isConnected()) {
                xMPPClientConnection.subscribe(string);
            } else {
                throw new FrameworkException(422, "Not connected.");
            }
        }
        return new RestMethodResult(200);
    }

    @Export
    public RestMethodResult doUnsubscribe(String string) throws FrameworkException {
        if (((Boolean)this.getProperty((PropertyKey)isEnabled)).booleanValue()) {
            XMPPClientConnection xMPPClientConnection = XMPPContext.getClientForId(this.getUuid());
            if (xMPPClientConnection.isConnected()) {
                xMPPClientConnection.unsubscribe(string);
            } else {
                throw new FrameworkException(422, "Not connected.");
            }
        }
        return new RestMethodResult(200);
    }

    @Export
    public RestMethodResult doConfirmSubscription(String string) throws FrameworkException {
        if (((Boolean)this.getProperty((PropertyKey)isEnabled)).booleanValue()) {
            XMPPClientConnection xMPPClientConnection = XMPPContext.getClientForId(this.getUuid());
            if (xMPPClientConnection.isConnected()) {
                xMPPClientConnection.confirmSubscription(string);
            } else {
                throw new FrameworkException(422, "Not connected.");
            }
        }
        return new RestMethodResult(200);
    }

    @Export
    public RestMethodResult doDenySubscription(String string) throws FrameworkException {
        if (((Boolean)this.getProperty((PropertyKey)isEnabled)).booleanValue()) {
            XMPPClientConnection xMPPClientConnection = XMPPContext.getClientForId(this.getUuid());
            if (xMPPClientConnection.isConnected()) {
                xMPPClientConnection.denySubscription(string);
            } else {
                throw new FrameworkException(422, "Not connected.");
            }
        }
        return new RestMethodResult(200);
    }

    @Export
    public RestMethodResult doJoinChat(String string, String string2, String string3) throws FrameworkException {
        if (((Boolean)this.getProperty((PropertyKey)isEnabled)).booleanValue()) {
            XMPPClientConnection xMPPClientConnection = XMPPContext.getClientForId(this.getUuid());
            if (xMPPClientConnection.isConnected()) {
                xMPPClientConnection.joinChat(string, string2, string3);
            } else {
                throw new FrameworkException(422, "Not connected.");
            }
        }
        return new RestMethodResult(200);
    }

    @Export
    public RestMethodResult doSendChatMessage(String string, String string2, String string3) throws FrameworkException {
        if (((Boolean)this.getProperty((PropertyKey)isEnabled)).booleanValue()) {
            XMPPClientConnection xMPPClientConnection = XMPPContext.getClientForId(this.getUuid());
            if (xMPPClientConnection.isConnected()) {
                xMPPClientConnection.sendChatMessage(string, string2, string3);
            } else {
                throw new FrameworkException(422, "Not connected.");
            }
        }
        return new RestMethodResult(200);
    }

    public static void onMessage(String string, Message message) {
        App app = StructrApp.getInstance();
        try (Tx tx = app.tx();){
            XMPPClient xMPPClient = (XMPPClient)StructrApp.getInstance().get(XMPPClient.class, string);
            if (xMPPClient != null) {
                String string2 = "onXMPP" + message.getClass().getSimpleName();
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("sender", message.getFrom());
                hashMap.put("message", message.getBody());
                xMPPClient.invokeMethod(string2, hashMap, false);
            }
            tx.success();
        }
        catch (FrameworkException frameworkException) {
            logger.warn("", (Throwable)frameworkException);
        }
    }

    public static void onRequest(String string, IQ iQ) {
        App app = StructrApp.getInstance();
        try (Tx tx = app.tx();){
            XMPPClient xMPPClient = (XMPPClient)StructrApp.getInstance().get(XMPPClient.class, string);
            if (xMPPClient != null) {
                app.create(XMPPRequest.class, new NodeAttribute[]{new NodeAttribute(XMPPRequest.client, (Object)xMPPClient), new NodeAttribute(XMPPRequest.sender, (Object)iQ.getFrom()), new NodeAttribute((PropertyKey)XMPPRequest.owner, xMPPClient.getProperty((PropertyKey)owner)), new NodeAttribute(XMPPRequest.content, (Object)iQ.toXML().toString()), new NodeAttribute(XMPPRequest.requestType, (Object)iQ.getType())});
            }
            tx.success();
        }
        catch (FrameworkException frameworkException) {
            logger.warn("", (Throwable)frameworkException);
        }
    }

    static {
        SchemaService.registerBuiltinTypeOverride((String)"XMPPClient", (String)XMPPClient.class.getName());
        publicView = new View(XMPPClient.class, "public", new Property[]{xmppHandle, xmppUsername, xmppPassword, xmppService, xmppHost, xmppPort, presenceMode, isEnabled, isConnected, pendingRequests});
        uiView = new View(XMPPClient.class, "ui", new Property[]{xmppHandle, xmppUsername, xmppPassword, xmppService, xmppHost, xmppPort, presenceMode, isEnabled, isConnected, pendingRequests});
    }
}

