/*
 * Decompiled with CFR 0.152.
 */
package org.structr.xmpp;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.java7.Java7SmackInitializer;
import org.jivesoftware.smack.packet.Bind;
import org.jivesoftware.smack.packet.EmptyResultIQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.roster.packet.RosterPacket;
import org.jivesoftware.smack.sm.predicates.ForEveryStanza;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration;
import org.jivesoftware.smackx.muc.DiscussionHistory;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.MultiUserChatManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.service.InitializationCallback;
import org.structr.common.error.FrameworkException;
import org.structr.core.Services;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.xmpp.XMPPClient;
import org.structr.xmpp.XMPPClientConnection;
import org.structr.xmpp.XMPPInfo;
import org.structr.xmpp.handler.BindTypeHandler;
import org.structr.xmpp.handler.EmptyResultIQTypeHandler;
import org.structr.xmpp.handler.MessageTypeHandler;
import org.structr.xmpp.handler.PresenceTypeHandler;
import org.structr.xmpp.handler.RosterPacketTypeHandler;
import org.structr.xmpp.handler.TypeHandler;

public class XMPPContext {
    private static final Logger logger = LoggerFactory.getLogger((String)XMPPContext.class.getName());
    private static final Map<String, XMPPClientConnection> connections = new HashMap<String, XMPPClientConnection>();
    private static final Map<String, TypeHandler> typeHandlers = new HashMap<String, TypeHandler>();

    public static void connect(XMPPInfo xMPPInfo) throws FrameworkException {
        new Java7SmackInitializer().initialize();
        XMPPTCPConnectionConfiguration xMPPTCPConnectionConfiguration = ((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)XMPPTCPConnectionConfiguration.builder().setUsernameAndPassword((CharSequence)xMPPInfo.getUsername(), xMPPInfo.getPassword())).setSecurityMode(ConnectionConfiguration.SecurityMode.ifpossible)).setServiceName(xMPPInfo.getService())).setHost(xMPPInfo.getHostName())).setPort(xMPPInfo.getPort())).build();
        try {
            XMPPTCPConnection xMPPTCPConnection = new XMPPTCPConnection(xMPPTCPConnectionConfiguration);
            connections.put(xMPPInfo.getUuid(), new StructrXMPPConnection(xMPPInfo, (AbstractXMPPConnection)xMPPTCPConnection));
            xMPPTCPConnection.connect();
        }
        catch (IOException | SmackException | XMPPException throwable) {
            logger.warn("", throwable);
        }
    }

    public static XMPPClientConnection getClientForId(String string) {
        return connections.get(string);
    }

    static {
        typeHandlers.put(Bind.class.getName(), new BindTypeHandler());
        typeHandlers.put(RosterPacket.class.getName(), new RosterPacketTypeHandler());
        typeHandlers.put(Presence.class.getName(), new PresenceTypeHandler());
        typeHandlers.put(Message.class.getName(), new MessageTypeHandler());
        typeHandlers.put(EmptyResultIQ.class.getName(), new EmptyResultIQTypeHandler());
        Services.getInstance().registerInitializationCallback(new InitializationCallback(){

            public void initializationDone() {
                App app = StructrApp.getInstance();
                try (Tx tx = app.tx();){
                    for (XMPPClient xMPPClient : app.nodeQuery(XMPPClient.class).getAsList()) {
                        xMPPClient.setProperty((PropertyKey)XMPPClient.isConnected, false);
                        if (!((Boolean)xMPPClient.getProperty((PropertyKey)XMPPClient.isEnabled)).booleanValue()) continue;
                        XMPPContext.connect(xMPPClient);
                    }
                    tx.success();
                }
                catch (Throwable throwable) {
                    logger.warn("", throwable);
                }
            }
        });
    }

    public static class StructrXMPPConnection
    implements ConnectionListener,
    XMPPClientConnection,
    StanzaListener {
        private AbstractXMPPConnection connection = null;
        private Exception exception = null;
        private boolean isAuthenticated = false;
        private boolean isConnected = false;
        private String name = null;
        private String uuid = null;
        private String resource = null;
        private String jid = null;

        public StructrXMPPConnection(XMPPInfo xMPPInfo, AbstractXMPPConnection abstractXMPPConnection) {
            this.connection = abstractXMPPConnection;
            this.uuid = xMPPInfo.getUuid();
            this.name = xMPPInfo.getUsername() + "@" + xMPPInfo.getHostName();
            abstractXMPPConnection.addConnectionListener((ConnectionListener)this);
            abstractXMPPConnection.addAsyncStanzaListener((StanzaListener)this, (StanzaFilter)ForEveryStanza.INSTANCE);
        }

        @Override
        public void sendMessage(String string, String string2) throws FrameworkException {
            if (this.isConnected) {
                try {
                    Message message = new Message(string);
                    message.setBody(string2);
                    this.connection.sendStanza((Stanza)message);
                }
                catch (SmackException.NotConnectedException notConnectedException) {
                    throw new FrameworkException(422, "Not connected");
                }
            } else {
                throw new FrameworkException(422, "Not connected");
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void sendChatMessage(String string, String string2, String string3) throws FrameworkException {
            if (!this.isConnected) throw new FrameworkException(422, "Not connected");
            try {
                MultiUserChat multiUserChat;
                MultiUserChatManager multiUserChatManager = MultiUserChatManager.getInstanceFor((XMPPConnection)this.connection);
                if (multiUserChatManager == null || (multiUserChat = multiUserChatManager.getMultiUserChat(string)) == null) return;
                if (!multiUserChat.isJoined()) {
                    multiUserChat.join(this.name, string3);
                }
                multiUserChat.sendMessage(string2);
                return;
            }
            catch (SmackException | XMPPException.XMPPErrorException throwable) {
                throw new FrameworkException(422, "Connection error: " + throwable.getMessage());
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void joinChat(String string, String string2, String string3) throws FrameworkException {
            if (!this.isConnected) throw new FrameworkException(422, "Not connected");
            try {
                MultiUserChat multiUserChat;
                MultiUserChatManager multiUserChatManager = MultiUserChatManager.getInstanceFor((XMPPConnection)this.connection);
                if (multiUserChatManager == null || (multiUserChat = multiUserChatManager.getMultiUserChat(string)) == null) return;
                DiscussionHistory discussionHistory = new DiscussionHistory();
                long l = TimeUnit.SECONDS.toMillis(10L);
                discussionHistory.setMaxChars(0);
                discussionHistory.setMaxStanzas(0);
                if (string3 != null) {
                    multiUserChat.join(string2, string3, discussionHistory, l);
                    return;
                } else {
                    multiUserChat.join(string2, "", discussionHistory, l);
                }
                return;
            }
            catch (SmackException | XMPPException.XMPPErrorException throwable) {
                throw new FrameworkException(422, "Connection error: " + throwable.getMessage());
            }
        }

        @Override
        public void setPresence(Presence.Mode mode) throws FrameworkException {
            if (this.isConnected) {
                try {
                    Presence presence = new Presence(Presence.Type.available);
                    presence.setMode(mode);
                    this.connection.sendStanza((Stanza)presence);
                }
                catch (SmackException.NotConnectedException notConnectedException) {
                    throw new FrameworkException(422, "Not connected");
                }
            } else {
                throw new FrameworkException(422, "Not connected");
            }
        }

        @Override
        public void subscribe(String string) throws FrameworkException {
            if (this.isConnected) {
                try {
                    Presence presence = new Presence(Presence.Type.subscribe);
                    presence.setTo(string);
                    this.connection.sendStanza((Stanza)presence);
                }
                catch (SmackException.NotConnectedException notConnectedException) {
                    throw new FrameworkException(422, "Not connected");
                }
            } else {
                throw new FrameworkException(422, "Not connected");
            }
        }

        @Override
        public void confirmSubscription(String string) throws FrameworkException {
            if (this.isConnected) {
                try {
                    Presence presence = new Presence(Presence.Type.subscribed);
                    presence.setTo(string);
                    this.connection.sendStanza((Stanza)presence);
                }
                catch (SmackException.NotConnectedException notConnectedException) {
                    throw new FrameworkException(422, "Not connected");
                }
            } else {
                throw new FrameworkException(422, "Not connected");
            }
        }

        @Override
        public void denySubscription(String string) throws FrameworkException {
            if (this.isConnected) {
                try {
                    Presence presence = new Presence(Presence.Type.unsubscribed);
                    presence.setTo(string);
                    this.connection.sendStanza((Stanza)presence);
                }
                catch (SmackException.NotConnectedException notConnectedException) {
                    throw new FrameworkException(422, "Not connected");
                }
            } else {
                throw new FrameworkException(422, "Not connected");
            }
        }

        @Override
        public void unsubscribe(String string) throws FrameworkException {
            if (this.isConnected) {
                try {
                    Presence presence = new Presence(Presence.Type.unsubscribe);
                    presence.setTo(string);
                    this.connection.sendStanza((Stanza)presence);
                }
                catch (SmackException.NotConnectedException notConnectedException) {
                    throw new FrameworkException(422, "Not connected");
                }
            } else {
                throw new FrameworkException(422, "Not connected");
            }
        }

        @Override
        public Exception getException() {
            return this.exception;
        }

        @Override
        public boolean isConnected() {
            return this.isConnected;
        }

        @Override
        public boolean isAuthenticated() {
            return this.isAuthenticated;
        }

        @Override
        public void disconnect() {
            if (this.isConnected) {
                this.connection.disconnect();
            }
        }

        public String getUuid() {
            return this.uuid;
        }

        public void setJID(String string) {
            this.jid = string;
        }

        public void setResource(String string) {
            this.resource = string;
        }

        public void connected(XMPPConnection xMPPConnection) {
            this.isConnected = true;
            try {
                this.connection.login();
            }
            catch (Exception exception) {
                logger.warn("", (Throwable)exception);
            }
        }

        public void authenticated(XMPPConnection xMPPConnection, boolean bl) {
            this.isAuthenticated = true;
        }

        public void connectionClosed() {
            this.isConnected = false;
        }

        public void connectionClosedOnError(Exception exception) {
            this.isConnected = false;
            this.exception = exception;
        }

        public void reconnectionSuccessful() {
            this.isConnected = true;
        }

        public void reconnectingIn(int n) {
        }

        public void reconnectionFailed(Exception exception) {
            this.isConnected = false;
            this.exception = exception;
        }

        public void processPacket(Stanza stanza) throws SmackException.NotConnectedException {
            TypeHandler typeHandler = (TypeHandler)typeHandlers.get(stanza.getClass().getName());
            if (typeHandler != null) {
                typeHandler.handle(this, stanza);
            } else {
                logger.warn("No type handler for type {}", (Object)stanza.getClass().getName());
            }
        }
    }
}

