/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.cron;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.agent.Agent;
import org.structr.agent.ReturnValue;
import org.structr.agent.Task;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.web.cron.UpdateFeedTask;
import org.structr.web.entity.feed.DataFeed;

public class UpdateFeedAgent<T extends DataFeed>
extends Agent<T> {
    private static final Logger logger = LoggerFactory.getLogger((String)UpdateFeedAgent.class.getName());

    public ReturnValue processTask(Task task) throws Throwable {
        logger.debug("Processing task {}", (Object)task.getClass().getName());
        App app = StructrApp.getInstance();
        try (Tx tx = app.tx(true, true, false);){
            for (DataFeed dataFeed : task.getNodes()) {
                logger.debug("Updating data feed {} if due", dataFeed.getProperty((PropertyKey)DataFeed.name));
                dataFeed.updateIfDue();
            }
            tx.success();
        }
        return ReturnValue.Success;
    }

    public Class getSupportedTaskType() {
        return UpdateFeedTask.class;
    }

    public boolean createEnclosingTransaction() {
        return false;
    }
}

