/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.entity.feed;

import com.rometools.rome.feed.synd.SyndEnclosure;
import com.rometools.rome.feed.synd.SyndEntry;
import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.io.FeedException;
import com.rometools.rome.io.SyndFeedInput;
import com.rometools.rome.io.XmlReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.GraphObjectComparator;
import org.structr.common.SecurityContext;
import org.structr.common.View;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.core.Export;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.NodeAttribute;
import org.structr.core.graph.NodeInterface;
import org.structr.core.property.EndNodes;
import org.structr.core.property.ISO8601DateProperty;
import org.structr.core.property.IntProperty;
import org.structr.core.property.LongProperty;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.core.property.StringProperty;
import org.structr.schema.SchemaService;
import org.structr.web.entity.feed.FeedItem;
import org.structr.web.entity.feed.FeedItemContent;
import org.structr.web.entity.feed.FeedItemEnclosure;
import org.structr.web.entity.relation.FeedItems;

public class DataFeed
extends AbstractNode {
    private static final Logger logger = LoggerFactory.getLogger((String)DataFeed.class.getName());
    public static final Property<List<FeedItem>> items = new EndNodes("items", FeedItems.class);
    public static final Property<String> url = new StringProperty("url").indexed();
    public static final Property<String> feedType = new StringProperty("feedType").indexed();
    public static final Property<String> description = new StringProperty("description").indexed();
    public static final Property<Long> updateInterval = new LongProperty("updateInterval");
    public static final Property<Date> lastUpdated = new ISO8601DateProperty("lastUpdated");
    public static final Property<Long> maxAge = new LongProperty("maxAge");
    public static final Property<Integer> maxItems = new IntProperty("maxItems");
    public static final View defaultView = new View(DataFeed.class, "public", new Property[]{id, type, url, items, feedType, description});
    public static final View uiView = new View(DataFeed.class, "ui", new Property[]{id, name, owner, type, createdBy, deleted, hidden, createdDate, lastModifiedDate, visibleToPublicUsers, visibleToAuthenticatedUsers, visibilityStartDate, visibilityEndDate, url, items, feedType, description, lastUpdated, maxAge, maxItems, updateInterval});

    public boolean onCreation(SecurityContext securityContext, ErrorBuffer errorBuffer) throws FrameworkException {
        this.updateFeed(true);
        return super.onCreation(securityContext, errorBuffer);
    }

    @Export
    public void cleanUp() {
        Integer n = (Integer)this.getProperty((PropertyKey)maxItems);
        Long l = (Long)this.getProperty((PropertyKey)maxAge);
        int n2 = 0;
        if (n != null || l != null) {
            List list = (List)this.getProperty((PropertyKey)items);
            list.sort(new GraphObjectComparator(FeedItem.pubDate, "desc"));
            for (FeedItem feedItem : list) {
                Date date = (Date)feedItem.getProperty((PropertyKey)FeedItem.pubDate);
                if ((n == null || ++n2 <= n) && (l == null || !date.before(new Date(new Date().getTime() - l)))) continue;
                try {
                    StructrApp.getInstance().delete((NodeInterface)feedItem);
                }
                catch (FrameworkException frameworkException) {
                    logger.error("Error while deleting old/surplus feed item " + (Object)((Object)feedItem), (Throwable)frameworkException);
                }
            }
        }
    }

    @Export
    public void updateIfDue() {
        Date date = (Date)this.getProperty((PropertyKey)lastUpdated);
        Long l = (Long)this.getProperty((PropertyKey)updateInterval);
        if (date == null || l != null && new Date().after(new Date(date.getTime() + l))) {
            this.updateFeed(true);
        }
    }

    @Export
    public void updateFeed() {
        this.updateFeed(true);
    }

    @Export
    public void updateFeed(boolean bl) {
        String string = (String)this.getProperty((PropertyKey)url);
        if (StringUtils.isNotBlank((CharSequence)string)) {
            App app = StructrApp.getInstance((SecurityContext)this.securityContext);
            try {
                URL uRL = new URL(string);
                SyndFeedInput syndFeedInput = new SyndFeedInput();
                try (XmlReader xmlReader = new XmlReader(uRL);){
                    SyndFeed syndFeed = syndFeedInput.build((Reader)xmlReader);
                    List list = syndFeed.getEntries();
                    this.setProperty((PropertyKey)feedType, syndFeed.getFeedType());
                    this.setProperty((PropertyKey)description, syndFeed.getDescription());
                    List list2 = (List)this.getProperty((PropertyKey)items);
                    for (SyndEntry syndEntry : list) {
                        FeedItemContent feedItemContent;
                        Object object2;
                        PropertyMap propertyMap = new PropertyMap();
                        String string2 = syndEntry.getLink();
                        if (app.nodeQuery(FeedItem.class).and(FeedItem.url, (Object)string2).getFirst() != null) continue;
                        propertyMap.put(FeedItem.url, (Object)syndEntry.getLink());
                        propertyMap.put((PropertyKey)FeedItem.name, (Object)syndEntry.getTitle());
                        propertyMap.put(FeedItem.author, (Object)syndEntry.getAuthor());
                        propertyMap.put(FeedItem.comments, (Object)syndEntry.getComments());
                        propertyMap.put(FeedItem.description, (Object)syndEntry.getDescription().getValue());
                        FeedItem feedItem = (FeedItem)app.create(FeedItem.class, propertyMap);
                        feedItem.setProperty((PropertyKey)FeedItem.pubDate, syndEntry.getPublishedDate());
                        LinkedList<FeedItemContent> linkedList = new LinkedList<FeedItemContent>();
                        LinkedList<FeedItemEnclosure> linkedList2 = new LinkedList<FeedItemEnclosure>();
                        List list3 = syndEntry.getContents();
                        for (Object object2 : list3) {
                            feedItemContent = (FeedItemContent)app.create(FeedItemContent.class, new NodeAttribute[0]);
                            feedItemContent.setProperty((PropertyKey)FeedItemContent.value, object2.getValue());
                            linkedList.add(feedItemContent);
                        }
                        List list4 = syndEntry.getEnclosures();
                        object2 = list4.iterator();
                        while (object2.hasNext()) {
                            feedItemContent = (SyndEnclosure)object2.next();
                            FeedItemEnclosure feedItemEnclosure = (FeedItemEnclosure)app.create(FeedItemEnclosure.class, new NodeAttribute[0]);
                            feedItemEnclosure.setProperty((PropertyKey)FeedItemEnclosure.url, feedItemContent.getUrl());
                            feedItemEnclosure.setProperty((PropertyKey)FeedItemEnclosure.enclosureLength, feedItemContent.getLength());
                            feedItemEnclosure.setProperty((PropertyKey)FeedItemEnclosure.enclosureType, feedItemContent.getType());
                            linkedList2.add(feedItemEnclosure);
                        }
                        feedItem.setProperty((PropertyKey)FeedItem.contents, linkedList);
                        feedItem.setProperty((PropertyKey)FeedItem.enclosures, linkedList2);
                        list2.add(feedItem);
                        logger.debug("Created new item: {} ({}) ", new Object[]{feedItem.getProperty((PropertyKey)FeedItem.name), feedItem.getProperty((PropertyKey)FeedItem.pubDate)});
                    }
                    this.setProperty((PropertyKey)items, list2);
                    this.setProperty((PropertyKey)lastUpdated, new Date());
                }
            }
            catch (FeedException | IOException | IllegalArgumentException | FrameworkException throwable) {
                logger.error("Error while updating feed", throwable);
            }
        }
        if (bl) {
            this.cleanUp();
        }
    }

    static {
        SchemaService.registerBuiltinTypeOverride((String)"DataFeed", (String)DataFeed.class.getName());
    }
}

